<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\VisitorController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ActionController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\MigrationController;


Route::post('customerdetail', [CustomerController::class, 'create']);
Route::post('updateCustomerDetails', [CustomerController::class, 'updateCustomerDetails']);
Route::get('getCustomerDetails', [CustomerController::class, 'list']);
Route::post('updateCode', [UserController::class, 'updateCode']);
Route::post('setup_database', [MigrationController::class, 'setup_database'])->name('setup_database');  
Route::get('install_passport', [MigrationController::class, 'install_passport'])->name('install_passport');  
Route::post('enable_logging', [MigrationController::class, 'enable_logging'])->name('enable_logging'); 
Route::post('disable_logging', [MigrationController::class, 'disable_logging'])->name('disable_logging'); 


Route::group(['middleware' => 'auth:api'], function () {
    Route::post('create-event', [EventController::class, 'create']);
    Route::get('getEventsofUser', [EventController::class, 'getEventsofUser']);
    Route::get('product-list', [ProductController::class, 'list']);
    Route::post('check_status', [UserController::class, 'getUserStatus']);
    Route::post('create-product', [ProductController::class, 'store']);
    Route::post('update-product', [ProductController::class, 'updateProduct']);
    Route::post('getVisitors', [VisitorController::class, 'getVisitors']);
    Route::post('getAllVisitors', [VisitorController::class, 'getAllVisitors']);
    Route::post('create-visitor', [VisitorController::class, 'store']);
    Route::post('update-visitor', [VisitorController::class, 'store']);
    Route::get('category-list', [VisitorController::class, 'getcategoryList']);
    Route::get('action-list', [ProductController::class, 'getactionList']);
    Route::post('create-action', [ActionController::class, 'store']);
    Route::post('update-action', [ActionController::class, 'update']);
    Route::post('create-category', [CategoryController::class, 'store']);
    Route::post('update-category', [CategoryController::class, 'update']);
    // Route::post('SendMail', [UserController::class, 'SendMail']);
    Route::post('create_visit_data', [VisitorController::class, 'create_data']);
    Route::get('get_whatsAppmsg', [VisitorController::class, 'get_whatsAppmsg']);
    Route::post('delete_visit_data', [VisitorController::class, 'delete_visit_data']);
    
    Route::get('team-members-list', [UserController::class, 'teamMembersList']);
    Route::post('make_admin_to_team_member', [UserController::class, 'makeAdminToTeamMember']);
    Route::get('event-team-members-list', [UserController::class, 'eventAssignTeamMemberList']);
    Route::post('event_assignments', [UserController::class, 'eventAssignments']);
    
    Route::post('team_member_delete', [UserController::class, 'teamMemberDelete']);
    Route::post('customer_update_permissions', [UserController::class, 'updatepermission']);
    Route::post('customer_change_password', [UserController::class, 'changePassword']);

    Route::post('add-edit-subcategory', [CategoryController::class, 'addEditSubCategory']);
    Route::get('sub-category-list', [CategoryController::class, 'subCategoryList']);

    Route::post('category-delete', [CategoryController::class, 'categoryDelete']);
    Route::post('sub-category-delete', [CategoryController::class, 'subCategoryDelete']);
    Route::post('action-delete', [ActionController::class, 'delete']);
});

Route::post('sendemail', [UserController::class, 'sendemail']);
Route::post('sendfollowupmail', [UserController::class, 'sendfollowupmail']);

Route::post('visitemail', [UserController::class, 'visitemail']);
