<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVisitorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('visitors', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->unsignedBigInteger('event_id');
            $table->foreign('event_id')->references('id')->on('events');
            $table->unsignedBigInteger('customer_id');
            $table->string('company_name')->nullable();
            $table->string('website')->nullable();
            $table->string('mobile_no')->nullable();
            $table->string('mobile_no2')->nullable();
            $table->string('mobile_no3')->nullable();
            $table->string('email')->nullable();
            $table->string('email2')->nullable();
            $table->string('state')->nullable();
            $table->string('city')->nullable();
            $table->string('address')->nullable();
            $table->string('designation')->nullable();
            $table->string('category')->nullable();
            $table->timestamp('follow_up_time')->nullable();
            $table->string('action')->nullable();
            $table->string('remarks')->nullable();
            $table->string('attended_by')->nullable();
            $table->string('rating')->nullable();
            $table->string('audio_file')->nullable();
            $table->string('front_image')->nullable();
            $table->string('back_image')->nullable();
            $table->timestamp('visited_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('visitors', function (Blueprint $table) {
            $table->dropForeign('event_id');
        });
        Schema::dropIfExists('visitors');
    }
}
