<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VisitorProduct extends Model
{
    use HasFactory;

    protected $fillable = ['visitor_id', 'product_id'];
    
    public function visitor()
    {
        return $this->hasMany(Visitor::class);
    }

    public function getProductNameAttribute()
    {
        $product_id =  $this->product_id;

        if(isset($product_id) && $product_id != '')
        {
            $product = Product::find($product_id);
        }

        return isset($product->name) && $product->name != '' ? $product->name : '';
    }
}
