<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\User;
class EventAssignment extends Model
{
    use HasFactory;
    protected $table = 'event_assignments'; 
    public $timestamps = false; 
    protected $fillable = ['id', 'fk_user_id', 'fk_event_id'];

    public function event()
    {
        return $this->belongsTo(Event::class, 'fk_event_id', 'id');
    }
	
	public function assignEventToUsers($user_id ,$event_id)
    {
	
			$update = ['fk_user_id'=>$user_id,'fk_event_id'=>$event_id];
			EventAssignment::insert($update);
		
        return true;
    }

    public static function getEventsofUser($user_id)
    {
        return EventAssignment::with('event')->select('*', 'event_assignments.is_admin as is_eventadmin')->where('fk_user_id', $user_id)->get();
    }

    public function user(){
        return $this->hasOne(User::class,'user_id','fk_user_id');
    }
	
}
