<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Visitor;
use App\Models\User;
use App\Models\Event;
use App\Models\Product;
use App\Models\Category;
use App\Models\EventImage;
use App\Models\Sendpush;
use App\Models\VisitorProduct;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use App\Models\Visit_data;
use App\Models\Visit_data_images;

class VisitorController extends Controller
{
    public $successStatus = 200;
    public $failureStatus = 203;

    public function __construct()
    {
        $this->visitor = new Visitor();
        $this->user = new User();
        $this->Category = new Category();
    }

    public function store(Request $request)
    {
        // print_r($request->all()); die;
        // DB::beginTransaction();
        try {

            // if(isset($request->visitorid)){
            //     $visitorid = $this->visitor->updateVisitor($request->all());
            // } else {
            $visitorid = $this->visitor->insertVisitor($request->all());
            // }

            if (!isset($visitorid) || $visitorid == "") {
                // TEMPORRARY ANY VISITOR AS IN APP WE ONLY USING ID
                $visitor = Visitor::with('eventImages')->first();
                $visitor->id = 0;
                $visitor->customer_id = 0;
                return response()->json(
                    [
                        'status' => true,
                        'data' => $visitor,
                    ],
                    $this->successStatus
                );
            }

            $visitor = Visitor::with('eventImages')->where('id', $visitorid)->first();
            //  if(isset($visitor->products) && $visitor->products != '')
            // {
            //     foreach ($visitor->products as $visitor_product) {
            //          $visitor_product->product_name = $visitor_product->product_name ?? '';                    
            //      }
            //  }
            if ($visitor == null) {
                return response()->json(
                    [
                        'status' => false,
                        'data' => $visitor,
                    ],
                    $this->successStatus
                );
            } else {
                return response()->json(
                    [
                        'status' => true,
                        'data' => $visitor,
                    ],
                    $this->successStatus
                );
            }
            //  DB::commit();
        } catch (\Throwable $th) {
            //  DB::rollBack();
            throw $th;
        }
    }

    public function create(Request $request)
    {
        $front_image = '';
        $back_image = '';
        $audio_file = '';
        $product_ids = $request->product_ids;
        $event_images = $request->event_images;
        $event_images_arr = [];

        $products_arr = \explode(',', $product_ids);

        $input = $request->all();

        if ($file1 = $request->file('front_image')) {
            $name = \str_replace(' ', '_', $file1->getClientOriginalName());
            $ext = $file1->getClientOriginalExtension();
            $image = md5(\microtime() . $name) . '.' . $ext;

            if ($file1->move(\public_path('uploads/visitor'), $image)) {
                $front_image = $image;
            }
        }

        if ($file2 = $request->file('back_image')) {
            $name2 = \str_replace(' ', '_', $file2->getClientOriginalName());
            $ext2 = $file2->getClientOriginalExtension();
            $image2 = md5(\microtime() . $name2) . '.' . $ext2;
            if ($file2->move(\public_path('uploads/visitor'), $image2)) {
                $back_image = $image2;
            }
        }

        if ($file3 = $request->file('audio_file')) {
            $name3 = \str_replace(' ', '_', $file3->getClientOriginalName());
            $ext3 = $file3->getClientOriginalExtension();
            $audio = md5(\microtime() . $name3) . '.' . $ext3;
            if ($file3->move(\public_path('uploads/visitor'), $audio)) {
                $audio_file = $audio;
            }
        }

        $input['front_image'] = isset($front_image) && $front_image != '' ? url('uploads/visitor') . '/' . $front_image : '';
        $input['back_image'] = isset($back_image) && $back_image != '' ? url('uploads/visitor') . '/' . $back_image : '';
        $input['audio_file'] = isset($audio_file) && $audio_file != '' ? url('uploads/visitor') . '/' . $audio_file : '';

        $create = Visitor::create($input);

        if ($visitor_id = $create->id) {
            if (isset($event_images) && !empty($event_images)) {
                foreach ($event_images as $key => $value) {
                    if (isset($value) && $value != '') {
                        $event_i_1 = \str_replace(' ', '_', $value->getClientOriginalName());
                        $event_ext1 = $value->getClientOriginalExtension();
                        $event_image = md5(\microtime() . $event_i_1) . '.' . $event_ext1;
                        if ($value->move(\public_path('uploads/event'), $event_image)) {
                            $event_image = isset($event_image) && $event_image != '' ? url('uploads/event') . '/' . $event_image : '';

                            if (isset($event_image) && $event_image != '') {
                                EventImage::create([
                                    'visitor_id' => $visitor_id,
                                    'event_id' => $request->event_id,
                                    'event_image' => $event_image,
                                ]);
                            }
                        }
                    }
                }
            }

            if (isset($products_arr) && !empty($products_arr)) {
                foreach ($products_arr as $key1 => $product_id) {
                    if (isset($product_id) && $product_id != '') {
                        VisitorProduct::create([
                            'visitor_id' => $visitor_id,
                            'product_id' => $product_id,
                        ]);
                    }
                }
            }

            $visitor = Visitor::with('eventImages')->where('id', $visitor_id)->first();
            if (isset($visitor->products) && $visitor->products != '') {
                foreach ($visitor->products as $visitor_product) {
                    $visitor_product->product_name = $visitor_product->product_name ?? '';
                }
            }
            return \response()->json([
                'status' => true,
                'data' => $visitor
            ], 200);
        } else {
            return \response()->json([
                'status' => false,
                'data' => []
            ], 203);
        }
    }

    public function getVisitors(Request $request)
    {
        try {

            $user = Auth::user();
            // dd($user);
            if ($user->is_admin == "true") {
                $is_admin = "true";
            } else {
                $is_admin = "false";
            }

            $response = $this->visitor->fetchAllVisitors($user->CustomerID, $is_admin, $request->updated_at, $request->exhibition_id, $user->user_id);

            $team_members = $this->user->fetchAllTeamMembersForEvent($request->exhibition_id);

            return response()->json(
                [
                    'status' => true,
                    'data' => $response,
                    'team_members' => $team_members
                ],
                $this->successStatus
            );
        } catch (\Throwable $th) {
            throw $th;
        }
    }

    public function getAllVisitors(Request $request)
    {
        try {

            // $user = Auth::user();
            $user = User::where('user_id', '1')->first();
            // dd($user);
            if ($user->is_admin == "true") {
                $is_admin = "true";
            } else {
                $is_admin = "false";
            }

            $response = $this->visitor->fetchAllVisitors2($user->CustomerID, $is_admin, $request->updated_at, $request->exhibition_id, $user->user_id);

            // $team_members = $this->user->fetchAllTeamMembersForEvent($request->exhibition_id);

            return response()->json(
                [
                    'status' => true,
                    'data' => $response,
                    // 'team_members' => $team_members
                ],
                $this->successStatus
            );
        } catch (\Throwable $th) {
            throw $th;
        }
    }
    public function getcategoryList()
    {
        try {
            $response = $this->Category->categoryList();
            $responseSubcat = $this->Category->subcategoryList();

            return response()->json(
                [
                    'status' => true,
                    'data' => $response,
                    'subcategory_data' => $responseSubcat
                ],
                $this->successStatus
            );
        } catch (\Throwable $th) {
            throw $th;
        }
    }
    public function create_data(Request $request)
    {

        if ($request->visitor_id != "" && $request->teammember_id != "" && $request->remarks != "") {

            $obj = new Visit_data();
            $obj->fk_teammember_id = $request->teammember_id;
            $obj->fk_visitor_id = $request->visitor_id;
            $obj->action = $request->action;
            $obj->remarks = $request->remarks;
            $obj->follow_up_time = $request->follow_up_time;
            $obj->lat = $request->lat;
            $obj->lng = $request->lng;
            $obj->visit_time = $request->visit_time;
            $obj->attend_by = $request->attend_by;

            if ($file3 = $request->file('audio_file')) {
                // $name3 = \str_replace(' ', '_', $file3->getClientOriginalName());
                // $audio = $file3->getClientOriginalExtension();
                $audio = $file3->getClientOriginalName();
                // $audio = md5(\microtime() . $name3) . '.' . $ext3;
                if ($file3->move(\public_path('uploads/visitor'), $audio)) {
                    $audio_file = $audio;
                }
            }

            $obj->audio_file = isset($audio_file) && $audio_file != '' ? url('uploads/visitor') . '/' . $audio_file : '';
            $obj->created_at = date('Y-m-d H:i:s');
            $visit_id = $obj->save();

            $updated_at_date = date('Y-m-d H:i:s');
            Visitor::where('id', $request->visitor_id)->update(['updated_at' => $updated_at_date]);

            $visit_images_all = $request->file('visit_images');

            if (isset($visit_images_all) && !empty($visit_images_all)) {
                foreach ($visit_images_all as $key => $value) {
                    if (isset($value) && $value != '') {
                      
						$visit_image = \str_replace(' ', '_', $value->getClientOriginalName());
						
						if($visit_image == "file.png")
						{
						$event_ext1 = $value->getClientOriginalExtension();
                        $visit_image = md5(\microtime() . $visit_image) . '.' . $event_ext1;
						}
                      
                        if ($value->move(\public_path('uploads/event'), $visit_image)) {
                            $visit_image = isset($visit_image) && $visit_image != '' ? url('uploads/event') . '/' . $visit_image : '';

                            if (isset($visit_image) && $visit_image != '') {
                                $image_data = new Visit_data_images();
                                $image_data->fk_visit_id = $obj->id;
                                $image_data->visit_image = $visit_image;
                                $image_data->created_at = date('Y-m-d H:i:s');
                                $image = $image_data->save();
                            }
                        }
                    }
                }
            }
            if (isset($request->product_ids)) {
                $products_arr = explode(',', $request->product_ids);

                foreach ($products_arr as $key1 => $product_id) {
                    // dd($product_id);
                    $dataInsert = ([
                        'fk_visit_data_id' => $obj->id,
                        'fk_product_id' => $product_id,
                        'created_at' => date('Y-m-d H:i:s'),
                    ]);
                    DB::table('visit_data_product')->insert($dataInsert);
                }
            }

            $get_visitor = Visit_data::where('id', $obj->id)->first();
            $get_visitor['visit_images'] = Visit_data_images::where('fk_visit_id', $obj->id)->get();

            if (isset($request->auto_sync) && $request->auto_sync == "true") {

                // $eventIDs =  explode(',', $data['event_ids']);
                $visitor = Visitor::where('id', $request->visitor_id)->first();
                $main_admins_ids = User::where('is_admin', 'true')->pluck('user_id')->toArray();
                // $eventData = Event::with('assignes_admins')->where('id', $data['event_id'])->first();
                $eventData = Event::with(['assignes_admins' => function ($query) use ($main_admins_ids) {
                    $query->whereNotIn('fk_user_id', $main_admins_ids);
                }])->where('id', $visitor->event_id)->first();           
                if(!empty($eventData)){
                    $assignes_admins_ids = $eventData->assignes_admins->pluck('fk_user_id')->toArray();
                    $push_notifications_users_ids = array_merge($main_admins_ids, $assignes_admins_ids);
                }else{
                    $push_notifications_users_ids =  $main_admins_ids;
                }           
                $current_user_id = Auth::user()->user_id ?? null;
                if ($current_user_id !== null) {
                    $push_notifications_users_ids = array_diff($push_notifications_users_ids, [$current_user_id]);
                }                   
                $push_users =  User::whereIn('user_id', $push_notifications_users_ids)->get();

                $eventData = Event::with('assignes_admins', 'assignes_admins.user')->where('id', $visitor->event_id)->first();

                if (!empty($eventData)) {
                    $eventName =  $eventData->event_name;
                    if (count($push_users) >  0) {
                        $androidTokens = [];
                        $iosTokens = [];
                        foreach ($push_users as $assignee) {
                            if ($assignee->device_type == 'android') {
                                array_push($androidTokens,$assignee->push_token);                               
                            } else {
                                array_push($iosTokens,$assignee->push_token);
                            }                                                        
                        }
                        $title = "Client Visited";
                        $pushObj = new Sendpush();
                        $msg = $visitor->name . "is visited to " . $eventName;
                        $message = array("notification_type" => "visitor_visited", "message" => $msg, "title" => $title, 'visitor_id' => $visitor->id, 'event_id' => $visitor->event_id);
                        if(count($androidTokens) > 0){                          
                            $pushObj->sendAndriodNotification($androidTokens,$message);
                        }
                        if(count($iosTokens) > 0){                           
                            $pushObj->sendIOSNotification($iosTokens,$message,$title);
                        }                      
                    }
                }
            }

            return \response()->json([
                'status' => true,
                'data' => $get_visitor,
                'visit_updated_at' => $updated_at_date
            ], 200);
        } else {
            return \response()->json([
                'status' => false,
                'data' => []
            ], 203);
        }
    }
    public function get_whatsAppmsg()
    {
        try {
            $response = DB::table('whatsapp_msg')->orderBy('id', 'desc')->first();

            return response()->json(
                [
                    'status' => true,
                    'data' => $response,
                ],
                $this->successStatus
            );
        } catch (\Throwable $th) {
            throw $th;
        }
    }
    public function delete_visit_data(Request $request)
    {
        try {
            $response = DB::table('visit_data')->where('id', $request->visit_data_id)->delete();

            return response()->json(
                [
                    'status' => true,
                    // 'data' => $response,
                ],
                $this->successStatus
            );
        } catch (\Throwable $th) {
            throw $th;
        }
    }
}
