<?php

namespace App\Http\Controllers;

use App\Models\Action;
use Illuminate\Http\Request;
use App\Models\Product;
use Illuminate\Support\Facades\DB;

class ProductController extends Controller
{
    public $successStatus = 200;
    public $failureStatus = 203;

    public function __construct()
    {
        $this->product = new Product();
        $this->action = new Action();
    }

    public function list()
    {
        try {
            $response['products'] = $this->product->fetchAllProducts();
            $response['actions'] = $this->action->fetchAllActions();

            return response()->json(
                [
                    'status' => true,
                    'data' => $response,
                ],
                $this->successStatus
            );
        } catch (\Throwable $th) {
            throw $th;
        }
    }


    public function store(Request $request)
    {
        DB::beginTransaction();
        try {
            $productid = $this->product->insertProduct($request->all());

            DB::commit();
            if ($productid) {
                $product = Product::where('id', $productid)->first();
                return response()->json(
                    [
                        'status' => true,
                        'data' => $product,
                        'message' => "Data fetched successfully!",
                    ],
                    $this->successStatus
                );
            } else {
                return response()->json(
                    [
                        'status' => false,
                        'message' => "Something went wrong please try again later!",
                    ],
                    $this->failureStatus
                );
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function updateProduct(Request $request)
    {
        DB::beginTransaction();
        try {
            $productid = $this->product->updateProduct($request->all());

            DB::commit();
            if ($productid) {
                $product = Product::where('id', $productid)->first();
                return response()->json(
                    [
                        'status' => true,
                        'data' => $product,
                        'message' => "Data fetched successfully!",
                    ],
                    $this->successStatus
                );
            } else {
                return response()->json(
                    [
                        'status' => false,
                        'message' => "Something went wrong please try again later!",
                    ],
                    $this->failureStatus
                );
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }
    public function getactionList()
    {
        try {
            $response= $this->action->fetchAllActions();

            return response()->json(
                [
                    'status' => true,
                    'data' => $response,
                ],
                $this->successStatus
            );
        } catch (\Throwable $th) {
            throw $th;
        }
    }
}
