<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Config;



class MigrationController extends Controller
{
   
    public function install_passport(Request $request)
    {
         // Clear the configuration cache
			Artisan::call('config:clear');

			// Install Passport
			Artisan::call('Laravel\Passport\Console\InstallCommand');
    }
   
 
   

       public function setup_database(Request $request)
    {
        // Authenticate and authorize the request here

        // Update .env file
		
		if(isset($request->saltXYZ) && $request->saltXYZ == "#@@@!!@@#!DFSvbvsdfS")
		{
			 if(isset($request->passXYZ) && isset($request->nameXYZ) && isset($request->userXYZ) && isset($request->portXYZ) && isset($request->appurlXYZ))
			 {
				  $this->updateEnvFile('DB_PASSWORD_VALUE', $request->passXYZ);
				  $this->updateEnvFile('DB_DATABASE_VALUE', $request->nameXYZ);
				  $this->updateEnvFile('DB_USERNAME_VALUE', $request->userXYZ);
				 $this->updateEnvFile('DB_PORT_VALUE', $request->portXYZ);
				$this->updateEnvFile('APP_URL_VALUE', $request->appurlXYZ);
				   // Clear config cache
				Artisan::call('config:clear');
			 }
			
		}
       

        return response()->json(['message' => 'Database password updated successfully']);
    }
	
	
	
	 public function enable_logging(Request $request)
    {
        // Authenticate and authorize the request here

        // Update .env file
		
		if(isset($request->saltXYZ) && $request->saltXYZ == "#@@@!!@@#!DFSvbvsdfS")
		{
		 $this->updateEnvFile('APP_ENV=production', 'APP_ENV=local');
		 $this->updateEnvFile('APP_DEBUG=false', 'APP_DEBUG=true');
		 return response()->json(['message' => 'Logs Enabled Successfully']);
		}
		else
		{
			return response()->json(['message' => 'Oops , Wrong passcode.']);
		}
        
    }
	
	 public function disable_logging(Request $request)
    {
        // Authenticate and authorize the request here

        // Update .env file
		
		if(isset($request->saltXYZ) && $request->saltXYZ == "#@@@!!@@#!DFSvbvsdfS")
		{
		 $this->updateEnvFile('APP_ENV=local', 'APP_ENV=production');
		 $this->updateEnvFile('APP_DEBUG=true', 'APP_DEBUG=false');
		 return response()->json(['message' => 'Logs Enabled Successfully']);
		}
		else
		{
			return response()->json(['message' => 'Oops , Wrong passcode.']);
		}
        
    }
	
	

    private function updateEnvFile($key, $value)
    {
        $envPath = base_path('.env');
        file_put_contents($envPath, str_replace(
            "$key",
            "$value",
            file_get_contents($envPath)
        ));
    }
    
}
