<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Event;
use App\Models\EventAssignment;
use Illuminate\Support\Facades\Auth;
use App\Models\User;

class EventController extends Controller
{
    public $successStatus = 200;
    public $failureStatus = 203;

    public function __construct()
    {
        $this->event = new Event();
        $this->eventassignment = new EventAssignment();
    }

    function create(Request $request)
    {
        $create = Event::create($request->all());
		$userid = Auth::user()->user_id;
		$this->eventassignment->assignEventToUsers($userid,$create->id);

        if ($create) {
            return \response()->json([
                'status' => true,
                'data' => $create
            ], 200);
        } else {
            return \response()->json([
                'status' => false,
                'data' => []
            ], 203);
        }
    }

    public function getEventsofUser(Request $request)
    {
        try {
            $userid = Auth::user()->user_id;
            $response = $this->eventassignment->getEventsofUser($userid);

            return response()->json(
                [
                    'status' => true,
                    'data' => $response,
                ],
                $this->successStatus
            );
        } catch (\Throwable $th) {
            throw $th;
        }
    }
}
