<?php
// NEW UPDATES OF CUSTOMERS WILL BE NOW USERS IN USERCONTROLLER
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Customer;
use App\Models\CustomerEmail;

class CustomerController extends Controller
{
    public function list(Request $request)
    {
        $CustomerEmail = CustomerEmail::where('fk_CustomerID', $request->id)->first();

        if($CustomerEmail && !empty($CustomerEmail) && $CustomerEmail != '')
        {
            $attachment = explode(',', $CustomerEmail['attachment']);
            $isImage = explode(',', $CustomerEmail['isImage']);
            $documents = [];
            foreach ($attachment as $key => $val)
            {
                if($val == '' || $val == null) continue;
                $temp['attachment'] = 'pdf_files/'.$request->id.'/'.$val;
                $temp['isImage'] = $isImage[$key];
                array_push($documents, $temp);
            }

            $CustomerEmail->attachment = $documents;

            return response()->json([
                'status' => true,
                'data' => $CustomerEmail
            ]);
        }
        else
        {
            return response()->json([
                'status' => false,
                'data' => [],
                'msg' => 'Customer Data Not Found'
            ], 201);
        }
    }

    public function create(Request $request)
    {
        $input = $request->all();

        $customerDetails = Customer::find($request->CustomerID);

        if(empty($customerDetails) || $customerDetails == '' || $customerDetails == NULL)
        {
            $customerDetails = Customer::create($input);
        }
        else
        {
            $customerDetails->update($input);
        }

        if(empty($customerDetails) || $customerDetails == '' || $customerDetails == NULL)
        {
            return response()->json([
                'status' => false,
                'data' => [],
                'message' => 'Something Went Wrong!'
            ], 203);
        }
        
        $customerDetails = $customerDetails->fresh();
        $customerDetails->activestatus = $customerDetails->status;
        $customerDetails->maxvisitor = $customerDetails->status == 'false' ? 20 : 20000;
        $customerDetails->import = false;
        $customerDetails->expiry_Title = "Your Subscription is Expired ";
        $customerDetails->expiry_message = "Your Subscription is Expired , Please Contact support for Activation";
        $customerDetails->expiry_Title = "Your Subscription is Expired ";
        $customerDetails->phone = "+919662661991";
        $customerDetails->email = "info@frenzinsoftwares.com";
        $customerDetails->access_message = "Please Contact Support";
        $customerDetails->status = true;
        $customerDetails = $customerDetails->toArray();
        
        if($customerDetails && !empty($customerDetails))
        {
            return response()->json($customerDetails);
        }
        else
        {
            return response()->json([
                'status' => false,
                'data' => []
            ]);
        }
    }

    public function updateCustomerDetails(Request $request)
    {
        $input = $request->all();

        $attachments = $request->file('attachment');
        $attachment = null;
        $isImage = null;

        if(isset($attachments) && !empty($attachments))
        {
            foreach ($attachments as $key => $value) {
                if($value && !empty($value) && $value != '')
                {
                    $name = \str_replace(' ', '_', $value->getClientOriginalName());
                    $ext = $value->getClientOriginalExtension();
                    $image = md5(microtime() . $name) . "." . $ext;

                    if($value->move(public_path('pdf_files/'.$request->CustomerID), $image))
                    {
                        $attachment .= $image.',';
                        $isImage .= $input['isImage'][$key].',';
                    }
                }
            }
        }

        $input['attachment'] = substr_replace($attachment ,"", -1);
        $input['isImage'] = substr_replace($isImage ,"", -1);
        $input['fk_CustomerID'] = $request->CustomerID;

        $CustomerEmail = CustomerEmail::where('fk_CustomerID', $request->CustomerID)->first();

        if(empty($CustomerEmail) || $CustomerEmail == '' || $CustomerEmail == NULL)
        {
            $CustomerEmail = CustomerEmail::create($input);
        }
        else
        {
            $CustomerEmail->update($input);
        }

        if(empty($CustomerEmail) || $CustomerEmail == '' || $CustomerEmail == NULL)
        {
            $CustomerEmail->CustomerID = $CustomerEmail->fk_CustomerID;

            return response()->json([
                'status' => false,
                'data' => [],
                'message' => 'Something Went Wrong!'
            ], 203);
        }

        if($CustomerEmail && !empty($CustomerEmail))
        {
            return response()->json($CustomerEmail);
        }
        else
        {
            return response()->json([
                'status' => false,
                'data' => []
            ]);
        }
    }
}
