<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\Action;
use Illuminate\Support\Facades\Validator;

class ActionController extends Controller
{
    public $successStatus = 200;
    public $failureStatus = 203;

    public function __construct()
    {
        $this->action = new Action();
    }

    public function store(Request $request)
    {
        DB::beginTransaction();
        try {
            $actionid = $this->action->insertAction($request->all());

            DB::commit();
            if ($actionid) {
                $action = Action::where('id', $actionid)->first();
                return response()->json(
                    [
                        'status' => true,
                        'data' => $action,
                        'message' => "Data fetched successfully!",
                    ],
                    $this->successStatus
                );
            } else {
                return response()->json(
                    [
                        'status' => false,
                        'message' => "Something went wrong please try again later!",
                    ],
                    $this->failureStatus
                );
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }
    public function update(Request $request)
    {
        DB::beginTransaction();
        try {
            $actionid = $this->action->updateAction($request->all());

            DB::commit();
            if ($actionid) {
                $action = Action::where('id', $actionid)->first();
                return response()->json(
                    [
                        'status' => true,
                        'data' => $action,
                        'message' => "Data fetched successfully!",
                    ],
                    $this->successStatus
                );
            } else {
                return response()->json(
                    [
                        'status' => false,
                        'message' => "Something went wrong please try again later!",
                    ],
                    $this->failureStatus
                );
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
        
    }

    public function delete(Request $request){
        
        $validator = Validator::make($request->all(), [
            'id' => 'required|exists:actions,id',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => false,
                'data' => [],
                'msg' => $validator->errors(),
            ], 400);
        }
        
        Action::destroy($request->id);

        return response()->json(
            [
                'status' => true,
                'message' => "Action Deleted Successfully",
            ],
            $this->successStatus
        );
    }
}
