<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Edit Email Draft</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('emails.index')); ?>">Email Draft</a></li>
                        <li class="breadcrumb-item active">Edit Email Draft</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="post" action="<?php echo e(route('emails.update', $emails->id)); ?>" name="form" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>

                                <div class="form-group ml-3">
                                    <label class="form-label">Select Email Type</label>
                                    <select class="form-control col-lg-10" name="email_type" id="email_type" required>
                                        <option value="" selected disabled>Select Email Type</option>
                                        <option value="primary" <?php echo e(old('email_type', $emails->email_type) == 'primary' ? 'selected' : ''); ?>>Primary</option>
                                        <option value="follow_up" <?php echo e(old('email_type', $emails->email_type) == 'follow_up' ? 'selected' : ''); ?>>Follow Up</option>
                                        <option value="other" <?php echo e(old('email_type', $emails->email_type) == 'other' ? 'selected' : ''); ?>>Other</option>
                                    </select>
                                </div>
                                <div class="form-group ml-3">
                                    <label class="form-label">Subject</label>
                                    <input type="text" name="subject" class="form-control col-lg-10" id="subject" value="<?php echo e(old('subject', $emails->subject)); ?>" placeholder="Enter Subject" required>
                                </div>
                                <div class="form-group ml-3">
                                    <label class="form-label">Content</label>
                                    <textarea class="editor" name="content" id="content" cols="30" rows="10"><?php echo e(old('content', $emails->content)); ?></textarea>
                                </div>
                                    
                                    <div class="form-group ml-3">
                                        <label class="form-label">Attachment</label>
                                            <?php $__currentLoopData = $get_image; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="image-container" style="position: relative; display: inline-block; margin-right: 10px;">
                                                    <!-- <img src="<?php echo e(asset(UPLOAD_EMAIL . $image->attachment)); ?>" alt="" class="img" style="height: 85px; width: 85px"> -->
                                                    <?php if(pathinfo($image->attachment, PATHINFO_EXTENSION) === 'pdf'): ?>
                                                        <img src="<?php echo e(asset('pdficon.png')); ?>" alt="PDF Icon" class="img" style="height: 94px; width: 85px">
                                                    <?php else: ?>
                                                        <img src="<?php echo e(asset(UPLOAD_EMAIL . $image->attachment)); ?>" alt="" class="img" style="height: 85px; width: 85px">
                                                    <?php endif; ?>
                                                    <i style="position: absolute; top: 5px; right: 5px; font-size: 15px; color: white; cursor: pointer;" 
                                                        onclick="deletePopupfile(this)" class="fa fa-times" data-id="<?php echo e($image->id); ?>" value="<?php echo e($image->id); ?>" data-url="<?php echo e(route('delete', ['id' => $image->id])); ?>"></i>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                    <div class="form-group ml-3">
                                        <label class="form-label">Attachment Name : </label>
                                        <?php $__currentLoopData = $get_image; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php 
                                                $imageName = basename($image->attachment);     
                                            ?>
                                            <?php echo e($imageName); ?><?php if(isset($image->attachment)): ?> ,<?php endif; ?> 
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                    <div class="form-group ml-3">
                                        <input class="form-control col-lg-10" type="file" name="attachment[]" id="attachment" multiple>
                                    </div>
                                <div class="card-footer">
                                    <button type="submit" class="btn btn-primary" >Submit</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function () {
        CKEDITOR.replace( 'content' );
    });
</script>
<script>
    function deletePopupfile(elm) {
        var imageId = $(elm).attr('data-id');
        var url = $(elm).data('url');
        swal({
            title: 'Are you sure!',
            icon: 'error',
            dangerMode: true,
            buttons: true,
            confirm: "Confirm",
        }).then(function(isConfirm) {
            if (isConfirm === true) {
                $.ajax({
                    type: 'GET',
                    url: url,
                    dataType: 'json',
                    success: function(data) {
                        window.location.reload();
                    },
                    error: function(data) {
                        console.log(data);
                    }
                });
            }
        });
    }
   
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/asojsoftcaps/public_html/frenzincrm.asojsoftcaps.com/frenzincrm/resources/views/email/edit.blade.php ENDPATH**/ ?>