<?php $__env->startSection('content'); ?>
<style>
img {  
    height:auto;
    width: 60px;
object-fit: scale-down;  
} 
</style>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Product List</h1>
                </div>
                <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
                        <li class="breadcrumb-item active">Product</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Product</h3>
                            <div class="card-tools">
                                <a href="<?php echo e(route('product.add')); ?>" class="btn btn-sm btn-primary"><i class="fa fa-plus"></i> Add Product</a>
                            </div>
                        </div>
                        <div class="card-body">
                            <?php echo e($dataTable->table()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- image file Modal -->
<div class="modal fade" id="modalimagefile" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalimagefileTitle">File List</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="table-responsive text-nowrap">
                    <div class="card-tools">
                        <form method="get" action="<?php echo e(route('product.addimage')); ?>" name="form"
                            enctype="multipart/form-data">
                            <button type="submit" class="btn btn-sm btn-primary" style="float: right;">Add More</button>
                            <input type="hidden" name="product_id" id="product_id" class="form-control" value="">
                        </form>
                        <br>
                    </div>
                    <br>
                    <table class="table">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>File</th>
                                <th>Description</th>
                                <th></th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody class="table-border-bottom-0" id="showfilewithimage">
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<!--name product Modal -->
<div class="modal fade" id="editnameModal" tabindex="-1" role="dialog" aria-labelledby="editnameModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="editnameModalLabel">Update Product Name</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <form action="<?php echo e(route('product.updateName')); ?>" method="post">
              <?php echo csrf_field(); ?>
              <input type="hidden" name="id" id="modalId" class="form-control" value="">
              <div class="form-group">
                  <label for="">Name</label>
                  <input type="text" name="name" class="form-control" id="modalname" value="modalname" required>
              </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-primary">Update</button>
        </div>
      </form>
      </div>
    </div>
  </div>
<?php $__env->startPush('scripts'); ?>
<?php echo e($dataTable->scripts()); ?>

<?php $__env->stopPush(); ?>

<script>
    function showfilewithimage(elm) {
        var product_id = $(elm).attr('data-id');
        $.ajax({
            url: "<?php echo e(url('ajax/get_imagefile')); ?>",
            type: "GET",
            data: {
                product_id: product_id,
            },
            success: function(response) {
                if (response) {
                    $("#showfilewithimage").html('');
                    $.each(response['data'], function(i, item) {
                        var url = '<?php echo e(route("product.editimage", "file_id=:id")); ?>';
                        url = url.replace(':id', item.id);

                        var url_file = '<?php echo e(route("product.filedestroy", "fileid=:id")); ?>';
                        url_file = url_file.replace(':id', item.id);
                    
                        var imageName = item.image.split('/').pop();
                        var imageNameX = item.image.split('.').pop();
                        var html = `<tr>
                            <td><strong>${item['id']}</strong></td>      
                            <td>  
                                <a href="${item['image']}" target="_blank" style="text-decoration: none;">
                                    ${imageNameX === 'pdf' ? `<i class="far fa-file-pdf pdf-icon fa-2x" style="color:red;"></i> ${imageName}` : `<img src="${item['image']}" alt="" class="img">`}
                                </a>  
                            </td>
                            <td>${item['description']}</td>  
                            <td>
                                <a href="${url}">
                                    <button style="margin-left:-25px;color: white;" class="btn btn-block bg-gradient-info btn-sm" data-toggle="tooltip" data-placement="left" title="Edit">
                                        <i class="bx bxs-edit" aria-hidden="true"></i>Edit
                                    </button>
                                </a>
                            </td>     
                            <td>
                                <a data-toggle="modal" data-target="#deletePopupfile" data-url="${url_file}" onclick="deletePopupfile(this)">
                                    <button class="btn btn-danger btn-sm" data-toggle="tooltip" data-placement="right" title="Delete ">
                                        <i class="fas fa-trash" aria-hidden="true"></i>
                                    </button>
                                </a>
                            </td>
                        </tr>`;
                        $('#product_id').val(product_id);
                        $("#showfilewithimage").append(html);
                        $("#modalimagefile").modal('show');
                    });
                } else {
                    $("#showfilewithimage").html('');
                    $('#product_id').val(product_id);
                    $("#modalimagefile").modal('show');
                    // alert('no data found!')
                }
            },
            error: function(error) {
                console.log(error);
            }
        });
    }
    function deletePopupfile(elm) {
        let id = $(elm).data('id');
        let url = $(elm).data('url');
        swal({
            title: 'Are you sure!',
            icon: 'error',
            dangerMode: true,
            buttons: true,
            confirm: "Confirm",
        }).then(function(isConfirm) {
            if (isConfirm === true) {
                $.ajax({
                    type: 'GET',
                    url: url,
                    dataType: 'json',
                    success: function(data) {
                        window.location.reload();
                        // console.log(data);
                    },
                    error: function(data) {
                        console.log(data);
                    }
                });
            }
        });
    }
    function editname(id) {
        $('#modalname').val($('.btn-'+id).data('name'));
        $('#modalId').val(id);
        $('#editnameModal').modal('show');
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/asojsoftcaps/public_html/frenzincrm.asojsoftcaps.com/frenzincrm/resources/views/product/index.blade.php ENDPATH**/ ?>