<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Email Draft List</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
                        <li class="breadcrumb-item active">Email Draft</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <!-- Default box -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Email Drafts</h3>
                    <div class="card-tools">
                        <a href="<?php echo e(route('emails.create')); ?>" class="btn btn-sm btn-primary"><i class="fa fa-plus"></i> Add Draft</a>
                    </div>
                </div>
                <div class="card-body">
                    <table class="table table-bordered data-table">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>EmailType</th>
                                <th>Subject</th>
                                <th>Content</th>
                                <!-- <th>Attachment</th> -->
                                <th width="25%">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
  $(function () {
    
    var table = $('.data-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: "<?php echo e(route('emails.index')); ?>",
        columns: [
            {data: 'id', name: 'id'},
            {data: 'email_type', name: 'email_type'},
            {data: 'subject', name: 'subject'},
            {data: 'content', name: 'content'},
            // {data: 'attachment', name: 'attachment'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });
    
  });

  
function confirmDelete(elm) {
    var id = elm.id;
    var token = $('meta[name="csrf-token"]').attr('content');

    var deleteConfirm = confirm("Are you sure want to delete?");
    if (deleteConfirm == true) {
        $.ajax({
            url: "<?php echo e(url('setting/emails')); ?>" + '/' + id,
            method: 'DELETE',
            data: {"_token": token},
            success: function(response){
                if(response.status){
                    // toastr.success(response.message);
                    location.reload();
                }else{
                    toastr.error(response.message);
                }
            }
        });
    }
}

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/asojsoftcaps/public_html/frenzincrm.asojsoftcaps.com/frenzincrm/resources/views/email/index.blade.php ENDPATH**/ ?>