<?php

$currentpath = Route::getFacadeRoot()
    ->current()
    ->uri();

ob_start();

$cut = strpos($currentpath, '/');

if ($cut) {
    $pagename = substr($currentpath, 0, $cut);
} else {
    $pagename = $currentpath;
}
//   echo $pagename; die;
?>
<aside class="main-sidebar sidebar-dark-primary elevation-4">
    <a href="#" class="brand-link">
        <img src="<?php echo e(asset('assets/dist/img/AdminLTELogo.png')); ?>" alt="Client"
            class="brand-image img-circle elevation-3" style="opacity: .8">
        <span class="brand-text font-weight-light">FrenzinCRM</span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
        <div class="user-panel mt-3 pb-3 mb-3 d-flex">
            <div class="image">
                <img src="<?php echo e(asset('assets/dist/img/user2-160x160.jpg')); ?>" class="img-circle elevation-2"
                    alt="User Image">
            </div>
            <div class="info">
                <a href="#" class="d-block">Admin</a>
            </div>
        </div>

        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                data-accordion="false">
                
                <li class="nav-item">
                    <a href="<?php echo e(route('dashboard')); ?>" class="nav-link <?php echo e(isset($pagename) && $pagename == 'dashboard' ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-tachometer-alt"></i>
                        <p>
                            Dashboard
                        </p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('users.list')); ?>" class="nav-link <?php echo e(isset($pagename) && $pagename == 'user' ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-table"></i>
                        <p>
                            Team Members
                        </p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('event.list')); ?>" class="nav-link <?php echo e(isset($pagename) && $pagename == 'event' ? 'active' : ''); ?>">
                        <i class="nav-icon far fa-calendar-alt"></i>
                        <p>
                            Events
                        </p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('visitor.list')); ?>" class="nav-link <?php echo e(isset($pagename) && $pagename == 'visitor' ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-table"></i>
                        <p>
                            Client
                        </p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('product.list')); ?>" class="nav-link <?php echo e(isset($pagename) && $pagename == 'product' ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-chart-pie"></i>
                        <p>
                           Product
                        </p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('category.list')); ?>" class="nav-link <?php echo e(isset($pagename) && $pagename == 'category' ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-list-alt"></i>
                        <p>
                            Category
                        </p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('sub_category.list')); ?>" class="nav-link <?php echo e(isset($pagename) && $pagename == 'sub_category' ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-list-alt"></i>
                        <p>
                            Sub Category
                        </p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('action.list')); ?>" class="nav-link <?php echo e(isset($pagename) && $pagename == 'action' ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-list-alt"></i>
                        <p>
                            Action
                        </p>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo e(isset($pagename) && $pagename == 'setting' ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-chart-pie"></i>
                        <p>
                           Settings
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <?php if(auth()->user()->type == 'admin'): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(route('setting.subAdminList')); ?>"
                                   class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Add Sub-Admin</p>
                                </a>
                            </li>
                        <?php endif; ?>
                        <li class="nav-item">
                            <a href="<?php echo e(route('setting.whatsapp_msg')); ?>" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Whatsapp Settings</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('emails.index')); ?>" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Email Drafts</p>
                            </a>
                        </li>
                        <?php if(auth()->user()->type == 'admin'): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(route('setting.martkey')); ?>"
                                   class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>SMTP Settings</p>
                                </a>
                            </li>
                        <?php endif; ?>
                        <li class="nav-item">
                            <a href="<?php echo e(route('setting.upload_image')); ?>"
                            class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Upload Image</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('setting.region')); ?>"
                            class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Region</p>
                            </a>
                        </li>
                        <?php if(auth()->user()->type == 'admin'): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(route('setting.divisionList')); ?>"
                                   class="nav-link">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Division</p>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('setting.change_password')); ?>" class="nav-link <?php echo e(isset($pagename) && $pagename == 'change_password' ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-chart-pie"></i>
                        <p>
                          Change Password
                        </p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('visitor.batch-list')); ?>" class="nav-link <?php echo e(isset($pagename) && $pagename == 'batch' ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-chart-pie"></i>
                        <p>
                            Client Batch Email
                        </p>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('logout')); ?>"
                        onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                        <i class="nav-icon fas fa-power-off"></i>
                        <p>
                            <?php echo e(__('Logout')); ?>

                        </p>
                    </a>
                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                        <?php echo csrf_field(); ?>
                    </form>
                </li>
            </ul>
        </nav>
    </div>
</aside>
<?php /**PATH /home/asojsoftcaps/public_html/frenzincrm.asojsoftcaps.com/frenzincrm/resources/views/layouts/sidebar.blade.php ENDPATH**/ ?>