<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;

use App\Http\Controllers\MigrationController;
use App\Http\Controllers\NotificationController;

Route::get('/', function () {
    return redirect('/login');
});

Route::group([], function ()
{
    define('UPLOAD_EMAIL', '/uploads/email/attachments/');
    define('UPLOAD_IMAGE', '/uploads/images/');
});

Auth::routes();

Route::get('/dashboard', [App\Http\Controllers\HomeController::class, 'index'])->name('dashboard');
Route::get('/run_migration', [App\Http\Controllers\MigrationController::class, 'run_migration'])->name('run_migration');  
Route::get('/run_seeders_basic', [App\Http\Controllers\MigrationController::class, 'run_seeders_basic'])->name('run_seeders_basic');  
Route::get('/run_seeders_countries', [App\Http\Controllers\MigrationController::class, 'run_seeders_countries'])->name('run_seeders_countries');  

Route::post('/setup_database', [App\Http\Controllers\MigrationController::class, 'setup_database'])->name('setup_database');  
Route::post('/enable_logging', [App\Http\Controllers\MigrationController::class, 'enable_logging'])->name('enable_logging'); 
Route::post('/disable_logging', [App\Http\Controllers\MigrationController::class, 'disable_logging'])->name('disable_logging'); 
// Route::get('charts','HomeController@chartjs');

// users
Route::group(['prefix' => 'user'], function () {
    Route::get('/list', [App\Http\Controllers\UserController::class, 'index'])->name('users.list');
    Route::get('/destroy/{user_id}', [App\Http\Controllers\UserController::class, 'destroy'])->name('users.destroy');
    Route::get('/permissionsview', [App\Http\Controllers\UserController::class, 'permissionsview'])->name('users.permissionsview');
    Route::post('/update', [App\Http\Controllers\UserController::class, 'updatepermission'])->name('users.updatepermission');

    // Route::get('/store', [App\Http\Controllers\UserController::class, 'store'])->name('users.store');
    Route::post('/updateIsAdmin', [App\Http\Controllers\UserController::class, 'updateIsAdmin'])->name('users.updateIsAdmin');
    Route::post('/edit-user-email', [App\Http\Controllers\UserController::class, 'updateEmail'])->name('edit-user-email');
    Route::post('/assign-email-user', [App\Http\Controllers\UserController::class, 'assignEmail'])->name('assign-email-user');
    Route::post('/popup-assign-email/{id}', [App\Http\Controllers\UserController::class, 'emailPopup'])->name('popup-assign-email');
    Route::post('/add_customer_id', [App\Http\Controllers\UserController::class, 'addcustomer_id'])->name('users.add_customer_id');
    Route::post('/update-location', [App\Http\Controllers\UserController::class, 'updateCheckbox'])->name('users.update-location');
    Route::get('/edit_email', [App\Http\Controllers\UserController::class, 'edit_email'])->name('users.edit_email');
    Route::post('/store_email', [App\Http\Controllers\UserController::class, 'store_email'])->name('users.store_email');
    Route::post('/store_email_admin', [App\Http\Controllers\UserController::class, 'store_email_admin'])->name('users.store_email_admin');
    Route::post('/update_user_password', [App\Http\Controllers\UserController::class, 'update_user_password'])->name('users.update_user_password');
    Route::post('/divisionUpdate', [App\Http\Controllers\UserController::class, 'divisionUpdate'])->name('users.divisionUpdate');
});

// events
Route::group(['prefix' => 'event'], function () {
    Route::get('/list', [App\Http\Controllers\EventController::class, 'index'])->name('event.list');
    Route::get('/destroy/{id}', [App\Http\Controllers\EventController::class, 'destroy'])->name('event.destroy');
    Route::get('/add', [App\Http\Controllers\EventController::class, 'addView'])->name('event.add');
    Route::post('/store', [App\Http\Controllers\EventController::class, 'store'])->name('event.store');
    Route::get('/addevent', [App\Http\Controllers\EventController::class, 'addevent'])->name('event.addevent');
    Route::post('/addeventstore', [App\Http\Controllers\EventController::class, 'addeventstore'])->name('event.addeventstore');
    Route::get('/assignadmin', [App\Http\Controllers\EventController::class, 'assignadminview'])->name('event.assignadmin');
    Route::post('/storeadminassign', [App\Http\Controllers\EventController::class, 'storeadminassign'])->name('event.storeadminassign');
    Route::get('/edit', [App\Http\Controllers\EventController::class, 'editView'])->name('event.edit');
    Route::post('/editeventstore', [App\Http\Controllers\EventController::class, 'editeventstore'])->name('event.editeventstore');
    Route::post('/assignUser', [App\Http\Controllers\EventController::class, 'assignUser'])->name('event.assignUser');
});

// visitor
Route::group(['prefix' => 'visitor'], function () {
    Route::get('/list', [App\Http\Controllers\VisitorController::class, 'index'])->name('visitor.list');
    Route::get('/detail', [App\Http\Controllers\VisitorController::class, 'detailview'])->name('visitor.detail');
    // Route::get('/edit', [App\Http\Controllers\VisitorController::class, 'edit'])->name('visitor.edit');
    Route::get('/download-images', [App\Http\Controllers\VisitorController::class, 'downloadImages'])->name('visitor.downloadImages');
	Route::post('/update-email', [App\Http\Controllers\VisitorController::class, 'updateEmail'])->name('visitor.update-email');
    Route::get('/set-mail',[App\Http\Controllers\VisitorController::class, 'setMail'])->name('visitor.set-mail');
    Route::get('/batch',[App\Http\Controllers\VisitorController::class, 'batchList'])->name('visitor.batch-list');
    Route::get('/batch-delete/{batch_id}',[App\Http\Controllers\VisitorController::class, 'batchDelete'])->name('visitor.batch-delete');
	Route::post('/update_event_name', [App\Http\Controllers\VisitorController::class, 'updateeventname'])->name('visitor.update_event_name');
    Route::post('/fetchevent',[App\Http\Controllers\VisitorController::class, 'fetchevent'])->name('visitor.fetchevent');
    Route::get('/getname_search',[App\Http\Controllers\VisitorController::class, 'getname_search'])->name('visitor.getname_search');
    Route::get('/destroy/{id}', [App\Http\Controllers\VisitorController::class, 'destroy'])->name('visitor.destroy');
	Route::post('/add_event_ids', [App\Http\Controllers\VisitorController::class, 'addevent_ids'])->name('visitor.add_event_ids');
    Route::get('/edit/{visitor}', [App\Http\Controllers\VisitorController::class, 'edit'])->name('visitor.edit');
    Route::post('/update/{visitor}', [App\Http\Controllers\VisitorController::class, 'update'])->name('visitor.update');
    Route::get('/add', [App\Http\Controllers\VisitorController::class, 'add'])->name('visitor.add');
    Route::post('/store', [App\Http\Controllers\VisitorController::class, 'store'])->name('visitor.store');
    Route::get('/Multiple_Entries_destroy/{id}', [App\Http\Controllers\VisitorController::class, 'Multiple_Entries_destroy'])->name('visitor.Multiple_Entries_destroy');
    Route::get('/add/visit/data/modal', [App\Http\Controllers\VisitorController::class, 'addVisitDataModal'])->name('visit.data.modal');
    Route::post('/add/visit/data/store/{id}', [App\Http\Controllers\VisitorController::class, 'addVisitDataStore'])->name('visit.data.store');
    Route::get('/visit/data/delete/{id}', [App\Http\Controllers\VisitorController::class, 'visit_delete'])->name('visit.data.delete');
});

// Product
Route::group(['prefix' => 'product'], function () {
    Route::get('/list', [App\Http\Controllers\ProductController::class, 'index'])->name('product.list');
    Route::get('/add', [App\Http\Controllers\ProductController::class, 'addView'])->name('product.add');
    Route::post('/product.addproductstore', [App\Http\Controllers\ProductController::class, 'addproductstore'])->name('product.addproductstore');
    Route::get('/detail', [App\Http\Controllers\ProductController::class, 'detailview'])->name('product.detail');
    Route::get('/visitorproductcount', [App\Http\Controllers\ProductController::class, 'productcount'])->name('product.visitorproductcount');
    Route::get('/destroy/{id}', [App\Http\Controllers\ProductController::class, 'destroy'])->name('product.destroy');
    Route::get('/editimage', [App\Http\Controllers\ProductController::class, 'editimage'])->name('product.editimage');
    Route::post('/imageStore', [App\Http\Controllers\ProductController::class, 'imageStore'])->name('product.imageStore');
    Route::get('/filedestroy', [App\Http\Controllers\ProductController::class, 'filedestroy'])->name('product.filedestroy');
	Route::post('/updateName', [App\Http\Controllers\ProductController::class, 'updateName'])->name('product.updateName');
    Route::get('/addimage', [App\Http\Controllers\ProductController::class, 'addimageView'])->name('product.addimage');
    Route::post('/imageStorenewadd', [App\Http\Controllers\ProductController::class, 'imageStorenewadd'])->name('product.imageStorenewadd');

});

//category
Route::group(['prefix' => 'category'], function () {
    Route::get('/list', [App\Http\Controllers\CategoryController::class, 'index'])->name('category.list');
    Route::get('/add', [App\Http\Controllers\CategoryController::class, 'addView'])->name('category.add');
    Route::post('/store', [App\Http\Controllers\CategoryController::class, 'store'])->name('category.store');
    Route::get('/destroy/{id}', [App\Http\Controllers\CategoryController::class, 'destroy'])->name('category.destroy');
});

//sub category
Route::group(['prefix' => 'sub_category'], function () {
    Route::get('/list', [App\Http\Controllers\Sub_CategoryController::class, 'index'])->name('sub_category.list');
    Route::get('/add', [App\Http\Controllers\Sub_CategoryController::class, 'addView'])->name('sub_category.add');
    Route::post('/store', [App\Http\Controllers\Sub_CategoryController::class, 'store'])->name('sub_category.store');
    Route::get('/destroy/{id}', [App\Http\Controllers\Sub_CategoryController::class, 'destroy'])->name('sub_category.destroy');
});

// Export
Route::group(['prefix' => 'export'], function () {
    Route::post('/exportvisitorlist', [App\Http\Controllers\VisitorController::class, 'exportvisitorlist'])->name('export.exportvisitorlist');
    Route::post('/export_pdf', [App\Http\Controllers\VisitorController::class, 'export_pdf'])->name('export.export_pdf');
});

// settings
Route::group(['prefix' => 'setting'], function () {
    Route::get('/whatsapp_msg', [App\Http\Controllers\SettingController::class, 'whatsappmsg'])->name('setting.whatsapp_msg');
    Route::post('/editwhatsapp_msg', [App\Http\Controllers\SettingController::class, 'editwhatsapp_msg'])->name('setting.editwhatsapp_msg');
    Route::get('/change_password', [App\Http\Controllers\SettingController::class, 'change_password'])->name('setting.change_password');
    Route::post('/update_password', [App\Http\Controllers\SettingController::class, 'update_password'])->name('setting.update_password');
    Route::post('/update_email', [App\Http\Controllers\SettingController::class, 'update_email'])->name('setting.update_email');
    Route::resource('/emails', App\Http\Controllers\EmailController::class);
    Route::post('/sendEmail', [App\Http\Controllers\EmailController::class, 'procsendEmail'])->name('send.email');
    Route::get('/schedule-email-cron', [App\Http\Controllers\EmailController::class, 'scheduleBatchMailCron']);
    Route::get('/indiamart', [App\Http\Controllers\SettingController::class, 'martkey'])->name('setting.martkey');
    Route::post('/update_key', [App\Http\Controllers\SettingController::class, 'updatekey'])->name('setting.update_key');
    Route::get('/delete/{id}', [App\Http\Controllers\EmailController::class, 'delete'])->name('delete');
    Route::get('/upload_image', [App\Http\Controllers\SettingController::class, 'upload_image'])->name('setting.upload_image');
    Route::post('/store_image', [App\Http\Controllers\SettingController::class, 'store_image'])->name('setting.store_image');
    Route::get('/delete_image/{id}', [App\Http\Controllers\SettingController::class, 'delete_image'])->name('delete_image');
    Route::post('/update_emailconfig', [App\Http\Controllers\SettingController::class, 'update_emailconfig'])->name('setting.update_emailconfig');
    Route::get('/region', [App\Http\Controllers\SettingController::class, 'region_list'])->name('setting.region');
    Route::get('/add', [App\Http\Controllers\SettingController::class, 'add'])->name('setting.add');
    Route::post('/add_store', [App\Http\Controllers\SettingController::class, 'add_store'])->name('setting.add_store');
    Route::get('/region_delete/{id}', [App\Http\Controllers\SettingController::class, 'region_delete'])->name('region_delete');
    Route::get('/region_edit', [App\Http\Controllers\SettingController::class, 'region_edit'])->name('region_edit');
    Route::post('/edit_store', [App\Http\Controllers\SettingController::class, 'edit_store'])->name('edit_store');

    Route::get('/division', [App\Http\Controllers\SettingController::class, 'divisionList'])->name('setting.divisionList');
    Route::get('/division_add', [App\Http\Controllers\SettingController::class, 'divisionAdd'])->name('setting.divisionAdd');
    Route::post('/division_insert', [App\Http\Controllers\SettingController::class, 'divisionInsert'])->name('setting.divisionInsert');
    Route::get('/division_delete/{id}', [App\Http\Controllers\SettingController::class, 'divisionDelete'])->name('setting.divisionDelete');
    Route::get('/division_edit', [App\Http\Controllers\SettingController::class, 'divisionEdit'])->name('setting.divisionEdit');
    Route::post('/division_update', [App\Http\Controllers\SettingController::class, 'divisionUpdate'])->name('setting.divisionUpdate');

    Route::get('/subAdmin', [App\Http\Controllers\SettingController::class, 'subAdminList'])->name('setting.subAdminList');
    Route::get('/subAdmin_add', [App\Http\Controllers\SettingController::class, 'subAdminAdd'])->name('setting.subAdminAdd');
    Route::post('/subAdmin_insert', [App\Http\Controllers\SettingController::class, 'subAdminInsert'])->name('setting.subAdminInsert');
    Route::get('/subAdmin_delete/{id}', [App\Http\Controllers\SettingController::class, 'subAdminDelete'])->name('setting.subAdminDelete');
    Route::get('/subAdmin_edit', [App\Http\Controllers\SettingController::class, 'subAdminEdit'])->name('setting.subAdminEdit');
    Route::post('/subAdmin_update', [App\Http\Controllers\SettingController::class, 'subAdminUpdate'])->name('setting.subAdminUpdate');
});

// Import
Route::group(['prefix' => 'import'], function () {
    Route::post('/insertexportfile', [App\Http\Controllers\VisitorController::class, 'insertexportfile'])->name('import.insertexportfile');
});

// Ajax Routes
Route::group(['prefix' => 'ajax'], function () {
    Route::get('/get_image', [App\Http\Controllers\VisitorController::class, 'getimage'])->name('get_image');
    Route::get('/get_eventlist', [App\Http\Controllers\VisitorController::class, 'geteventlist'])->name('get_eventlist');
    Route::get('/get_imagefile', [App\Http\Controllers\ProductController::class, 'getimagefile'])->name('get_imagefile');
    Route::get('/get_productlist', [App\Http\Controllers\VisitorController::class, 'getproductlist'])->name('get_productlist');
    Route::get('/get_userlist', [App\Http\Controllers\UserController::class, 'getUserlist'])->name('get_userlist');
    Route::get('/get_eventlist_multi', [App\Http\Controllers\VisitorController::class, 'geteventlist_multi'])->name('get_eventlist_multi');
    Route::get('/get_visitdata', [App\Http\Controllers\VisitorController::class, 'get_visitdata'])->name('get_visitdata');
    Route::get('/get_visit_images', [App\Http\Controllers\VisitorController::class, 'get_visit_images'])->name('get_visit_images');
    Route::get('/categories/getSubcategory', [App\Http\Controllers\VisitorController::class, 'getSubCategories'])->name('get_sub_categories');
    Route::get('/states/getCities', [App\Http\Controllers\VisitorController::class, 'getCities'])->name('get_cities');
    Route::get('/countries/getStates', [App\Http\Controllers\VisitorController::class, 'getStates'])->name('get_states');
    Route::get('/countries/getCountries', [App\Http\Controllers\VisitorController::class, 'getCountries'])->name('get_countries');
    Route::get('/get_visit_product', [App\Http\Controllers\VisitorController::class, 'get_visit_product'])->name('get_visit_product');
    Route::get('/get_visitorlist_id', [App\Http\Controllers\VisitorController::class, 'get_visitorlist_id'])->name('get_visitorlist_id');

});

//Action
Route::group(['prefix' => 'action'], function () {
    Route::get('/list', [App\Http\Controllers\ActionController::class, 'index'])->name('action.list');
    Route::get('/add', [App\Http\Controllers\ActionController::class, 'addView'])->name('action.add');
    Route::post('/store', [App\Http\Controllers\ActionController::class, 'store'])->name('action.store');
    Route::get('/destroy/{id}', [App\Http\Controllers\ActionController::class, 'destroy'])->name('action.destroy');
});

// Route::post('/assign_user_notification', [App\Http\Controllers\NotificationController::class, 'sendUserAssignedNotification'])->name('assign_user_notification');
