@extends('layouts.master')
@section('content')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" integrity="sha256-...." crossorigin="anonymous" />

<style>
.card-header {
    color: #fff;
    background-color: #007bff;
}
.error{
    color: red;
}
.select2-container--default .select2-selection--multiple .select2-selection__choice{
            color: #000;
}
img {
    height:auto;
    width: 166px;
object-fit: scale-down;
}

#fullpage {
    display: none;
    position: absolute;
    z-index: 9999;
    top: 0;
    left: 0;
    width: 80.3vw;
    height: 90vh;
    background-size: contain;
    background-repeat: no-repeat no-repeat;
    background-position: center center;
    background-color: black;
}
.image-gallery {
    display: flex;
    flex-wrap: wrap;
    margin: -5px;
}

.gallery-item {
    flex: 1.1 0 calc(33.33% - 10px);
    box-sizing: border-box;
    padding: 5px;
}
.img2 {
    height: 200px; /* Set the height to your desired value */
    object-fit: cover; /* This property ensures that the image retains its aspect ratio and covers the entire container */
}
</style>
<div class="content-wrapper" style="min-height: 1604.44px;">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Profile</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('visitor.list') }}">Client List</a></li>
                        <li class="breadcrumb-item active">User Profile</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-primary card-outline">
                        <div class="card-body box-profile">
                            <div class="text-center" onload="getPics()">
                                <div class="gallery">
                                    <div style="overflow-x:scroll;white-space:nowrap;" >
                                        @foreach($event_images as $images)
                                           
                                            @php
                                                $modified_image_path = substr($images->event_image, strpos($images->event_image, '/frenzincrm_api'));
                                                $imagePathInfo = pathinfo($images->event_image);
                                                $extension = strtolower($imagePathInfo['extension']);
                                            @endphp
                                            @if ($extension === 'pdf')
                                            <a href="{{ $modified_image_path }}" target="_blank" style="text-decoration: none;">
                                                <img src="{{ asset('pdficon.png') }}" style="width: 139px; height: 166px;"
                                                class="img" alt="" >
                                            </a>
                                            @else
                                                <img src="{{ $modified_image_path }}" style="width: 301px; height: 166px;"
                                                    class="img" alt="" >
                                            @endif
                                        @endforeach

                                        <?php 
                                            $images = substr($data->front_image, strpos($data->front_image, '/frenzincrm_api'));
                                            $back_images = substr($data->back_image, strpos($data->back_image, '/frenzincrm_api'));
                                        ?>
                                        @if(isset($data->front_image) && $data->front_image != NULL)
                                        <img  src="{{ $images }}" class="img" alt="">
                                        @endif
                                        @if(isset($data->back_image) && $data->back_image != NULL)
                                        <img class="img" src="{{ $back_images }}" alt="">
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div id="fullpage" onclick="this.style.display='none';"></div>

                            <h3 class="profile-username text-center">
                                @if(isset($data->name)){{ $data->name }}@endif
                                <a href={{route('visitor.edit',$data->id)}}>
                                    <button class="btn btn-primary btn-sm" data-toggle="tooltip" data-placement="right" title="Edit " style="margin-top: 10px;margin-left: 9px;">
                                        <i class="fas fa-pen-alt" aria-hidden="true"></i>
                                    </button>
                                </a>
                            </h3>
                            @if(!empty($data->lat))
                                <div style="width: 25px; margin-left: 600px;margin-top: -35px">
                                    <a href="http://www.google.com/maps/place/{{ $data->lat }},{{ $data->lng }}" class="" target="_blank">
                                        <svg viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><clipPath id="a"><use xlink:href="#b"/></clipPath><rect id="b" fill="#fff" height="512" rx="15%" width="512"/><g clip-path="url(#a)"><path d="m0 512v-512h512z" fill="#35a85b"/><path d="m256 288-224 224h448z" fill="#5881ca"/><path d="m288 256 224-224v448z" fill="#c1c0be"/><path d="m0 512 512-512" stroke="#fadb2a" stroke-width="71"/><path d="m175 173h50a50 54 0 1 1 -15-41" fill="none" stroke="#f2f2f2" stroke-width="22"/><path d="m353 85a70 70 0 0 1 140 0c0 70-70 70-70 157 0-87-70-87-70-157" fill="#de3738"/><circle cx="423" cy="89" fill="#7d2426" r="25"/></g></svg>
                                    </a>
                                </div>
                            @endif
                            <p class="text-muted text-center">
                                @if(isset($data->mobile_no))
                                    <a href="tel:{{$data->mobile_no}}" style="text-decoration: none;">{{$data->mobile_no}}
                                    </a>
                                @endif
                            </p>
                            <!-- <ul class="list-group list-group-unbordered mb-3">

                                <li class="list-group-item">
                                    <b>Mobile_No</b> <a class="float-right"></a>
                                </li>
                            </ul> -->
                        </div>
                    </div>

                    <div class="card card-primary">
                        <div class="row">
                            <div class="col-3">
                                <div class="card-header">
                                    <h3 class="card-title">Personal Information</h3>
                                </div>
                                <div class="card-body">
                                    @if($data->CustomerName != NULL)
                                    <strong><i class="fas fa-book mr-1"></i> Team Member Name</strong>
                                    <p class="text-muted">
                                        {{ $data->CustomerName }}
                                    </p>
                                    <hr>
                                    @endif

                                    @if($data->mobile_no != NULL)
                                    <strong><i class="fas fa-book mr-1"></i> Mobile_No</strong>
                                    <p class="text-muted">
                                        <a href="tel:{{$data->mobile_no}}" style="text-decoration: none;">+{{$data->mobile_no}}</a>
                                    </p>
                                    <hr>
                                    @endif
                                    @if($data->event_name != NULL)
                                    <strong><i class="fas fa-book mr-1"></i> Event Name</strong>
                                    <p class="text-muted">
                                        {{ $data->event_name }}
                                    </p>
                                    <hr>
                                    @endif
                                    @if($data->email != NULL)
                                    <strong><i class="fas fa-book mr-1"></i> Email</strong>
                                    <p class="text-muted">
                                        <a href="mailto:email?" style="text-decoration: none">{{$data->email}}</a>
                                        {{-- <a href="mailto:email?subject={{$data->email}}?body={{$data->email}}">{{$data->email}}</a> --}}
                                    </p>
                                    <hr>
                                    @endif
                                    @if($data->country_code != NULL)
                                        <strong><i class="fas fa-book mr-1"></i> Country</strong>
                                        <p class="text-muted">
                                            {{ \App\Models\Visitor::getCountryName($data->country_code) }}
                                        </p>
                                        <hr>
                                    @endif
                                    @if($data->state != NULL)
                                    <strong><i class="fas fa-book mr-1"></i> State</strong>
                                    <p class="text-muted">
                                        {{ $data->state }}
                                    </p>
                                    <hr>
                                    @endif
                                    @if($data->city != NULL)
                                    <strong><i class="fas fa-book mr-1"></i> City</strong>
                                    <p class="text-muted">
                                        {{ $data->city }}
                                    </p>
                                    <hr>
                                    @endif
                                    @if($data->pincode != NULL)
                                    <strong><i class="fas fa-book mr-1"></i> Pin Code</strong>
                                    <p class="text-muted">
                                        {{ $data->pincode }}
                                    </p>
                                    <hr>
                                    @endif
                                    @if($data->address != NULL)
                                    <strong><i class="fas fa-book mr-1"></i> Address</strong>
                                    <p class="text-muted">
                                        {{ $data->address }}
                                    </p>
                                    <hr>
                                    @endif
                                    @if($data->visited_date != NULL)
                                    <strong><i class="fas fa-book mr-1"></i> Visited Date</strong>
                                    <p class="text-muted">
                                        {{ $data->visited_date }}
                                    </p>
                                    <hr>
                                    @endif
                                    @if($data->attended_by != NULL)
                                    <strong><i class="fas fa-book mr-1"></i> Attended By</strong>
                                    <p class="text-muted">
                                        {{ $data->attended_by }}
                                    </p>
                                    <hr>
                                    @endif
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="card-header">
                                    <h3 class="card-title">Company Details</h3>
                                </div>
                                <div class="card-body">
                                    @if($data->company_name != NULL)
                                    <strong><i class="fas fa-book mr-1"></i> Company Name</strong>
                                    <p class="text-muted">
                                        {{$data->company_name}}
                                    </p>
                                    <hr>
                                    @endif
                                    @if($data->name != NULL)
                                    <strong><i class="fas fa-book mr-1"></i> Name</strong>
                                    <p class="text-muted">
                                        {{$data->name}}
                                    </p>
                                    <hr>
                                    @endif
                                    @if($data->website != NULL)
                                    <strong><i class="fas fa-book mr-1"></i> Website</strong>
                                    <p class="text-muted">
                                    <?php
                                        $url =$data->website;
                                    ?>
                                    @if(Str::startsWith($url, ['http://', 'https://']))
                                        <a href="{{$data->website}}" style="text-decoration: none;" target="_blank">{{$data->website}}</a>
                                    @else
                                        <a href="http://{{$data->website}}" style="text-decoration: none;" target="_blank">{{$data->website}}</a>
                                    @endif
                                    </p>
                                    <hr>
                                    @endif
                                    @if($data->designation != NULL)
                                    <strong><i class="fas fa-book mr-1"></i> Designation</strong>
                                    <p class="text-muted">
                                        {{ $data->designation }}
                                    </p>
                                    <hr>
                                    @endif
                                    @if($data->mobile_no2 != NULL)
                                    <strong><i class="fas fa-book mr-1"></i> Mobile_No</strong>
                                    <p class="text-muted">
                                        <a href="tel:{{$data->mobile_no2}}" style="text-decoration: none;">+{{$data->mobile_no2}}</a>
                                    </p>
                                    <hr>
                                    @endif
                                    @if($data->mobile_no3 != NULL)
                                    <strong><i class="fas fa-book mr-1"></i> Mobile_No </strong>
                                    <p class="text-muted">
                                        <a href="tel:{{$data->mobile_no3}}" style="text-decoration: none;">+{{$data->mobile_no3}}</a>
                                    </p>
                                    <hr>
                                    @endif
                                    @if($data->email2 != NULL)
                                    <strong><i class="fas fa-book mr-1"></i> Email</strong>
                                    <p class="text-muted">
                                        <a href="mailto:email?" style="text-decoration: none">{{$data->email2}}</a>
                                    </p>
                                    <hr>
                                    @endif

                                    @if($data->category != NULL)
                                    <strong><i class="fas fa-book mr-1"></i> Category</strong>

                                    <p class="text-muted">
                                        {{ $data->category }}
                                    </p>
                                    <hr>
                                    @endif
                                    @if($data->sub_category != NULL)
                                    <strong><i class="fas fa-book mr-1"></i> Sub Category</strong>

                                    <p class="text-muted">
                                        {{ $data->sub_category }}
                                    </p>
                                    <hr>
                                    @endif
                                    @if($data->qrcodevalue != NULL)
                                    <strong><i class="fas fa-book mr-1"></i> QrCode Value</strong>
                                    <p class="text-muted">
                                        {{ $data->qrcodevalue }}
                                    </p>
                                    <hr>
                                    @endif
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="card-header">
                                    <h3 class="card-title">Analytics</h3>
                                </div>
                                <div class="card-body">
                                    @if($data->rating != NULL)
                                    <strong><i class="fas fa-book mr-1"></i> Rating</strong>
                                    <p class="text-muted">
                                        {{ $data->rating }}
                                    </p>
                                    <hr>
                                    @endif
                                    @if($visitor_products != NULL)
                                        <strong><i class="fas fa-book mr-1"></i> Product Of Interest</strong>
                                        @foreach($visitor_products as $visitorproducts)
                                            <p class="text-muted">
                                                {{ $visitorproducts->productname }}
                                            </p>
                                            <hr>
                                        @endforeach
                                    @endif
                                    <br>
                                    <hr>

                                    @if($data->action != NULL)
                                    <strong><i class="fas fa-book mr-1"></i> Action</strong>
                                    <p class="text-muted">
                                        {{ $data->action }}
                                    </p>
                                    <hr>
                                    @endif
                                    @if($data->remarks != NULL)
                                    <strong><i class="fas fa-book mr-1"></i> Remarks</strong>
                                    <p class="text-muted">
                                        {{ $data->remarks }}
                                    </p>
                                    <hr>
                                    @endif
                                    @if($data->follow_up_time != NULL)
                                    <strong><i class="fas fa-book mr-1"></i> Follow_Up_Time</strong>
                                    <p class="text-muted">
                                        {{ $data->follow_up_time }}
                                    </p>
                                    <hr>
                                    @endif
                                    @if($data->audio_file != NULL)
                                    <strong><i class="fas fa-book mr-1"></i> Audio_File</strong>
                                    <p class="text-muted">
                                        <audio controls style="height:25px;"><source src=" {{ $data->audio_file }}"></audio>
                                    </p>
                                    <hr>
                                    @endif
                                    {{-- @if($visitor_products != NULL)
                                        <strong><i class="fas fa-book mr-1"></i> Product Of Interest</strong>
                                        @foreach($visitor_products as $visitorproducts)
                                            <p class="text-muted">
                                                {{ $visitorproducts->productname }}
                                            </p>
                                            <hr>
                                        @endforeach
                                    @endif --}}
                                    {{-- @foreach($visit_all as $key => $visitall)
                                        <strong><i class="fas fa-book mr-1"></i> Visit Data {{$key+1}}</strong><br>
                                            <strong>Visited Date</strong> <br>
                                            {{ $visitall->created_at }}
                                        <button style="width:13%;" value="{{$data->id}}" class="btn btn-sm btn-primary btn-$data->event_ids" data-id="{{$visitall->id}}" data-toggle="modal"  onclick="show_visitdata(this)" data-target="#Modal" >View</button>
                                        <hr>
                                    @endforeach
                                    <br> --}}
                                    <strong><i class="fas fa-book mr-1"></i>Add event</strong>
                                    <button style="width:15%;" value="{{$data->id}}" class="btn btn-sm btn-primary btn-$data->event_ids" id="add-event-button" data-toggle="modal"  data-target="#Modal" >Add</button>
                                    @foreach($eventNames as $eventIds)
                                        <p class="text-muted">
                                            {{ $eventIds }}
                                        </p>
                                        <hr>
                                    @endforeach
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="card-header">
                                    <h3 class="card-title">Visit Data</h3>
                                    <button type="submit" data-modal="addVisitModal"  data-url="{{route('visit.data.modal')}}" data-event_id ="{{$data->event_id}}" data-visitor_id ="{{$data->id}}" class="btn btn-primary btn-sm add_Visit" style="margin-top: -24px;width: 30%;margin-left:-7px;margin-top:-1px;background-color:#000;float:right;">Add Visit</button>
                                </div>
                                <div class="card-body">
                                    @foreach($visit_all as $key => $visitall)
                                        <strong><i class="fas fa-book mr-1"></i> Visit {{count($visit_all) - $key}}</strong>
                                        <button data-url="{{route('visit.data.delete',$visitall->id)}}" class="btn btn-danger btn-sm" onclick="deleteEventData(this)" data-toggle="tooltip" data-placement="right" title="Delete " style="float:right;">
                                            <i class="fas fa-trash" aria-hidden="true"></i>
                                        </button>
                                        <button data-url="{{route('visit.data.modal')}}" data-modal="addVisitModal"  data-event_id ="{{$data->event_id}}" data-visitor_id ="{{$data->id}}" data-visit_data_id ="{{$visitall->id}}"  class="btn btn-primary btn-sm add_Visit mr-2"  data-toggle="tooltip" data-placement="right" title="Edit" style="float:right;">
                                            <i class="fas fa-pencil" aria-hidden="true"></i>
                                        </button>
                                        <button style="width:15%;float:right;margin-right:10px;" value="{{$data->id}}" class="btn btn-sm btn-primary btn-$data->event_ids" data-id="{{$visitall->id}}" data-toggle="modal"  onclick="show_visitdata(this)" data-target="#Modal" >View</button>
                                        
                                        <br>
                                        {{-- <p class="text-muted"> --}}
                                            {{-- <strong>Visited Date</strong> <br> --}}
                                            @php
                                                $formattedDate = \Carbon\Carbon::parse($visitall->visit_time )->format('d M Y h:iA');
                                            @endphp
                                            {{  $formattedDate }}<br>
                                            <b>Remarks :</b> {{ $visitall->remarks }}
                                        {{-- </p> --}}
                                       
                                        <hr>
                                    @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- event list Modal -->
<div class="modal fade" id="modalieventlist" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-x" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalieventlistTitle">Event List</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="{{ route('visitor.add_event_ids') }}" method="post">
                    @csrf
                    <input type="hidden" value="visitor_id" name="visitor_id" id="modalvisitor_id">
                    <div class="table-responsive text-nowrap">
                        <table class="table" id="showevetlist">
                            <thead>
                                <tr>
                                    <th>Event Name</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody class="table-border-bottom-0">
                            </tbody>
                        </table>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modalvisitshow" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-x" role="document">
        <div class="modal-content" style="width: 115%;">
            <div class="modal-header">
                <h5 class="modal-title" id="modalvisitshowTitle">Visit Data List</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <ul class="list-group" id="show_visitdata">

                </ul>
            </div>
        </div>
    </div>
</div>


<script>
    function getPics() {}
    const imgs = document.querySelectorAll('.gallery img');
    const fullPage = document.querySelector('#fullpage');

    // imgs.forEach(img => {
    //     var images = img.substring(img.indexOf('/frenzincrm_api'));
    //     images.addEventListener('click', function() {
    //         fullPage.style.backgroundImage = 'url(' + images.src + ')';
    //         fullPage.style.display = 'block';
    //     });
    // });
    imgs.forEach(img => {
        var imageUrl = img.src;
        var images = imageUrl.substring(imageUrl.indexOf('/frenzincrm_api'));
        img.addEventListener('click', function() {
            fullPage.style.backgroundImage = 'url(' + images + ')';
            fullPage.style.display = 'block';
        });
    });

    $(document).ready(function() {
        var table = $('#showevetlist').DataTable({
            paging: false,
            searching: true
        });

        $('#add-event-button').click(function() {
            var id = $('#add-event-button').val();
                $.ajax({
                    url: "{{ url('ajax/get_eventlist_multi') }}",
                    type: "GET",
                    data: {
                        id: id,
                    },
                    cache:false,
                    success: function(response) {
                        if (response && response.data.length > 0) {
                            // Clear existing table data
                            table.clear();

                            // Add new data to the table
                            response.data.forEach(function(item) {
                                var isChecked = $.inArray(item.event_name, @json($eventNames)) !== -1;

                                table.row.add([
                                    item.event_name,
                                    '<input type="checkbox" class="item-checkbox" name="events_id[]" value="' + item.id + '"' + (isChecked ? ' checked' : '') + '>'
                                ]).draw();
                            });

                            // Show the modal
                            $('#modalvisitor_id').val(id);
                            $("#modalieventlist").modal('show');
                        } else {
                            alert('No data found!');
                        }
                    },
                    error: function(error) {
                        console.log(error);
                    }
                });
            // }
        });

        
    });
</script>

<script>

function deleteEventData(elm) {
        let url = $(elm).data('url');
        swal({
            title: 'Are you sure want to Delete Client Visit Data ?',
            icon: 'error',
            dangerMode: true,
            buttons: true,
            confirm: "Confirm",
        }).then(function(isConfirm) {
            if (isConfirm === true) {
                $.ajax({
                    type: 'GET',
                    url: url,
                    cache:false,
                    dataType: 'json',
                    success: function(data) {

                        window.location.reload();
                        // console.log(data);
                    },
                    error: function(data) {
                        console.log(data);
                    }
                });
            }
            });
}
        
function show_visitdata(elm) {
    var id = $(elm).attr('data-id');

    $.ajax({
        url: "{{ url('ajax/get_visitdata') }}",
        type: "GET",
        data: {
            id: id,
        },
        success: function(response) {
            if (response) {
                $("#show_visitdata").html('');
                $.each(response['data'], function(i, item) {
                    var dataPairs = [];

                    // Add Action to dataPairs only if it is not null or empty
                    if (item['action']) {
                        dataPairs.push({ label: "Action", value: item['action'] });
                    }

                    dataPairs.push({ label: "Remarks", value: item['remarks'] });

                    $.each(dataPairs, function(j, pair) {
                        var line = `<div style="border: 1px solid #ccc; display: flex; margin-bottom: 5px;">
                            <div style="flex: 1; padding: 5px;"><strong>${pair.label} </strong></div>
                            <div style="flex: 4; padding: 5px;">${pair.value}</div>
                        </div>`;
                        $("#show_visitdata").append(line);
                    });

                    if (item['follow_up_time']) {
                        var followUpTime = new Date(item['follow_up_time']);
                        var follow_up_time = `<div style="border: 1px solid #ccc; display: flex; margin-bottom: 5px;">
                            <div style="flex: 1; padding: 5px;"><strong>Follow-up Time </strong></div>
                            <div style="flex: 4; padding: 5px;">${formatDate(followUpTime)}</div>
                        </div>`;
                        $("#show_visitdata").append(follow_up_time);
                    }
                    // Audio file
                    if (item['audio_file']) {
                        var audioFilePath = item['audio_file'];
                        var modifiedAudioFilePath = audioFilePath.substring(audioFilePath.indexOf('/frenzincrm_api'));
                        var audioItem = `<div style="border: 1px solid #ccc; display: flex; margin-bottom: 5px;">
                            <div style="flex: 1; padding: 5px;"><strong>Audio File</strong></div>
                            <div style="flex: 4; padding: 5px;">
                                <audio controls style="height: 36px;"><source src="${modifiedAudioFilePath}" type="audio/mp3"></audio>
                            </div>
                        </div>`;
                        $("#show_visitdata").append(audioItem);
                    }

                    if (item['lat'] && item['lng']) {
                        var locationItem = `<div style="border: 1px solid #ccc; display: flex; margin-bottom: 5px;">
                            <div style="flex: 1; padding: 5px;"><strong>Location </strong></div>
                            <div style="flex: 4; padding: 5px;">
                                <div style="width: 25px;">
                                    <a href="http://www.google.com/maps/place/${item['lat']}, ${item['lng']}" class="" target="_blank">
                                        <svg viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><clipPath id="a"><use xlink:href="#b"/></clipPath><rect id="b" fill="#fff" height="512" rx="15%" width="512"/><g clip-path="url(#a)"><path d="m0 512v-512h512z" fill="#35a85b"/><path d="m256 288-224 224h448z" fill="#5881ca"/><path d="m288 256 224-224v448z" fill="#c1c0be"/><path d="m0 512 512-512" stroke="#fadb2a" stroke-width="71"/><path d="m175 173h50a50 54 0 1 1 -15-41" fill="none" stroke="#f2f2f2" stroke-width="22"/><path d="m353 85a70 70 0 0 1 140 0c0 70-70 70-70 157 0-87-70-87-70-157" fill="#de3738"/><circle cx="423" cy="89" fill="#7d2426" r="25"/></g></svg>
                                    </a>
                                </div>
                            </div>
                        </div>`;
                        $("#show_visitdata").append(locationItem);
                    }
                    // <i class="fas fa-map-marker-alt" style="color:red;"></i> ${item['lat']}, ${item['lng']}
                    fetchproductName(item['id']);
                    fetchAdditionalData(item['id']);

                    $("#modalvisitshow").modal('show');
                });
            } else {
                alert('no data found!');
            }
        },
        error: function(error) {
            console.log(error);
        }
    });
}
// Function to format the date as 'd M Y h:iA'
function formatDate(date) {
    var day = ('0' + date.getDate()).slice(-2);
    var month = date.toLocaleString('default', { month: 'short' });
    var year = date.getFullYear();
    var hours = ('0' + date.getHours()).slice(-2);
    var minutes = ('0' + date.getMinutes()).slice(-2);
    var ampm = date.getHours() >= 12 ? 'PM' : 'AM';

    return `${day} ${month} ${year} ${hours}:${minutes}${ampm}`;
}

function fetchAdditionalData(itemId) {
    $.ajax({
        url: "{{ url('ajax/get_visit_images') }}",
        type: "GET",
        data: {
            id: itemId,
        },
        success: function(additionalData) {
            var imageContainer = `<div class="image-gallery">`;

            $.each(additionalData['data'], function(i, imageUrl) {
                var modifiedImagePath = imageUrl['visit_image'].substring(imageUrl['visit_image'].indexOf('/frenzincrm_api'));
                var extension = imageUrl['visit_image'].split('.').pop().toLowerCase();
                var isPdf = extension === 'pdf';
    
                imageContainer += `
                    <div class="gallery-item">
                        <a href="${modifiedImagePath}" target="_blank" style="text-decoration: none;">
                            ${isPdf ? '<img src="' + '{{ asset('/pdficon.png') }}' + '">' : `<img src="${modifiedImagePath}" alt="" class="img2" style="width: 100%;">`}
                        </a>
                    </div>`;
            });

            imageContainer += `</div>`;

            $("#show_visitdata").append(imageContainer);
        },
        error: function(error) {
            console.log(error);
        }
    });
}
function fetchproductName(itemId) {
    $.ajax({
        url: "{{ url('ajax/get_visit_product') }}",
        type: "GET",
        data: {
            id: itemId,
        },
        success: function(additionalData) {
            var productNames = ""; 

            $.each(additionalData['data'], function(i, productitem) {
                productNames += productitem['productname'] + ', ';
            });

            productNames = productNames.slice(0, -2);
            if (productNames) {
                var productNamesDiv = `
                    <div style="border: 1px solid #ccc; display: flex; margin-bottom: 5px;">
                        <div style="flex: 1; padding: 5px;"><strong>Product Names </strong></div>
                        <div style="flex: 4; padding: 5px;">${productNames}</div>
                    </div>`;

                $("#show_visitdata").append(productNamesDiv);
            }
        },
        error: function(error) {
            console.log(error);
        }
    });
}
</script>
@endsection
