@extends('layouts.master')
@section('content')
    <style>
        .card-header {
            color: #fff;
            background-color: #007bff;
        }
        .error{
            color: red;
        }
        .select2-container--default .select2-selection--multiple .select2-selection__choice{
            color: #000;
        }
        
        #fullpage {
            display: none;
            position: absolute;
            top: 0;
            left: 0;
            width: 81.4vw;
            height: 60vh;
            background-size: contain;
            background-repeat: no-repeat no-repeat;
            background-position: center center;
            background-color: black;
        }


        .item {
            width: 200px;
            text-align: center;
            display: block;
            background-color: transparent;
            border: 1px solid transparent;
            margin-right: 10px;
            margin-bottom: 1px;
            margin-top: 10px;
            float: left;
        }

        img {
            height: auto;
            width: 60px;
            object-fit: scale-down;
        }
    </style>
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Client List</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                            <li class="breadcrumb-item active">Client</li>
                        </ol>
                    </div>
                    <div class="container-fluid">
                        <div class="card-body">
                            <form method="get" id="myform" name="myform" action="{{ route('visitor.list') }}"
                                enctype="multipart/form-data">
                                <input type="hidden" value="" name="type" id="formType">
                                <div class="form-group row">
                                    <div class="col-2">
                                        <label for="">Select Event</label>
                                        <select class="form-control custom-select" name="event_id" id="event_id">
                                            <option value="all" @if ($event_id == 'all') selected @endif>All
                                            </option>
                                            @foreach ($events as $val)
                                                <option value="{{ $val->id }}"
                                                    @if ($event_id == $val->id) selected @endif>{{ $val->event_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-2">
                                        <label for="">Select Team Member</label>
                                        <select class="form-control custom-select" name="CustomerID" id="CustomerID">
                                            <option value="all" @if ($CustomerID == 'all') selected @endif>All
                                            </option>
                                            @foreach ($users as $username)
                                                <option value="{{ $username->CustomerID }}"
                                                    @if ($CustomerID == $username->CustomerID) selected @endif>
                                                    {{ $username->CustomerName }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="col-2">
                                        <label for="">Select Category</label>
                                        <select class="form-control custom-select" name="category_id" id="category_id">
                                            <option value="all" @if ($category_id == 'all') selected @endif>All
                                            </option>
                                            @foreach ($categories as $val)
                                                <option value="{{ $val->id }}"
                                                    @if ($val->id == $category_id) selected @endif>{{ $val->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="col-2">
                                        <label for="">Select Sub Category</label>
                                        <select class="form-control custom-select" name="sub_category_id"
                                            id="sub_category_id">
                                            <option value="all" @if ($sub_category_id == 'all') selected @endif>All
                                            </option>
                                        </select>
                                    </div>

                                    <div class="col-2">
                                        <label for="">Select Start Date</label>
                                        <input type="date" name="start_date" id="start_date" class="form-control"
                                            value="{{ $start_date }}">
                                    </div>

                                    <div class="col-2">
                                        <label for="">Select End Date</label>
                                        <input type="date" name="end_date" id="end_date" class="form-control"
                                            value="{{ $end_date }}">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <div class="col-2">
                                        <label for="">Region</label>
                                        <select class="form-control custom-select" name="region" id="region">
                                            <option value="all" @if ($region == 'all') selected @endif>All
                                            </option>
                                            @if ($regions)
                                                @foreach ($regions as $val)
                                                    <option value="{{ $val->id }}"
                                                        @if ($region == $val->id) selected @endif>
                                                        {{ $val->name }}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>

                                    <div class="col-2">
                                        <label for="">Is International</label>
                                        <select class="form-control custom-select" name="is_international"
                                            id="is_international">
                                            <option value="all" @if ($is_international == 'all') selected @endif>All
                                            </option>
                                            <option value="false" @if ($is_international == 'false') selected @endif>India
                                            </option>
                                            <option value="true" @if ($is_international == 'true') selected @endif>
                                                International</option>
                                        </select>
                                    </div>

                                    <div class="col-2">
                                        <label for="">Select Country</label>
                                        <select class="form-control custom-select" name="country_id" id="country_id">
                                            <option value="all" @if ($country_id == 'all') selected @endif>All
                                            </option>
                                        </select>
                                    </div>

                                    <div class="col-2">
                                        <label for="">Select State</label>
                                        <select class="form-control custom-select" name="state_id" id="state_id">
                                            <option value="all" @if ($state_id == 'all') selected @endif>All
                                            </option>
                                        </select>
                                    </div>

                                    <div class="col-2">
                                        <label for="">Select City</label>
                                        <select class="form-control custom-select" name="city_id" id="city_id">
                                            <option value="all" @if ($city_id == 'all') selected @endif>All
                                            </option>
                                        </select>
                                    </div>

                                </div>
                                <div class="form-group">
                                    <button type="submit" class="btn btn-2 bg-gradient-info btn-1"
                                        style="color:white;">Submit</button>
                                    <button type="button" class="btn btn-2 bg-gradient-info btn-1"
                                        onclick="exportImages(this);" style="color:white;">Export Images</button>
                                    <button type="button" class="btn btn-primary" onclick="sendMail('followup');">Send
                                        FollowUp Email</button>
                                    <button type="button" class="btn btn-primary" onclick="sendMail('primary');">Send
                                        Primary Email</button>
                                    <button type="button" class="btn btn-primary"
                                        onclick="setOtherEmail(this);">Schedule Email</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card" style="width: 116%;">
                            <div class="card-header">
                                <h3 class="card-title">Client</h3>
                                <div class="card-tools">
                                    <button type="button" class="btn btn-tool" data-card-widget="collapse"
                                        title="Collapse">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                    <!-- <button type="button" class="btn btn-tool" data-card-widget="remove" title="Remove">
                                            <i class="fas fa-times"></i>
                                        </button> -->
                                </div>
                            </div>
                            <div class="card-body">
                                <form method="post" name="frm_no_kids" id="frm_no_kids" class="getstarted"
                                    action="{{ route('export.exportvisitorlist') }}">
                                    @csrf
                                    <input type="hidden" id="event_id" name="event_id"
                                        value="@if (isset($_GET['event_id'])) {{ $_GET['event_id'] }} @endif">
                                    <input type="hidden" id="CustomerID" name="CustomerID"
                                        value="@if (isset($_GET['CustomerID'])) {{ $_GET['CustomerID'] }} @endif">
                                    <input type="hidden" id="categoryId" name="category_id"
                                        value="@if (isset($_GET['category_id'])) {{ $_GET['category_id'] }} @endif">
                                    <input type="hidden" id="subCategoryId" name="sub_category_id"
                                        value="@if (isset($_GET['sub_category_id'])) {{ $_GET['sub_category_id'] }} @endif">
                                    <input type="hidden" id="stateId" name="state_id"
                                        value="@if (isset($_GET['state_id'])) {{ $_GET['state_id'] }} @endif">
                                    <input type="hidden" id="cityId" name="city_id"
                                        value="@if (isset($_GET['city_id'])) {{ $_GET['city_id'] }} @endif">
                                    <input type="hidden" id="isInternational" name="is_international"
                                        value="@if (isset($_GET['is_international'])) {{ $_GET['is_international'] }} @endif">
                                    <input type="hidden" id="countryId" name="country_id"
                                        value="@if (isset($_GET['country_id'])) {{ $_GET['country_id'] }} @endif">
                                    <input type="hidden" id="region" name="region"
                                        value="@if (isset($_GET['region'])) {{ $_GET['region'] }} @endif">
                                    <input type="hidden" id="startDate" name="start_date"
                                        value="@if (isset($_GET['start_date'])) {{ $_GET['start_date'] }} @endif">
                                    <input type="hidden" id="endDate" name="end_date"
                                        value="@if (isset($_GET['end_date'])) {{ $_GET['end_date'] }} @endif">
                                    <input type="submit" id="submit_export" name="submit_export" style="display:none;">
                                    <button class="btn btn-2 bg-gradient-info btn-1" data-toggle="tooltip"
                                        data-placement="left" title="Export" style="color:white">
                                        <i class="bx bxs-edit" aria-hidden="true"></i>Export
                                    </button>
                                </form>

                                <form method="post" name="frm_no_kids" id="frm_no_kids" class="getstarted"
                                    action="{{ route('export.export_pdf') }}">
                                    @csrf
                                    <input type="hidden" id="event_id" name="event_id"
                                        value="@if (isset($_GET['event_id'])) {{ $_GET['event_id'] }} @endif">
                                    <input type="hidden" id="CustomerID" name="CustomerID"
                                        value="@if (isset($_GET['CustomerID'])) {{ $_GET['CustomerID'] }} @endif">
                                    <input type="hidden" id="categoryId" name="category_id"
                                        value="@if (isset($_GET['category_id'])) {{ $_GET['category_id'] }} @endif">
                                    <input type="hidden" id="subCategoryId" name="sub_category_id"
                                        value="@if (isset($_GET['sub_category_id'])) {{ $_GET['sub_category_id'] }} @endif">
                                    <input type="hidden" id="stateId" name="state_id"
                                        value="@if (isset($_GET['state_id'])) {{ $_GET['state_id'] }} @endif">
                                    <input type="hidden" id="cityId" name="city_id"
                                        value="@if (isset($_GET['city_id'])) {{ $_GET['city_id'] }} @endif">
                                    <input type="hidden" id="isInternational" name="is_international"
                                        value="@if (isset($_GET['is_international'])) {{ $_GET['is_international'] }} @endif">
                                    <input type="hidden" id="countryId" name="country_id"
                                        value="@if (isset($_GET['country_id'])) {{ $_GET['country_id'] }} @endif">
                                    <input type="hidden" id="region" name="region"
                                        value="@if (isset($_GET['region'])) {{ $_GET['region'] }} @endif">
                                    <input type="hidden" id="startDate" name="start_date"
                                        value="@if (isset($_GET['start_date'])) {{ $_GET['start_date'] }} @endif">
                                    <input type="hidden" id="endDate" name="end_date"
                                        value="@if (isset($_GET['end_date'])) {{ $_GET['end_date'] }} @endif">
                                    <input type="submit" id="submit_export" name="submit_export" style="display:none;">
                                    <button class="btn btn-2 bg-gradient-info btn-1" data-toggle="tooltip"
                                        data-placement="left" title="Export"
                                        style="    color: white;
                                    margin-top: -66px;
                                    margin-left: 92px;">
                                        <i class="bx bxs-edit" aria-hidden="true"></i>Export Pdf
                                    </button>
                                </form>

                                <button class="btn btn-2 bg-gradient-info btn-1" data-toggle="modal"
                                    data-target="#exampleModal" title="import"
                                    style="margin-left: 214px;
                                margin-top: -112px;
                                color: white;">
                                    <i class="bx bxs-edit" aria-hidden="true"></i>Import
                                </button>

                                <button id="move-button" class="btn btn-2 bg-gradient-info btn-1" data-toggle="modal"
                                    data-target="#Modal" title="Move"
                                    style="margin-left: 25px;margin-top: -112px;color:white">
                                    <i class="bx bxs-edit" aria-hidden="true"></i>Move
                                </button>

                                <a href="{{ route('visitor.add') }}">
                                    <button id="add-button" class="btn btn-2 bg-gradient-info btn-1"
                                        style="margin-left: 25px;margin-top: -112px;color:white">
                                        <i class="bx bxs-edit" aria-hidden="true"></i>Add Client
                                    </button>
                                </a>
                                <!-- <a href="">
                                        <button class="btn btn-2 bg-gradient-info btn-1" title="Edit"
                                        style="margin-left: 920px;margin-top: -62px;">
                                        <i class="bx bxs-edit" aria-hidden="true"></i>Edit
                                    </button>
                                    </a> -->

                                {{ $dataTable->table() }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal -->
    <div class="modal fade" id="editEmailModal" tabindex="-1" role="dialog" aria-labelledby="editEmailModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editEmailModalLabel">Update Email</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&ti ;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="{{ route('visitor.update-email') }}" method="post">
                        @csrf
                        <input type="hidden" name="id" id="modalId" class="form-control" value="">
                        <div class="form-group">
                            <label for="">Email</label>
                            <input type="text" name="email" class="form-control" id="modalEmail" value=""
                                required>
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Update</button>
                </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="sendEmailModal" tabindex="-1" role="dialog" aria-labelledby="sendEmailModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="sendEmailModalLabel">Select Email Type</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="{{ route('send.email') }}" method="post">
                        @csrf
                        <div class="form-group">
                            <input type="hidden" name="visitor_id" id="visitor_id">
                            <select class="form-control" name="email_type" id="email_type">
                                <option>Select Email</option>
                                <option value="primary">Primary Email</option>
                                <option value="followup">Follow Up Email</option>
                            </select>
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary close-modal">Send Email</button>
                </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Import Modal -->
    <form method="post" name="frm_no_kids" id="frm_no_kids" class="getstarted"
        action="{{ route('import.insertexportfile') }}" enctype="multipart/form-data">
        @csrf
        <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
            aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Import File</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <label for="">Select Team Member</label>
                        <select class="form-control custom-select" name="CustomerID">
                            @foreach ($user as $item)
                                <option value="{{ $item->CustomerID }}"
                                    @if ($item->CustomerID == $item->CustomerID) selected @endif>{{ $item->CustomerName }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="modal-body">
                        <label for="">Select Event</label>
                        <select class="form-control custom-select" name="event_id">
                            @foreach ($events as $val)
                                <option value="{{ $val->id }}" @if ($event_id == $val->id) selected @endif>
                                    {{ $val->event_name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="modal-body">
                        <a href="{{ asset('sample_new_file.xlsx') }}">
                            Download Sample File
                        </a>
                    </div>
                    <div class="modal-body">
                        Select File <input type="file" name="importfile" required>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>

                </div>
            </div>
        </div>
    </form>

    <!-- Modal -->
    <div class="modal fade" id="scheduleEmailModal" tabindex="-1" role="dialog"
        aria-labelledby="scheduleEmailModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editEmailModalLabel">Schedule Email</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route('visitor.set-mail') }}" method="get">
                    @csrf
                    <div class="modal-body">
                        <input type="hidden" value="" name="event_id" id="modalEvent_id">
                        <input type="hidden" value="" name="CustomerID" id="modalCustomerID">
                        <input type="hidden" value="" name="category_id" id="modalCategoryId">
                        <input type="hidden" value="" name="sub_category_id" id="modalSubCategoryId">
                        <input type="hidden" value="" name="state_id" id="modalStateId">
                        <input type="hidden" value="" name="city_id" id="modalCityId">
                        <input type="hidden" value="" name="is_international" id="modalIsInternational">
                        <input type="hidden" value="" name="country_id" id="modalCountryId">
                        <input type="hidden" value="" name="region" id="modalRegion">
                        <input type="hidden" value="" name="start_date" id="modalStartDate">
                        <input type="hidden" value="" name="end_date" id="modalEndDate">
                        <input type="hidden" value="other" name="type">
                        <div class="form-group">
                            <label class="form-label" for="">Schedule Date</label>
                            <input type="date" name="schedule_date" class="form-control col-lg-10"
                                id="modalScheduleDate" value="" required>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Select Email Draft</label>
                            <select class="form-control col-lg-10" name="email_draft_id" id="email_draft_id" required>
                                <option value="" selected disabled>Select Email Draft</option>
                                @foreach ($otherEmailDrafts as $emailDraft)
                                    <option value="{{ $emailDraft->id }}">{{ $emailDraft->subject }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Image Modal -->
    <div class="modal fade" id="modalimageshow" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-x" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalimageshowTitle"></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="table-responsive text-nowrap">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Image</th>
                                </tr>
                            </thead>
                            <tbody class="table-border-bottom-0" id="showImage">
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- event list Modal -->
    <div class="modal fade" id="modalieventlist" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-x" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalieventlistTitle">Event List</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="{{ route('visitor.update_event_name') }}" method="post">
                        @csrf
                        <input type="hidden" value="visitor_id" name="visitor_id[]" id="modalvisitor_id">
                        <div class="table-responsive text-nowrap">
                            <table class="table" id="showevetlist">
                                <thead>
                                    <tr>
                                        <th>Event Name</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody class="table-border-bottom-0">
                                </tbody>
                            </table>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- image file Modal -->
    <div class="modal fade" id="modalimagefile" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalimagefileTitle">File List</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="table-responsive text-nowrap">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>File</th>
                                    <th>Description</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody class="table-border-bottom-0" id="showfilewithimage">
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- show_visitor file Modal -->
    <div class="modal fade" id="show_visitordata" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="show_visitordataTitle">Multiple Entries</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="table-responsive text-nowrap">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Date</th>
                                    <th>Event Name</th>
                                    <th>TeamMember name</th>
                                    <th>Mobile Number</th>
                                    <th>Email</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody class="table-border-bottom-0" id="show_visitor">
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        {!! $dataTable->scripts() !!}
        <script>
           
        </script>
    @endpush

    <script>
        function checkExportFilter(elm) {
            var type = elm.id;
            var name = $('#name').val();
            var event_name = $('#event_name').val();
            var CustomerName = $('#CustomerName').val();
            var mobile_no = $('#mobile_no').val();
            var email = $('#email').val();
            var action = $('#action').val();

            $('#data').val([name, event_name, CustomerName, mobile_no, email, action]);
            $('#submit_export').click();
        }

        function exportImages(elm) {
            var event_id = $('#event_id').val();
            var CustomerID = $('#CustomerID').val();

            window.location = "{{ url('visitor/download-images') }}" + '?event_id=' + event_id + '&CustomerID=' +
                CustomerID;
        }

        function selectEmailType(id) {
            $('#visitor_id').val(id);
            $('#sendEmailModal').modal('show');
        }

        function editEmail(id) {
            $('#modalEmail').val($('.btn-' + id).data('email'));
            $('#modalId').val(id);
            $('#editEmailModal').modal('show');
        }

        function setOtherEmail() {
            $('#modalEvent_id').val($('#event_id').val());
            $('#modalCustomerID').val($('#CustomerID').val());
            $('#modalCategoryId').val($('#category_id').val());
            $('#modalSubCategoryId').val($('#sub_category_id').val());
            $('#modalStateId').val($('#state_id').val());
            $('#modalCityId').val($('#city_id').val());
            $('#modalIsInternational').val($('#is_international').val());
            $('#modalRegion').val($('#region').val());
            $('#modalStartDate').val($('#start_date').val());
            $('#modalEndDate').val($('#end_date').val());
            $('#modalCountryId').val($('#country_id').val());
            $('#scheduleEmailModal').modal('show');
        }

        $(function() {
            $('.close-modal').click(function() {
                $('#sendEmailModal').modal('hide');
                $('#email_type').val();
            });
        });

        $(document).ready(function() {
            var categoryId = "{{ $category_id }}";
            if (categoryId !== 'all') {
                fetchSubCategories(categoryId);
            }
            var region = "{{ $region }}";
            if (region !== 'all') {
                $('#is_international').attr('disabled', true);
                $('#country_id').attr('disabled', true);
                $('#state_id').attr('disabled', true);
                $('#city_id').attr('disabled', true);
            }
            var isInternational = "{{ $is_international }}";
            if (isInternational !== 'all' && isInternational !== 'false') {
                fetchCountries();
            } else if (isInternational !== 'all' && isInternational === 'false') {
                var options = [];
                var selectedValue = 'selected';
                var valueId = 99;
                var valueName = "India";
                selectData = '<option value="' + valueId + '" ' + selectedValue + ' >' + valueName +
                    '</option>';
                options.push(selectData);
                $('#country_id').html('<option value="all">All</option>' +
                    options);
                $('#country_id').attr('disabled', true);
                fetchStates('99');
            }
            var countryId = "{{ $country_id }}";
            if (countryId !== 'all') {
                fetchStates(countryId);
            }
            var stateId = "{{ $state_id }}";
            if (stateId !== 'all') {
                fetchCities(stateId);
            }
            console.log($('meta[name="csrf-token"]').attr('content'));
            $('.token').val($('meta[name="csrf-token"]').attr('content'));
        });

        function sendMail(type) {
            $('#formType').val(type);
            $('#myform').attr('action', '{!! route('visitor.set-mail') !!}');
            $('#myform').submit();
        }

        function showImage(elm) {
            var id = $(elm).attr('data-id');
            $.ajax({
                url: "{{ url('ajax/get_image') }}",
                type: "GET",
                data: {
                    id: id,
                },
                success: function(response) {
                    if (response) {
                        $("#showImage").html('');

                        $.each(response['data'], function(i, item) {
                            var imageUrl = item['front_image'];
                            var static_image = '../no-image.png';
                            var images = imageUrl.substring(imageUrl.indexOf('/frenzincrm_api'));

                            var html = '<tr>' + '<td>';

                            if (imageUrl && imageUrl.trim() !== '') {
                                html += '<img src="' + images +
                                    '" alt="" class="img" style="height: 240px; width: 450px">';
                            } else {
                                html += '<img src="' + static_image +
                                    '" alt="" class="img" style="height: 240px; width: 450px">';
                            }

                            html += '</td>' +
                                '</tr>';
                            // html =  `<tr>
                        //             <td>
                        //                 <img  src="` + imageUrl + `" alt=""  class="img" style="height: 240px;width:450px">
                        //             </td>
                        //         </tr>`;
                            $("#showImage").append(html);
                            $("#modalimageshow").modal('show');
                        });
                    } else {
                        alert('no data found!')
                    }
                },
                error: function(error) {
                    console.log(error);
                }
            });
        }

        function showfilewithimage(elm) {
            var mobile_number = $(elm).attr('data-mobile_number');
            $.ajax({
                url: "{{ url('ajax/get_productlist') }}",
                type: "GET",
                data: {
                    mobile_number: mobile_number,
                },
                success: function(response) {
                    if (response) {
                        $("#showfilewithimage").html('');
                        $.each(response['data'], function(i, item) {

                            var imageName = item.image.split('/').pop();
                            var imageNameX = item.image.split('.').pop();

                            var html = `<tr>
                        <td><strong>${item['id']}</strong></td>
                        <td>
                            <a href="${item['image']}" target="_blank" style="text-decoration: none;">
                                ${imageNameX === 'pdf' ? `<i class="far fa-file-pdf pdf-icon fa-2x" style="color:red;"></i> ${imageName}` : `<img src="${item['image']}" alt="" class="img">`}
                            </a>
                        </td>
                        <td>${item['description']}</td>
                        <td>
                            <a href="https://wa.me/${mobile_number}?text=(${item['image']})" target="_blank">
                                <i class="fab fa-whatsapp" style="font-size: 31px; color: #25D366; margin-left: 37px;"></i>
                            </a>
                        </td>
                    </tr>`;
                            $("#showfilewithimage").append(html);
                            $("#modalimagefile").modal('show');
                        });
                    } else {
                        alert('no data found!')
                    }
                },
                error: function(error) {
                    console.log(error);
                }
            });
        }

        function deletePopupvisitor(elm) {
            let id = $(elm).data('id');
            let url = $(elm).data('url');
            swal({
                title: 'Are you sure!',
                icon: 'error',
                dangerMode: true,
                buttons: true,
                confirm: "Confirm",
            }).then(function(isConfirm) {
                if (isConfirm === true) {
                    $.ajax({
                        type: 'GET',
                        url: url,
                        dataType: 'json',
                        success: function(data) {
                            location.reload(true);
                        },
                        error: function(data) {
                            console.log(data);
                        }
                    });
                }
            });
        }

        $('#category_id').change(function() {
            var id = $(this).val();
            if (id !== 'all') {
                fetchSubCategories(id);
            }
        });

        function fetchSubCategories(id) {
            var url = "{{ route('get_sub_categories') }}";
            $.ajax({
                url: url,
                type: "GET",
                data: {
                    category_id: id,
                },
                success: function(response) {
                    var options = [];
                    var rData = [];
                    rData = response.data;
                    $.each(rData, function(index, value) {
                        var selectData = '';
                        var subCategory = "{{ $sub_category_id }}";
                        var selectedValue = subCategory == value.id ? 'selected' : '';
                        selectData = '<option value="' + value.id + '" ' + selectedValue + ' >' + value
                            .name +
                            '</option>';
                        options.push(selectData);
                    });
                    $('#sub_category_id').html('<option value="all">All</option>' +
                        options);
                },
                error: function(error) {
                    console.log(error);
                }
            });
        }

        $('#is_international').change(function() {
            var isInternational = $(this).val();
            $('#country_id').html('<option value="all">All</option>');
            $('#state_id').html('<option value="all">All</option>');
            $('#city_id').html('<option value="all">All</option>');
            $('#country_id').attr('disabled', false);
            if (isInternational !== 'all' && isInternational !== 'false') {
                fetchCountries();
            } else if (isInternational !== 'all' && isInternational === 'false') {
                var options = [];
                var selectedValue = 'selected';
                var valueId = 99;
                var valueName = "India";
                selectData = '<option value="' + valueId + '" ' + selectedValue + ' >' + valueName +
                    '</option>';
                options.push(selectData);
                $('#country_id').html('<option value="all">All</option>' +
                    options);
                $('#country_id').attr('disabled', true);
                fetchStates('99');
            }
        });

        function fetchCountries() {
            var url = "{{ route('get_countries') }}";
            $.ajax({
                url: url,
                type: "GET",
                success: function(response) {
                    var options = [];
                    var rData = [];
                    rData = response.data;
                    $.each(rData, function(index, value) {
                        var selectData = '';
                        var country = "{{ $country_id }}";
                        var selectedValue = country == value.id ? 'selected' : '';
                        selectData = '<option value="' + value.id + '" ' + selectedValue + ' >' + value
                            .name +
                            '</option>';
                        options.push(selectData);
                    });
                    $('#country_id').html('<option value="all">All</option>' +
                        options);
                },
                error: function(error) {
                    console.log(error);
                }
            });
        }

        $('#country_id').change(function() {
            var countryId = $(this).val();
            if (countryId !== 'all') {
                fetchStates(countryId);
            }
        });

        function fetchStates(countryId) {
            var url = "{{ route('get_states') }}";
            $.ajax({
                url: url,
                type: "GET",
                data: {
                    countryId: countryId,
                },
                success: function(response) {
                    var options = [];
                    var rData = [];
                    rData = response.data;
                    $.each(rData, function(index, value) {
                        var selectData = '';
                        var state = "{{ $state_id }}";
                        var selectedValue = state == value.id ? 'selected' : '';
                        selectData = '<option value="' + value.id + '" ' + selectedValue + ' >' + value
                            .name +
                            '</option>';
                        options.push(selectData);
                    });
                    $('#state_id').html('<option value="all">All</option>' +
                        options);
                },
                error: function(error) {
                    console.log(error);
                }
            });
        }

        $('#state_id').change(function() {
            var stateId = $(this).val();
            if (stateId !== 'all') {
                fetchCities(stateId);
            }
        });

        function fetchCities(stateId) {
            var url = "{{ route('get_cities') }}";
            $.ajax({
                url: url,
                type: "GET",
                data: {
                    stateId: stateId,
                },
                success: function(response) {
                    var options = [];
                    var rData = [];
                    rData = response.data;
                    $.each(rData, function(index, value) {
                        var selectData = '';
                        var city = "{{ $city_id }}";
                        var selectedValue = city == value.id ? 'selected' : '';
                        selectData = '<option value="' + value.id + '" ' + selectedValue + ' >' + value
                            .name +
                            '</option>';
                        options.push(selectData);
                    });
                    $('#city_id').html('<option value="all">All</option>' +
                        options);
                },
                error: function(error) {
                    console.log(error);
                }
            });
        }

        $('#region').change(function() {
            var region = $(this).val();
            if (region !== 'all') {
                $('#is_international').attr('disabled', true);
                $('#country_id').attr('disabled', true);
                $('#state_id').attr('disabled', true);
                $('#city_id').attr('disabled', true);
            } else {
                $('#is_international').attr('disabled', false);
                $('#country_id').attr('disabled', false);
                $('#state_id').attr('disabled', false);
                $('#city_id').attr('disabled', false);
            }
        });
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>


    <script>
        var selectedData = [];

        function getid(elm) {

            var id = $(elm).attr('data-id');
            if (!selectedData.includes(id)) {
                selectedData.push(id);
            }
            var event_id = $(elm).attr('data-event_id');
        }
        $(document).ready(function() {
            var table = $('#showevetlist').DataTable({
                paging: true,
                searching: true
            });

            $('#move-button').click(function() {
                if (selectedData.length > 0) {
                    var jsonData = JSON.stringify(selectedData);
                    $.ajax({
                        url: "{{ url('ajax/get_eventlist') }}",
                        type: "GET",
                        data: {
                            id: jsonData,
                        },
                        success: function(response) {
                            if (response && response.data.length > 0) {
                                // Clear existing table data
                                table.clear();

                                // Add new data to the table
                                response.data.forEach(function(item) {
                                    table.row.add([
                                        item.event_name,
                                        '<input type="radio" name="eventid" value="' +
                                        item.id + '" required>'
                                    ]).draw();
                                });

                                // Show the modal
                                $('#modalvisitor_id').val(jsonData);
                                $("#modalieventlist").modal('show');
                            } else {
                                alert('No data found!');
                            }
                        },
                        error: function(error) {
                            console.log(error);
                        }
                    });
                }
            });
        });

        function show_visitor(elm) {
            var id = $(elm).attr('data-id');
            var email = $(elm).attr('data-email');
            var mobile_no = $(elm).attr('data-mobile_no');
            
            $.ajax({
                url: "{{ url('ajax/get_visitorlist_id') }}",
                type: "GET",
                data: {
                    id: id,
                    email: email,
                    mobile_no: mobile_no,
                },
                success: function(response) {
                    if (response) {
                        $("#show_visitor").html('');
                        $.each(response['data'], function(i, item) {
                            var visitedDate = moment(item['visited_date'], 'YYYY-MM-DD HH:mm:ss');
                            var detailUrl = "{{ route('visitor.detail', ['id' => '__ID__']) }}".replace('__ID__', item['id']);    
                            if (visitedDate.isValid()) {
                                var formattedVisitedDate = visitedDate.format('D/M/Y');
                            } else {
                                var formattedVisitedDate = '';
                            }

                            var deleteUrl = "{{ route('visitor.Multiple_Entries_destroy', ':id') }}";
                            deleteUrl = deleteUrl.replace(':id', item['id']);

                            var html = `<tr>
                            <td> <a href="${detailUrl}"">
                                  ${item['id']} 
                                </a></td>
                            <td>${formattedVisitedDate}</td>
                            <td>${item['event_name']}</td>
                            <td>${item['CustomerName']}</td>
                            <td>${item['mobile_no'] || '-'}</td>
                            <td>${item['email'] || '-'}</td>
                            <td>
                              
                                <a data-toggle="modal" data-target="#deletePopup" data-url="${deleteUrl}"  data-id="${item['id']}"
                                    onclick="deletePopupvisitor_Multiple(this)">
                                    <button class="btn btn-danger btn-sm" data-toggle="tooltip" data-placement="right" title="Delete " style="margin-top: 10px;margin-left: 9px;">
                                        <i class="fas fa-trash" aria-hidden="true"></i>
                                    </button>
                                </a>
                            </td>
                        </tr>`;
                            $("#show_visitor").append(html);
                            $("#show_visitordata").modal('show');
                        });
                    } else {
                        alert('no data found!')
                    }
                },
                error: function(error) {
                    console.log(error);
                }
            });
        }

        function deletePopupvisitor_Multiple(elm) {
            let id = $(elm).data('id');
            let url = $(elm).data('url');
            swal({
                title: 'Are you sure!',
                icon: 'error',
                dangerMode: true,
                buttons: true,
                confirm: "Confirm",
            }).then(function(isConfirm) {
                if (isConfirm === true) {
                    $.ajax({
                        type: 'GET',
                        url: url,
                        dataType: 'json',
                        success: function(data) {
                            location.reload(true);
                        },
                        error: function(data) {
                            console.log(data);
                        }
                    });
                }
            });
        }

        // $('#move-button').click(function() {
        //     if(selectedData != ''){
        //         var jsonData = JSON.stringify(selectedData);
        //         $.ajax({
        //             url: "{{ url('ajax/get_eventlist') }}",
        //             type: "GET",
        //             data: {
        //                 id: jsonData,
        //             },
        //             success: function(response) {
        //                 if (response) {
        //                     $("#showevetlist").html('');
        //                     $.each(response['data'], function(i, item) {
        //                         html =  `<tr>
    //                                     <td>
    //                                         ` + item['event_name'] + `
    //                                     </td>
    //                                     <td>
    //                                         <input type="radio" name="eventid"  id="event_name" value=" ` + item['id'] + `" required>
    //                                     </td>
    //                                 </tr>`;
        //                         $("#showevetlist").append(html);
        //                         $('#modalvisitor_id').val(jsonData);
        //                         $("#modalieventlist").modal('show');
        //                     });
        //                     table.draw();
        //                 } else {
        //                     alert('no data found!')
        //                 }
        //             },
        //             error: function(error) {
        //                 console.log(error);
        //             }
        //         });
        //     }

        // });
    </script>

@endsection
