@extends('layouts.master')
@section('content')
<style>
label.error{
color: red;
}
.select2-selection__choice{
    color: black !important;
}
.card-header {
    color: #fff;
    background-color: #007bff;
}
img {
    height:auto;
    width: 166px;
    object-fit: scale-down;
}

#fullpage {
    display: none;
    position: absolute;
    z-index: 9999;
    top: 0;
    left: 0;
    width: 80.3vw;
    height: 90vh;
    background-size: contain;
    background-repeat: no-repeat no-repeat;
    background-position: center center;
    background-color: black;
}
.image-gallery {
    display: flex;
    flex-wrap: wrap;
    margin: -5px;
}

.gallery-item {
    flex: 1.1 0 calc(33.33% - 10px);
    box-sizing: border-box;
    padding: 5px;
}
.img2 {
    height: 200px; /* Set the height to your desired value */
    object-fit: cover; /* This property ensures that the image retains its aspect ratio and covers the entire container */
}
</style>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Edit Client</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('visitor.list') }}">Client List</a></li>
                        <li class="breadcrumb-item active">Edit Client</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card card-primary card-outline">
                        <div class="card-body box-profile">
                            <div class="text-center" onload="getPics()">
                                <div class="gallery">
                                    <div style="overflow-x:scroll;white-space:nowrap;" >
                                        @foreach($event_images as $images)
                                            @php
                                                $modified_image_path = substr($images->event_image, strpos($images->event_image, '/frenzincrm_api'));
                                                $imagePathInfo = pathinfo($images->event_image);
                                                $extension = strtolower($imagePathInfo['extension']);
                                            @endphp
                                           
                                            @if ($extension === 'pdf')
                                                <a href="{{$modified_image_path}}" target="_blank" style="text-decoration: none;">
                                                    <img src="{{ asset('pdficon.png') }}" style="width: 139px; height: 166px;"
                                                    class="img" alt="" >
                                                </a>
                                            @else
                                                <img src="{{$modified_image_path}}" style="width: 301px; height: 166px;"
                                                    class="img" alt="" >
                                            @endif
                                        @endforeach
                                        <?php 
                                            $images = substr($visitor->front_image, strpos($visitor->front_image, '/frenzincrm_api'));
                                            $back_images = substr($visitor->back_image, strpos($visitor->back_image, '/frenzincrm_api'));
                                        ?>
                                        @if(isset($visitor->front_image) && $visitor->front_image != NULL)
                                            <img  src="{{$images }}" class="img" alt="" style="width: 301px; height: 166px;">
                                        @endif
                                        @if(isset($visitor->back_image) && $visitor->back_image != NULL)
                                            <img class="img" src="{{ $back_images }}" alt="" style="width: 301px; height: 166px;">
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div id="fullpage" onclick="this.style.display='none';"></div>
                            <h3 class="profile-username text-center">@if(isset($visitor->name)){{ $visitor->name }}@endif</h3>
                            @if(!empty($visitor->lat))
                                <div style="width: 25px; margin-left: 600px;margin-top: -35px">
                                    <a href="http://www.google.com/maps/place/{{ $visitor->lat }},{{ $visitor->lng }}" class="" target="_blank">
                                        <svg viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><clipPath id="a"><use xlink:href="#b"/></clipPath><rect id="b" fill="#fff" height="512" rx="15%" width="512"/><g clip-path="url(#a)"><path d="m0 512v-512h512z" fill="#35a85b"/><path d="m256 288-224 224h448z" fill="#5881ca"/><path d="m288 256 224-224v448z" fill="#c1c0be"/><path d="m0 512 512-512" stroke="#fadb2a" stroke-width="71"/><path d="m175 173h50a50 54 0 1 1 -15-41" fill="none" stroke="#f2f2f2" stroke-width="22"/><path d="m353 85a70 70 0 0 1 140 0c0 70-70 70-70 157 0-87-70-87-70-157" fill="#de3738"/><circle cx="423" cy="89" fill="#7d2426" r="25"/></g></svg>
                                    </a>
                                </div>
                            @endif
                            <p class="text-muted text-center">
                                @if(isset($visitor->mobile_no))
                                    <a href="tel:{{$visitor->mobile_no}}" style="text-decoration: none;">{{$visitor->mobile_no}}
                                    </a>
                                @endif
                            </p>
                        </div>
                    </div>
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    {{--<i class="fas fa-minus"></i>--}}
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form id="visitorEditForm" method="post" action="{{ route('visitor.update',$visitor->id) }}" name="form" enctype="multipart/form-data">
                                @csrf
                                <div class="form-group">
                                    <label for="">Visited Date</label>
                                    <input type="datetime-local" name="visited_date" value="{{$visitor->visited_date}}" class="form-control" placeholder="Enter Visited Date">
                                    @error('visited_date')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Name</label>
                                    <input type="text" name="name" class="form-control" placeholder="Enter Name"
                                           value="{{$visitor->name}}" required>
                                    @error('name')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Designation</label>
                                    <input type="text" name="designation" class="form-control" placeholder="Enter Designation"
                                           value="{{$visitor->designation}}">
                                    @error('designation')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Company Name</label>
                                    <input type="text" name="company_name" class="form-control" placeholder="Enter Company Name"
                                        value="{{$visitor->company_name}}">
                                    @error('company_name')
                                        <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Website</label>
                                    <input type="text" name="website" class="form-control" placeholder="Enter Website"
                                           value="{{$visitor->website}}">
                                    @error('website')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Country Code</label>
                                    <select class="form-control custom-select" name="country_code" id="country_code">
                                        <option value="" @if($visitor->country_code== null ) selected @endif>No Country</option>
                                        @foreach($countries as $country)
                                            <option value="{{ $country->iso_code }}" @if($country->iso_code==$visitor->country_code) selected
                                                @endif>{{$country->name}}</option>
                                        @endforeach
                                    </select>
                                    @error('country')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Mobile No.</label>
                                    <input type="text" name="mobile_no" class="form-control" placeholder="Enter Mobile No"
                                           value="{{$visitor->mobile_no}}">
                                    @error('mobile_no')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Mobile No. 2</label>
                                    <input type="text" name="mobile_no2" class="form-control" placeholder="Enter Mobile No2"
                                           value="{{$visitor->mobile_no2}}">
                                    @error('mobile_no2')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Mobile No. 3</label>
                                    <input type="text" name="mobile_no3" class="form-control" placeholder="Enter Mobile No3"
                                           value="{{$visitor->mobile_no3}}">
                                    @error('mobile_no3')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Email</label>
                                    <input type="text" name="email" class="form-control" placeholder="Enter Email"
                                           value="{{$visitor->email}}">
                                    @error('email')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Email 2</label>
                                    <input type="text" name="email2" class="form-control" placeholder="Enter Email2"
                                           value="{{$visitor->email2}}">
                                    @error('email2')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Address Country Code</label>
                                    <select class="form-control custom-select" name="address_country_code" id="address_country_code">
                                        <option value="" @if($visitor->address_country_code== null ) selected @endif>No Country</option>
                                        @foreach($countries as $country)
                                            <option value="{{ $country->iso_code }}" @if($country->iso_code==$visitor->address_country_code) selected
                                                @endif>{{$country->name}}</option>
                                        @endforeach
                                    </select>
                                    @error('country')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                              
                                <div class="form-group">
                                    <label for="">State</label>
                                    <div class="states-dropdown">
                                        <select class="form-control custom-select" name="state" id="state_id">
                                            @if($states)
                                                <option value="" @if($visitor->state== null ) selected @endif>No State</option>
                                                @foreach($states as $state)                                                
                                                    <option value="{{ $state->id }}" @if($state->id==$visitor->state) selected
                                                        @endif>{{$state->name}}</option>
                                                @endforeach
                                            @else
                                                <option value="" @if($visitor->state== null ) selected @endif>No State</option>
                                            @endif
                                        </select>
                                    </div>
                                    {{-- <div class="states-textbox">
                                        <input type="text" id="state_textbox" name="state" class="form-control" placeholder="Enter State">
                                    </div> --}}
                                    @error('state')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>                               
                                <div class="form-group">
                                    <label for="">City</label>
                                    <div class="cities-dropdown">
                                        <select class="form-control custom-select" name="city" id="city_id">
                                            @if($cities)
                                                <option value="" @if($visitor->city== null ) selected @endif>No City</option>
                                                @foreach($cities as $city)
                                                    <option value="{{ $city->name }}" @if($city->name==$visitor->city) selected
                                                        @endif>{{$city->name}}</option>
                                                @endforeach
                                            @else
                                                <option value="" @if($visitor->city== null ) selected @endif>No City</option>
                                            @endif
                                        </select>
                                    </div>
                                    {{-- <div class="cities-textbox">
                                        <input type="text" id="city_textbox" name="city" class="form-control" placeholder="Enter City">
                                    </div> --}}
                                    @error('city')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Address</label>
                                    <input type="text" name="address" class="form-control" placeholder="Enter Address"
                                           value="{{$visitor->address}}">
                                    @error('address')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Pincode</label>
                                    <input type="text" name="pincode" class="form-control" placeholder="Enter Pincode"
                                           value="{{$visitor->pincode}}">
                                    @error('pincode')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>                                
                                <div class="form-group">
                                    <label for="">Category</label>
                                    <select class="form-control custom-select" name="category[]" id="category_id">
                                        <option></option>
                                    </select>
                                    @error('category')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">SubCategory</label>
                                    <select class="form-control custom-select" name="sub_category[]" id="sub_category_id">
                                        @if($subcategories)
                                            <option value="" @if($visitor->sub_category== null ) selected @endif>No SubCategory</option>
                                            @foreach($subcategories as $subcategory)
                                                <option value="{{ $subcategory->name }}" @if(in_array($subcategory->name,$visitor->sub_category)) selected
                                                    @endif>{{$subcategory->name}}</option>
                                            @endforeach
                                        @else
                                            <option value="" @if($visitor->sub_category== null ) selected @endif>No SubCategory</option>
                                        @endif
                                    </select>
                                    @error('sub_category')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>                                
                                <div class="form-group">
                                    <label for="">Follow up time</label>
                                    <input type="datetime-local" name="follow_up_time" class="form-control" placeholder="Enter Follow Up Time"
                                           value="{{$visitor->follow_up_time}}">
                                    @error('follow_up_time')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Action</label>
                                    <select class="form-control custom-select" name="action" id="action">
                                        <option value="" @if($visitor->action== null ) selected @endif>No Action</option>
                                        @foreach($actions as $action)
                                        <option value="{{ $action->title }}" @if($action->title==$visitor->action) selected
                                                @endif>{{$action->title}}</option>
                                        @endforeach
                                    </select>
                                    @error('action')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Remarks</label>
                                    <input type="text" name="remarks" class="form-control" placeholder="Enter Remarks"
                                           value="{{$visitor->remarks}}">
                                    @error('remarks')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">QR Code Value</label>
                                    <input type="text" name="qrcodevalue" class="form-control" placeholder="Enter QR Code Value"
                                           value="{{$visitor->qrcodevalue}}">
                                    @error('qrcodevalue')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="priority">Priority</label>
                                    <select name="rating" id="priority" class="form-control">
                                        <option value="">Select Priority</option>
                                        <option value="High" {{ $visitor->rating === 'High' ? 'selected' : '' }}>High</option>
                                        <option value="Medium" {{ $visitor->rating === 'Medium' ? 'selected' : '' }}>Medium</option>
                                        <option value="Low" {{ $visitor->rating === 'Low' ? 'selected' : '' }}>Low</option>
                                    </select>
                                    @error('rating')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Monthly Requirement</label>
                                    <input type="text" name="monthly_requirement" class="form-control" placeholder="Enter Monthly Requirement"
                                           value="{{$visitor->monthly_requirement}}">
                                    @error('monthly_requirement')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Products</label>
                                    <select class="form-control custom-select" name="products[]" id="product_id">
                                        <option></option>
                                    </select>
                                </div>
                                <div class="card-footer">
                                <button type="submit" class="btn btn-primary" >Update</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function getPics() {}
    const imgs = document.querySelectorAll('.gallery img');
    const fullPage = document.querySelector('#fullpage');

    imgs.forEach(img => {
        var imageUrl = img.src;
        var images = imageUrl.substring(imageUrl.indexOf('/frenzincrm_api'));
        img.addEventListener('click', function() {
            fullPage.style.backgroundImage = 'url(' + images + ')';
            fullPage.style.display = 'block';
        });
    });
    $(document).ready(function() {
        $('#visitorEditForm').validate()
        var addressCountryCode = "{{$visitor->address_country_code}}";
        if(addressCountryCode === '' ){
            //console.log('null');
            $('.states-textbox').css('display','none');
            $('.cities-textbox').css('display','none');
            $('.states-dropdown').show();
            $('.cities-dropdown').show();
        }
        if(addressCountryCode === 'IN'){
            //console.log('IN');
            $('.states-textbox').css('display','none');
            $('.cities-textbox').css('display','none');
            $('.states-dropdown').show();
            $('.cities-dropdown').show();
            fetchStates(addressCountryCode);
        }else{
            //console.log('else');
            $('.states-dropdown').css('display','none');
            $('.cities-dropdown').css('display','none');
            $('.states-textbox').show();
            $('.cities-textbox').show();
            $('#state_textbox').val("{{$visitor->state}}");
            $('#city_textbox').val("{{$visitor->city}}");
        }
        $('#category_id').on("select2:select", function(e) {
            var categoryNames = [];
            $(e.currentTarget).find("option:selected").each(function(i, selected){
                categoryNames[i] = $(selected).text();
            });
            fetchSubCategories(categoryNames);
        });
        $('#category_id').on("select2:unselect", function(e) {
            var categoryNames = [];
            $(e.currentTarget).find("option:selected").each(function(i, selected){
                categoryNames[i] = $(selected).text();
            });
            if(categoryNames.length !== 0){
                fetchSubCategories(categoryNames);
            }else{
                var subCategoryId = $('#sub_category_id');
                $('#sub_category_id').html('');
                subCategoryId.val(null).trigger('change');
            }
        });
        $("#category_id").select2({
            placeholder: "Select a category",
            multiple: true,
        });
        $("#sub_category_id").select2({
            placeholder: "Select a sub category",
            multiple: true,
        });
        $("#product_id").select2({
            placeholder: "Select product",
            multiple: true,
        });
        setSelectedCategories()
        setSelectedProducts()
    });
    function setSelectedProducts()
    {
        var visitorProductIds = "{{ implode(',',$visitor->products) }}";
        var allProducts = '{!! ($allProducts)  !!}';
        var options = [];
        var productId = $('#product_id');
        productId.html('');
        productId.val(null).trigger('change');
        $.each(JSON.parse(allProducts), function(index, value) {
            var selected = false;
            if(jQuery.inArray(value.id.toString(), visitorProductIds.split(',')) !== -1){
                selected = true;
            }
            var option = new Option(value.name, value.id, false, selected);
            productId.append(option).trigger('change');
            options.push({id:value.id,text:value.name});
        });
        // manually trigger the `select2:select` event
        productId.trigger({
            type: 'select2:select',
            params: {
                data: options
            }
        });
    }
    function setSelectedCategories()
    {
        var categoryNames = "{{implode(',',$visitor->category)}}";
        var allCategories = '{!! ($categories)  !!}';
        var options = [];
        var categoryId = $('#category_id');
        categoryId.html('');
        categoryId.val(null).trigger('change');
        $.each(JSON.parse(allCategories), function(index, value) {
            var selected = false;
            if(jQuery.inArray(value.name, categoryNames.split(',')) !== -1){
                selected = true;
            }
            var option = new Option(value.name, value.name, false, selected);
            categoryId.append(option).trigger('change');
            options.push(value.name);
        });
        // manually trigger the `select2:select` event
        categoryId.trigger({
            type: 'select2:select',
            params: {
                data: options
            }
        });
    }
    function fetchSubCategories(categoryNames) {
        var url = "{{ route('get_sub_categories') }}";
        var selectedSubCategoryNames = "{{ implode(',',$visitor->sub_category) }}";
        $.ajax({
            url: url,
            type: "GET",
            data: {
                categoryNames: categoryNames,
                selectedSubCategoryNames: selectedSubCategoryNames,
            },
            success: function(response) {
                var options = [];
                var rData = [];
                rData = response.data;
                selectedSubCategoryIds = response.selectedSubCategoryIds;
                var subCategoryId = $('#sub_category_id');
                $('#sub_category_id').html('');
                subCategoryId.val(null).trigger('change');
                $.each(rData, function(index, value) {
                    var selected = false;
                    if(jQuery.inArray(value.id, selectedSubCategoryIds) !== -1){
                        selected = true;
                    }
                    var option = new Option(value.name, value.name, false, selected);
                    subCategoryId.append(option).trigger('change');
                    options.push(value.name);
                });
                // manually trigger the `select2:select` event
                subCategoryId.trigger({
                    type: 'select2:select',
                    params: {
                        data: options
                    }
                });
            },
            error: function(error) {
                console.log(error);
            }
        });
    }

    $('#address_country_code').change(function() {
        var countryCode = $(this).val();
        if(countryCode !=='all' && countryCode === 'IN'){
            $('.states-textbox').css('display','none');
            $('.cities-textbox').css('display','none');
            $('.states-dropdown').show();
            $('.cities-dropdown').show();
            fetchStates(countryCode);
        }else{
            $('.states-dropdown').css('display','none');
            $('.cities-dropdown').css('display','none');
            $('.states-textbox').show();
            $('.cities-textbox').show();
        }
    });
    function fetchStates(countryCode) {
        var oldStateId ="{{$visitor->state}}";        
        var url = "{{ route('get_states') }}";
        $.ajax({
            url: url,
            type: "GET",
            data: {
                countryCode: countryCode,
            },
            success: function(response) {
                var options = [];
            var rData = response.data;

            $.each(rData, function(index, value) {
                var selected = '';
                if (value.name == oldStateId) {
                    selected = 'selected'; // Add 'selected' attribute if oldStateId matches
                }
                var selectData = '<option value="' + value.name + '" ' + selected + '>' + value.name + '</option>';
                options.push(selectData);
            });

            $('#state_id').html('<option value="">No State</option>' + options.join(''));
            },
            error: function(error) {
                console.log(error);
            }
        });
    }

    $('#state_id').change(function() {       
        var stateName = $(this).val();
        fetchCities(stateName);
    });

    // $(document).on('change', '#state_id option', function() {
    //     var stateId = $(this).val();
    //     fetchCities(stateId);
    // });

    function fetchCities(stateName) {
        var oldCityName = "{{$visitor->city}}";
        var url = "{{ route('get_cities') }}";
        $.ajax({
            url: url,
            type: "GET",
            data: {
                stateName: stateName,
            },
            success: function(response) {
                var options = [];
                var rData = response.data;

                $.each(rData, function(index, value) {
                    var selected = '';
                    if (value.name === oldCityName) {
                        selected = 'selected'; // Add 'selected' attribute if city name matches oldCityName
                    }
                    var selectData = '<option value="' + value.name + '" ' + selected + '>' + value.name + '</option>';
                    options.push(selectData);
                }); 

                $('#city_id').html('<option value="">No City</option>' + options.join(''));
            },
            error: function(error) {
                console.log(error);
            }
        });
    }
</script>
@endsection
