@extends('layouts.master')
@section('content')
<style>
.select2-selection__choice{
    color: black !important;
}
.card-header {
    color: #fff;
    background-color: #007bff;
}

label.error{
color: red;
}
img {
    height:auto;
    width: 166px;
    object-fit: scale-down;
}

#fullpage {
    display: none;
    position: absolute;
    z-index: 9999;
    top: 0;
    left: 0;
    width: 80.3vw;
    height: 90vh;
    background-size: contain;
    background-repeat: no-repeat no-repeat;
    background-position: center center;
    background-color: black;
}
.image-gallery {
    display: flex;
    flex-wrap: wrap;
    margin: -5px;
}

.gallery-item {
    flex: 1.1 0 calc(33.33% - 10px);
    box-sizing: border-box;
    padding: 5px;
}
.img2 {
    height: 200px; /* Set the height to your desired value */
    object-fit: cover; /* This property ensures that the image retains its aspect ratio and covers the entire container */
}
</style>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Add Client</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('visitor.list') }}">Client List</a></li>
                        <li class="breadcrumb-item active">Add Client</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    {{--<i class="fas fa-minus"></i>--}}
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form id="visitorAddForm" method="post" action="{{ route('visitor.store') }}" name="form" enctype="multipart/form-data">
                                @csrf
                                <div class="form-group">
                                    <label for="">Visited Date</label>
                                    <input type="datetime-local" name="visited_date" value="{{ now()->setTimezone('Asia/Kolkata')->format('Y-m-d H:i') }}" class="form-control" placeholder="Enter Visited Date">
                                    @error('visited_date')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Select Event</label>
                                    <select class="form-control custom-select" name="event_id" id="event_id" required>
                                        <option value="" >Select event</option>
                                        @foreach($events as $event)
                                            <option value="{{ $event->id }}" >{{$event->event_name}}</option>
                                        @endforeach
                                    </select>
                                    @error('event_id')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Select Team Member</label>
                                    <select class="form-control custom-select" name="customer_id" id="customer_id" required>
                                        <option value="" >Select member</option>
                                        @foreach($members as $member)
                                            <option value="{{ $member->CustomerID }}" >{{$member->CustomerName}}</option>
                                        @endforeach
                                    </select>
                                    @error('customer_id')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Name</label>
                                    <input type="text" name="name" class="form-control" placeholder="Enter Name" required>
                                    @error('name')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Designation</label>
                                    <input type="text" name="designation" class="form-control" placeholder="Enter Designation">
                                    @error('designation')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Company Name</label>
                                    <input type="text" name="company_name" class="form-control" placeholder="Enter Company Name">
                                    @error('company_name')
                                        <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>                               
                                <div class="form-group">
                                    <label for="">Website</label>
                                    <input type="text" name="website" class="form-control" placeholder="Enter Website">
                                    @error('website')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Country Code</label>
                                    <select class="form-control custom-select" name="country_code" id="country_code">
                                        <option value="" >No Country</option>
                                        @foreach($countries as $country)
                                            <option value="{{ $country->iso_code }}" @if($country->iso_code== $countryCode) selected
                                                @endif >{{$country->name}}</option>
                                        @endforeach
                                    </select>
                                    @error('country')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Mobile No.</label>
                                    <input type="text" name="mobile_no" class="form-control" placeholder="Enter Mobile No">
                                    @error('mobile_no')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Mobile No. 2</label>
                                    <input type="text" name="mobile_no2" class="form-control" placeholder="Enter Mobile No2">
                                    @error('mobile_no2')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Mobile No. 3</label>
                                    <input type="text" name="mobile_no3" class="form-control" placeholder="Enter Mobile No3">
                                    @error('mobile_no3')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Email</label>
                                    <input type="text" name="email" class="form-control" placeholder="Enter Email">
                                    @error('email')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Email 2</label>
                                    <input type="text" name="email2" class="form-control" placeholder="Enter Email2">
                                    @error('email2')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Address Country Code</label>
                                    <select class="form-control custom-select" name="address_country_code" id="address_country_code">
                                        <option value="">No Country</option>
                                        @foreach($countries as $country)
                                            <option value="{{ $country->iso_code }}" @if($country->iso_code== $countryCode) selected
                                                @endif>{{$country->name}}</option>
                                        @endforeach
                                    </select>
                                    @error('country')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">State</label>
                                    <div class="states-dropdown">
                                        <select class="form-control custom-select" name="state" id="state_id">
                                            <option value="">No State</option>
                                        </select>
                                    </div>
                                    {{-- <div class="states-textbox">
                                        <input type="text" id="state_textbox" name="state" class="form-control" placeholder="Enter State">
                                    </div> --}}
                                    @error('state')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">City</label>
                                    <div class="cities-dropdown">
                                        <select class="form-control custom-select" name="city" id="city_id">
                                            <option value="">No City</option>
                                        </select>
                                    </div>
                                    {{-- <div class="cities-textbox">
                                        <input type="text" id="city_textbox" name="city" class="form-control" placeholder="Enter City">
                                    </div> --}}
                                    @error('city')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Address</label>
                                    <input type="text" name="address" class="form-control" placeholder="Enter Address">
                                    @error('address')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Pincode</label>
                                    <input type="text" name="pincode" class="form-control" placeholder="Enter Pincode">
                                    @error('pincode')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                
                                <div class="form-group">
                                    <label for="">Category</label>
                                    <select class="form-control custom-select" name="category[]" id="category_id">
                                        <option></option>
                                    </select>
                                    @error('category')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">SubCategory</label>
                                    <select class="form-control custom-select" name="sub_category[]" id="sub_category_id">
                                        <option value="" >No SubCategory</option>
                                    </select>
                                    @error('sub_category')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>                             
                                <div class="form-group">
                                    <label for="">Follow up time</label>
                                    <input type="datetime-local" name="follow_up_time" class="form-control" placeholder="Enter Follow Up Time">
                                    @error('follow_up_time')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>                              
                                <div class="form-group">
                                    <label for="">Action</label>
                                    <select class="form-control custom-select" name="action" id="action">
                                        <option value="" >No Action</option>
                                        @foreach($actions as $action)
                                        <option value="{{ $action->title }}" >{{$action->title}}</option>
                                        @endforeach
                                    </select>
                                    @error('action')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Remarks</label>
                                    <input type="text" name="remarks" class="form-control" placeholder="Enter Remarks">
                                    @error('remarks')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">QR Code Value</label>
                                    <input type="text" name="qrcodevalue" class="form-control" placeholder="Enter QR Code Value">
                                    @error('qrcodevalue')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="priority">Priority</label>
                                    <select name="rating" id="priority" class="form-control">
                                        <option value="">Select Priority</option>
                                        <option value="High">High</option>
                                        <option value="Medium">Medium</option>
                                        <option value="Low">Low</option>
                                    </select>
                                    @error('rating')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                
                                <div class="form-group">
                                    <label for="">Monthly Requirement</label>
                                    <input type="text" name="monthly_requirement" class="form-control" placeholder="Enter Monthly Requirement">
                                    @error('monthly_requirement')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="">Products</label>
                                    <select class="form-control custom-select" name="products[]" id="product_id">
                                        <option></option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="">Front Image</label> :
                                    <input type="file" name="front_image" class="form-control @error('front_image') is-invalid @enderror" id="front_image" value="">
                                </div>
                                <div class="form-group">
                                    <label for="">Back Image</label> :
                                    <input type="file" name="back_image" class="form-control @error('back_image') is-invalid @enderror" id="back_image" value="">
                                </div>
                                <div class="card-footer">
                                <button type="submit" class="btn btn-primary" >Add</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function getPics() {}
    const imgs = document.querySelectorAll('.gallery img');
    const fullPage = document.querySelector('#fullpage');

    imgs.forEach(img => {
        img.addEventListener('click', function() {
            fullPage.style.backgroundImage = 'url(' + img.src + ')';
            fullPage.style.display = 'block';
        });
    });
    $(document).ready(function() {
        $('#visitorAddForm').validate()
        var addressCountryCode = "{{$countryCode}}";
        if(addressCountryCode === '' ){
            //console.log('null');
            $('.states-textbox').css('display','none');
            $('.cities-textbox').css('display','none');
            $('.states-dropdown').show();
            $('.cities-dropdown').show();
        }
        if(addressCountryCode === 'IN'){
            //console.log('IN');
            $('.states-textbox').css('display','none');
            $('.cities-textbox').css('display','none');
            $('.states-dropdown').show();
            $('.cities-dropdown').show();
            fetchStates(addressCountryCode);
        }else{
            //console.log('else');
            $('.states-dropdown').css('display','none');
            $('.cities-dropdown').css('display','none');
            $('.states-textbox').show();
            $('.cities-textbox').show();
            $('#state_textbox').val(" ");
            $('#city_textbox').val(" ");
        }
        setCategories();
        setProducts();
        $('#category_id').on("select2:select", function(e) {
            var categoryNames = [];
            $(e.currentTarget).find("option:selected").each(function(i, selected){
                categoryNames[i] = $(selected).text();
            });
            fetchSubCategories(categoryNames);
        });
        $('#category_id').on("select2:unselect", function(e) {
            var categoryNames = [];
            $(e.currentTarget).find("option:selected").each(function(i, selected){
                categoryNames[i] = $(selected).text();
            });
            if(categoryNames.length !== 0){
                fetchSubCategories(categoryNames);
            }else{
                var subCategoryId = $('#sub_category_id');
                $('#sub_category_id').html('');
                subCategoryId.val(null).trigger('change');
            }
        });
        $("#category_id").select2({
            placeholder: "Select a category",
            multiple: true,
        });
        $("#sub_category_id").select2({
            placeholder: "Select a sub category",
            multiple: true,
        });
        $("#product_id").select2({
            placeholder: "Select product",
            multiple: true,
        });
    });
    function setCategories()
    {
        var categoryNames = "{{implode(',',[])}}";
        var allCategories = '{!! ($categories)  !!}';
        var options = [];
        var categoryId = $('#category_id');
        categoryId.html('');
        categoryId.val(null).trigger('change');
        $.each(JSON.parse(allCategories), function(index, value) {
            var selected = false;
            if(jQuery.inArray(value.name, categoryNames.split(',')) !== -1){
                selected = true;
            }
            var option = new Option(value.name, value.name, false, selected);
            categoryId.append(option).trigger('change');
            options.push(value.name);
        });
        // manually trigger the `select2:select` event
        categoryId.val(null).trigger({
            type: 'select2:select',
            params: {
                data: options
            }
        });
    }

    function setProducts()
    {
        var visitorProductIds = "{{ implode(',',[]) }}";
        var allProducts = '{!! ($allProducts)  !!}';
        var options = [];
        var productId = $('#product_id');
        productId.html('');
        productId.val(null).trigger('change');
        $.each(JSON.parse(allProducts), function(index, value) {
            var selected = false;
            if(jQuery.inArray(value.id.toString(), visitorProductIds.split(',')) !== -1){
                selected = true;
            }
            var option = new Option(value.name, value.id, false, selected);
            productId.append(option).trigger('change');
            options.push({id:value.id,text:value.name});
        });
        // manually trigger the `select2:select` event
        productId.val(null).trigger({
            type: 'select2:select',
            params: {
                data: options
            }
        });
    }
    function fetchSubCategories(categoryNames) {
        var url = "{{ route('get_sub_categories') }}";
        var selectedSubCategoryNames = null;
        $.ajax({
            url: url,
            type: "GET",
            data: {
                categoryNames: categoryNames,
                selectedSubCategoryNames: selectedSubCategoryNames,
            },
            success: function(response) {
                var options = [];
                var rData = [];
                rData = response.data;
                selectedSubCategoryIds = response.selectedSubCategoryIds;
                var subCategoryId = $('#sub_category_id');
                $('#sub_category_id').html('');
                subCategoryId.val(null).trigger('change');
                $.each(rData, function(index, value) {
                    var selected = false;
                    if(jQuery.inArray(value.id, selectedSubCategoryIds) !== -1){
                        selected = true;
                    }
                    var option = new Option(value.name, value.name, false, selected);
                    subCategoryId.append(option).trigger('change');
                    options.push(value.name);
                });
                // manually trigger the `select2:select` event
                subCategoryId.trigger({
                    type: 'select2:select',
                    params: {
                        data: options
                    }
                });
            },
            error: function(error) {
                console.log(error);
            }
        });
    }

    $('#address_country_code').change(function() {
        var countryCode = $(this).val();
        if(countryCode !=='all' && countryCode === 'IN'){
            $('.states-textbox').css('display','none');
            $('.cities-textbox').css('display','none');
            $('.states-dropdown').show();
            $('.cities-dropdown').show();
            fetchStates(countryCode);
        }else{
            $('.states-dropdown').css('display','none');
            $('.cities-dropdown').css('display','none');
            $('.states-textbox').show();
            $('.cities-textbox').show();
        }
    });
    function fetchStates(countryCode) {
        var url = "{{ route('get_states') }}";
        $.ajax({
            url: url,
            type: "GET",
            data: {
                countryCode: countryCode,
            },
            success: function(response) {
                var options = [];
                var rData = [];
                rData = response.data;
                $.each(rData, function(index, value) {
                    var selectData = '';
                    selectData = '<option value="' + value.name + '" >' +value.name +
                        '</option>';
                    options.push(selectData);
                });
                $('#state_id').html('<option value="">No State</option>' +
                    options);
            },
            error: function(error) {
                console.log(error);
            }
        });
    }

    $('#state_id').change(function() {
        var stateId = $(this).val();
        fetchCities(stateId);
    });
    function fetchCities(stateName) {
        var url = "{{ route('get_cities') }}";
        $.ajax({
            url: url,
            type: "GET",
            data: {
                stateName: stateName,
            },
            success: function(response) {
                var options = [];
                var rData = [];
                rData = response.data;
                $.each(rData, function(index, value) {
                    var selectData = '';
                    selectData = '<option value="' + value.name + '">' +value.name +
                        '</option>';
                    options.push(selectData);
                });
                $('#city_id').html('<option value="">No City</option>' +
                    options);
            },
            error: function(error) {
                console.log(error);
            }
        });
    }
</script>
@endsection
