@extends('layouts.master')
@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">{{ empty($subcategory) ? 'Add Sub Category' : 'Edit Sub Category' }}</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('sub_category.list') }}">Sub Category List</a></li>
                        <li class="breadcrumb-item active">{{ empty($subcategory) ? 'Add Sub Category' : 'Edit Sub Category' }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="post" action="{{ route('sub_category.store') }}" name="form" enctype="multipart/form-data">
                                <input type="hidden" name="action" value="{{ empty($subcategory) ? 'insert' : 'update' }}">
                                <input type="hidden" name="id" value="{{ $subcategory->id ?? 0 }}">
                                @csrf
                                
                                <div class="form-group">
                                    <label for="inputStatus">Select Category</label>
                                    <select id="fk_category_id" class="form-control custom-select @if($errors->has('fk_category_id')) is-invalid @endif" name="fk_category_id" required>
                                        <option selected="" disabled="" value="">Select one</option>
                                        @foreach ($Category as $item)                
                                            <option value="{{$item->id}}" {{ isset($subcategory->fk_category_id) && $subcategory->fk_category_id == $item->id ? 'selected' : '' }}>{{$item->name}}</option>
                                        @endforeach
                                    </select>
                                    @if($errors->has('fk_category_id'))
                                        <span class="error invalid-feedback" style="display: inline;">{{ $errors->first('fk_category_id') }}</span>
                                    @endif
                                </div>
                                <div class="form-group">
                                    <label for="">Sub Category Name</label>
                                    <input type="text" name="name" class="form-control" id="" placeholder="Enter Sub Category Name"
                                        value="{{ empty($subcategory) ? old('name') : $subcategory->name }}" required>
                                    @if($errors->has('name'))
                                        <div class="form-text text-danger">{{ $errors->first('name') }}</div>
                                    @endif
                                </div>
                               
                                <div class="card-footer">
                                <button type="submit" class="btn btn-primary" >{{ empty($subcategory) ? 'Add' : 'Edit' }}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection