@extends('layouts.master')
@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Upload Image</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item active">Upload Image</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="post" action="{{ route('setting.store_image') }}" name="form" enctype="multipart/form-data">
                                @csrf

                                <div class="form-group ml-3">
                                    <label class="form-label">Select Image</label>
                                    <input class="form-control col-lg-10" type="file" name="images[]" id="images" multiple>
                                </div>
                                <div class="card-footer">
                                    <button type="submit" class="btn btn-primary" >Submit</button>
                                </div>
                            </form>
                        </div>
                        <div class="card-body">
                            <label class="form-label"><h3>Images</h3></label>
                            @foreach($imagesdata as $imagepath)
                                <div class="form-group ml-3">
                                    
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="row">
                                            <div class="col-6" style="width: 9%"> <img src="{{ asset(UPLOAD_IMAGE . $imagepath->image) }}" alt="" class="img" style="height: 120px; width: 120px"></div>
                                            <div class="col-6" style="width: 89%">
                                                <label class="form-label">Image Path</label>
                                                <input class="form-control col-lg-10" type="text" name="image" id="image" value="{{ asset('public/uploads/images/' . $imagepath->image)}}"></div>
                                                <i style="position: absolute; top: 2px; right: -102px; font-size: 21px; color: red; cursor: pointer;" 
                                                onclick="deletePopupfile(this)" class="fa fa-times" data-id="{{ $imagepath->id }}" value="{{ $imagepath->id }}" data-url="{{ route('delete_image', ['id' => $imagepath->id]) }}"></i>
                                            </div>
                                        
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function deletePopupfile(elm) {
        var imageId = $(elm).attr('data-id');
        var url = $(elm).data('url');
        swal({
            title: 'Are you sure!',
            icon: 'error',
            dangerMode: true,
            buttons: true,
            confirm: "Confirm",
        }).then(function(isConfirm) {
            if (isConfirm === true) {
                $.ajax({
                    type: 'GET',
                    url: url,
                    dataType: 'json',
                    success: function(data) {
                        window.location.reload();
                    },
                    error: function(data) {
                        console.log(data);
                    }
                });
            }
        });
    }
</script>
@endsection