@extends('layouts.master')
@section('content')
<style>
.class-link {
    color: #6cc417;
    text-decoration: none;
}

.class-link:hover {
    color: #ffbb00;
}
.select2-selection__choice {
    color: black !important;
}

</style>
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Add Sub-Admin </h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('setting.subAdminList') }}">Sub-Admin List</a></li>
                        <li class="breadcrumb-item active">Add SubAdmin</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="post" action="{{ route('setting.subAdminInsert') }}" name="form"
                                enctype="multipart/form-data">
                                @csrf
                                <input type='hidden' name="id" value="">
                                <div class="form-group">
                                    <label for="">Name</label>
                                    <input type="text" name="name" class="form-control" id="" placeholder="Name"
                                        value="" required>
                                </div>
                                <div class="form-group">
                                    <label for="">Email</label>
                                    <input type="email" name="email" class="form-control" id="" placeholder="Email"
                                           value="" required>
                                </div>
                                <div class="form-group">
                                    <label for="">Password</label>
                                    <input type="password" name="password" class="form-control" id="" placeholder="Password"
                                           value="" required>
                                </div>
                                <div class="form-group">
                                    <label for="">Division</label>
                                    <select class="form-control custom-select" name="divisions[]" id="division_id">
                                        <option></option>
                                    </select>
                                    @error('divisions')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="card-footer">
                                    <button type="submit" id="submit-button" class="btn btn-primary">Submit</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        setDivisions();
        $("#division_id").select2({
            placeholder: "Select Division",
            multiple: true,
        });
    });

    function setDivisions() {
    var divisionIds = "{{ implode(',', []) }}";
    var divisions = {!! json_encode($divisions) !!}; // Corrected JSON encoding
    var options = [];
    var divisionId = $('#division_id');
    divisionId.html('');
    divisionId.val(null).trigger('change');

    // Iterate through each country
    $.each(divisions, function(index, value) {
        // Escape single quotes in country name
        var escapedName = value.name.replace("'", "\\'");

        var selected = false;
        if (jQuery.inArray(value.id.toString(), divisionIds.split(',')) !== -1) {
            selected = true;
        }
        // Create an option element with the escaped country name
        var option = new Option(escapedName, value.id, false, selected);
        divisionId.append(option).trigger('change');
        options.push({ id: value.id, text: escapedName });
    });

    divisionId.val(null).trigger({
        type: 'select2:select',
        params: {
            data: options
        }
    });
}
</script>
@endsection
