@extends('layouts.master')
@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Config</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item active">Config</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="post" action="{{ route('setting.update_key') }}" name="form"
                                enctype="multipart/form-data">
                                @csrf
                                <input type="hidden" name="action" value="{{ empty($keyname) ? 'insert' : 'update' }}">
                                <input type="hidden" name="id" value="{{!empty($keyname->id) ? $keyname->id : ''}}">
                                <div class="form-group">
                                    <div class="col-4">
                                        <label for="">IndiaMartKey</label>
                                        <input type="text" name="indiamartkey"
                                            class="form-control @error('indiamartkey') is-invalid @enderror" id="indiamartkey"
                                            placeholder="Enter IndiaMart" value="{{!empty($keyname->indiamartkey) ?$keyname->indiamartkey : ''}}" required>

                                        @if ($errors->has('indiamartkey'))
                                        <div class="form-text text-danger">
                                            {{ $errors->first('indiamartkey') }}
                                        </div>
                                        @endif
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <button type="submit" class="btn btn-primary">{{ empty($keyname) ? 'Add' : 'Update' }}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                           <h3 class="card-title">Default SMTP Settings</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="post" action="{{ route('setting.update_emailconfig') }}" name="form"
                                enctype="multipart/form-data">
                                @csrf
                                <input type="hidden" name="action" value="{{ empty($user_emailconfig) ? 'insert' : 'update' }}">
                                <input type="hidden" name="id" value="{{!empty($user_emailconfig->id) ? $user_emailconfig->id : ''}}">
                                <div class="form-group">
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label for="">Host</label>
                                            <input type="text" name="host" class="form-control" id="" placeholder="Enter Host"
                                                value="{{isset($user_emailconfig->host) ? $user_emailconfig->host : ""}}" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="">User Name</label>
                                            <input type="text" name="username" class="form-control" id="" placeholder="Enter username"
                                                value="{{isset($user_emailconfig->username) ? $user_emailconfig->username : ""}}" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="">Password</label>
                                            <input type="password" name="password" class="form-control" id="" placeholder="Enter password"
                                                value="{{isset($user_emailconfig->password) ? $user_emailconfig->password : ""}}" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="">Smtp Port</label>
                                            <input type="text" name="smtp_port" class="form-control" id="" placeholder="Enter smtp_port"
                                                value="{{isset($user_emailconfig->smtp_port) ? $user_emailconfig->smtp_port : ""}}" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="">Smtp Transport</label>
                                            <input type="text" name="smtp_transport" class="form-control" id="" placeholder="Enter smtp_transport"
                                                value="{{isset($user_emailconfig->smtp_transport) ? $user_emailconfig->smtp_transport : ""}}" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="">Smtp Encryption</label>
                                            <input type="text" name="smtp_encryption" class="form-control" id="" placeholder="Enter smtp_encryption"
                                                value="{{isset($user_emailconfig->smtp_encryption) ? $user_emailconfig->smtp_encryption : ""}}" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <button type="submit" class="btn btn-primary">{{ empty($keyname) ? 'Add' : 'Update' }}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
