@extends('layouts.master')
@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Password</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item active">Password</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="post" action="{{ route('setting.update_password') }}" name="form"
                                enctype="multipart/form-data">
                                @csrf
                                <div class="form-group">
                                    <div class="col-4">
                                        <label for="">New Password</label>
                                        <input type="Password" name="password"
                                            class="form-control @error('password') is-invalid @enderror" id="password"
                                            placeholder="Enter NewPassword" value="" required
                                            autocomplete="current-password">

                                        @if ($errors->has('password'))
                                        <div class="form-text text-danger">
                                            {{ $errors->first('password') }}
                                        </div>
                                        @endif

                                        <label for="">Confirm Password</label>
                                        <input type="Password" name="password_confirmation" class="form-control"
                                            placeholder="Enter Conform Password"
                                            class="form-control @error('password_confirmation') is-invalid @enderror"
                                            value="" required autocomplete="current-password">
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <button type="submit" class="btn btn-primary">Update</button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="post" action="{{ route('setting.update_email') }}" name="form"
                                  enctype="multipart/form-data">
                                @csrf
                                <div class="form-group">
                                    <div class="col-4">
                                        <label for="">Email</label>
                                        <input type="email" name="email"
                                               class="form-control @error('email') is-invalid @enderror" id="email"
                                               placeholder="Enter Email" value="{{auth()->user()->email}}" required>

                                        @if ($errors->has('email'))
                                            <div class="form-text text-danger">
                                                {{ $errors->first('email') }}
                                            </div>
                                        @endif
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <button type="submit" class="btn btn-primary">Update</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
