@extends('layouts.master')
@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Select Team Member </h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('event.list') }}">Event List</a></li>
                        <li class="breadcrumb-item active">Select Team Member </li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Select Members </h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div id="example2_wrapper" class="dataTables_wrapper dt-bootstrap4">
                                <div class="row">
                                    <div class="col-sm-12 col-md-6"></div>
                                    <div class="col-sm-12 col-md-6"></div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <table id="example2"
                                            class="table table-bordered table-hover dataTable dtr-inline"
                                            aria-describedby="example2_info">
                                            <thead>
                                                <tr>
                                                    <th>
                                                        Customer_id</th>
                                                    <th>
                                                        Name
                                                    </th>
                                                    <th>
                                                        Action
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($data as $val)
                                                <tr>
                                                    <td class="dtr-control sorting_1" tabindex="0">
                                                        {{$val->CustomerID}}
                                                    </td>
                                                    <td class="dtr-control sorting_1" tabindex="0">
                                                        {{$val->CustomerName}}
                                                    </td>
                                                    <td>
                                                        <input type="checkbox" class="btn bg-gradient-success btn-sm"
                                                            id="{{$val->id}}" onclick="storeadminassign(this)"
                                                            value="{{$val->is_admin}}" @if($val->is_admin == "true")
                                                        checked @endif>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="isadmin-modal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="modal-title"></h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="post" action="{{ route('event.storeadminassign') }}">@csrf
                <div class="modal-body">
                    <input type="hidden" name="id" id="id">
                    <input type="hidden" name="isadminvalue" id="isadminvalue">
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">OK</button>
                </div>
            </form>
        </div>
    </div>
</div>
<script>
function storeadminassign(elm) {
    var id = $(elm).attr('id');
    var isadminvalue = elm.value;
    if (isadminvalue != "true") {
        $("#modal-title").html("Are you sure? you want to make it admin?");
    } else {
        $("#modal-title").html("Are you sure? you want to remove admin?");
    }

    $("#id").val(id);
    $("#isadminvalue").val(isadminvalue);
    $("#isadmin-modal").modal('show');
}
</script>
@endsection