@extends('layouts.master')
@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Edit Event</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('event.list') }}">Event List</a></li>
                        <li class="breadcrumb-item active">Edit Event</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="post" action="{{ route('event.editeventstore') }}" name="form" enctype="multipart/form-data">
                                @csrf
                                <input type='hidden' name="id" value="{{isset($get_data->id) ? $get_data->id : ''}}">
                                <div class="form-group">
                                    <label for="">Event Name</label>
                                    <input type="text" name="eventname" class="form-control" id="" placeholder="Enter Event Name"
                                        value="{{$get_data->event_name}}" >
                                </div>
                                <div class="form-group">
                                    <label for="">City</label>
                                    <input type="text" name="city" class="form-control" id="" placeholder="Enter City Name"
                                        value="{{$get_data->city}}">
                                </div>
                                <div class="form-group">
                                    <label for="">Details</label>
                                    <input type="text" name="details" class="form-control" id="" placeholder="Enter details "
                                        value="{{$get_data->details}}" >
                                </div>
                                <div class="form-group">
                                    <label for="" >Start Date</label>
                                    <input type="text" name="start_date" class="form-control" id="" placeholder="Enter Start Date "
                                        value="{{isset($get_data->start_date) ? $get_data->start_date : $now}}" >
                                </div>
                                <div class="form-group">
                                    <label for="">End Date</label>
                                    <input type="text" name="end_date" class="form-control" id="" placeholder="Enter End Date "
                                        value="{{isset($get_data->end_date) ? $get_data->end_date : $now}}" >
                                </div>
                                <div class="form-group">
                                    <label for="">Show all Clients</label>&nbsp;&nbsp;&nbsp;
                                    <input type="radio" name="type_show_all" id=""  value="true" {{ $get_data->type_show_all == 'true' ? 'checked' : '' }}>
                                    <label for="">Yes</label>
                                    <input type="radio" name="type_show_all" id="" value="false" {{ $get_data->type_show_all == 'false' ? 'checked' : '' }}> <label for="">No</label>
                                </div>
                                <div class="card-footer">
                                <button type="submit" class="btn btn-primary" >Submit</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection