@extends('layouts.master')
@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Edit Email Draft</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('emails.index') }}">Email Draft</a></li>
                        <li class="breadcrumb-item active">Edit Email Draft</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="post" action="{{ route('emails.update', $emails->id) }}" name="form" enctype="multipart/form-data">
                                @csrf
                                @method('PUT')

                                <div class="form-group ml-3">
                                    <label class="form-label">Select Email Type</label>
                                    <select class="form-control col-lg-10" name="email_type" id="email_type" required>
                                        <option value="" selected disabled>Select Email Type</option>
                                        <option value="primary" {{ old('email_type', $emails->email_type) == 'primary' ? 'selected' : '' }}>Primary</option>
                                        <option value="follow_up" {{ old('email_type', $emails->email_type) == 'follow_up' ? 'selected' : '' }}>Follow Up</option>
                                        <option value="other" {{ old('email_type', $emails->email_type) == 'other' ? 'selected' : '' }}>Other</option>
                                    </select>
                                </div>
                                <div class="form-group ml-3">
                                    <label class="form-label">Subject</label>
                                    <input type="text" name="subject" class="form-control col-lg-10" id="subject" value="{{ old('subject', $emails->subject) }}" placeholder="Enter Subject" required>
                                </div>
                                <div class="form-group ml-3">
                                    <label class="form-label">Content</label>
                                    <textarea class="editor" name="content" id="content" cols="30" rows="10">{{ old('content', $emails->content) }}</textarea>
                                </div>
                                    {{-- <div class="form-group ml-3">
                                        <label class="form-label">Attachment</label>
                                        @foreach($get_image as $images)
                                            <img src="{{ asset(UPLOAD_EMAIL.$images->attachment) }}" alt="" class="img" style="height: 85px; width: 85px">
                                            <span> 
                                                <i class="fa">&#xf00d;</i>
                                            </span>
                                        @endforeach
                                    </div> --}}
                                    <div class="form-group ml-3">
                                        <label class="form-label">Attachment</label>
                                            @foreach($get_image as $image)
                                                <div class="image-container" style="position: relative; display: inline-block; margin-right: 10px;">
                                                    <!-- <img src="{{ asset(UPLOAD_EMAIL . $image->attachment) }}" alt="" class="img" style="height: 85px; width: 85px"> -->
                                                    @if (pathinfo($image->attachment, PATHINFO_EXTENSION) === 'pdf')
                                                        <img src="{{ asset('pdficon.png') }}" alt="PDF Icon" class="img" style="height: 94px; width: 85px">
                                                    @else
                                                        <img src="{{ asset(UPLOAD_EMAIL . $image->attachment) }}" alt="" class="img" style="height: 85px; width: 85px">
                                                    @endif
                                                    <i style="position: absolute; top: 5px; right: 5px; font-size: 15px; color: white; cursor: pointer;" 
                                                        onclick="deletePopupfile(this)" class="fa fa-times" data-id="{{ $image->id }}" value="{{ $image->id }}" data-url="{{ route('delete', ['id' => $image->id]) }}"></i>
                                                </div>
                                            @endforeach
                                    </div>
                                    <div class="form-group ml-3">
                                        <label class="form-label">Attachment Name : </label>
                                        @foreach($get_image as $image)
                                            <?php 
                                                $imageName = basename($image->attachment);     
                                            ?>
                                            {{$imageName}}@if(isset($image->attachment)) ,@endif 
                                        @endforeach
                                    </div>
                                    <div class="form-group ml-3">
                                        <input class="form-control col-lg-10" type="file" name="attachment[]" id="attachment" multiple>
                                    </div>
                                <div class="card-footer">
                                    <button type="submit" class="btn btn-primary" >Submit</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function () {
        CKEDITOR.replace( 'content' );
    });
</script>
<script>
    function deletePopupfile(elm) {
        var imageId = $(elm).attr('data-id');
        var url = $(elm).data('url');
        swal({
            title: 'Are you sure!',
            icon: 'error',
            dangerMode: true,
            buttons: true,
            confirm: "Confirm",
        }).then(function(isConfirm) {
            if (isConfirm === true) {
                $.ajax({
                    type: 'GET',
                    url: url,
                    dataType: 'json',
                    success: function(data) {
                        window.location.reload();
                    },
                    error: function(data) {
                        console.log(data);
                    }
                });
            }
        });
    }
   
</script>
@endsection
