@extends('layouts.master')
@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Add Email Draft</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('emails.index') }}">Email Draft</a></li>
                        <li class="breadcrumb-item active">Add Email Draft</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="post" action="{{ route('emails.store') }}" name="form" enctype="multipart/form-data">
                                @csrf

                                <div class="form-group ml-3">
                                    <label class="form-label">Select Email Type</label>
                                    <select class="form-control col-lg-10" name="email_type" id="email_type" required>
                                        <option value="" selected disabled>Select Email Type</option>
                                        <option value="primary" {{ old('email_type') == 'primary' ? 'selected' : '' }}>Primary</option>
                                        <option value="follow_up" {{ old('email_type') == 'follow_up' ? 'selected' : '' }}>Follow Up</option>
                                        <option value="other" {{ old('email_type') == 'other' ? 'selected' : '' }}>Other</option>
                                    </select>
                                </div>
                                <div class="form-group ml-3">
                                    <label class="form-label">Subject</label>
                                    <input type="text" name="subject" class="form-control col-lg-10" id="subject" value="{{ old('subject') }}" placeholder="Enter Subject" required>
                                </div>
                                <div class="form-group ml-3">
                                    <label class="form-label">Content</label>
                                    <textarea class="editor" name="content" id="content">{{ old('content') }}</textarea>
                                </div>
                                <div class="form-group ml-3">
                                    <label class="form-label">Attachment</label>
                                    <input class="form-control col-lg-10" type="file" name="attachment[]" id="attachment" multiple>
                                </div>
                                <div class="card-footer">
                                    <button type="submit" class="btn btn-primary" >Submit</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>

$(document).ready(function () {
    CKEDITOR.replace( 'content' );
});

    // ClassicEditor
    // .create( document.querySelector( '#content' ), {
    //     toolbar: [ 'bold', 'italic' ]
    // } )
    // .then( editor => {
    //     console.log( 'Editor was initialized', editor );
    // } )
    // .catch( error => {
    //     console.error( error.stack );
    // } );
</script>
@endsection
