@extends('layouts.master')
@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">{{ empty($category) ? 'Add Category' : 'Edit Category' }}</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('category.list') }}">Category List</a></li>
                        <li class="breadcrumb-item active">{{ empty($category) ? 'Add Category' : 'Edit Category' }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="post" action="{{ route('category.store') }}" name="form" enctype="multipart/form-data">
                                <input type="hidden" name="action" value="{{ empty($category) ? 'insert' : 'update' }}">
                                <input type="hidden" name="id" value="{{ $category->id ?? 0 }}">
                                @csrf
                                <div class="form-group">
                                    <label for="">Category Name</label>
                                    <input type="text" name="name" class="form-control" id="" placeholder="Enter Category Name"
                                        value="{{ empty($category) ? old('name') : $category->name }}" required>
                                    @if($errors->has('name'))
                                        <div class="form-text text-danger">{{ $errors->first('name') }}</div>
                                    @endif
                                </div>
                               
                                <div class="card-footer">
                                <button type="submit" class="btn btn-primary" >{{ empty($category) ? 'Add' : 'Edit' }}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection