@extends('layouts.master')
@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">{{ empty($Action) ? 'Add Action' : 'Edit Action' }}</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('action.list') }}">Action List</a></li>
                        <li class="breadcrumb-item active">{{ empty($Action) ? 'Add Action' : 'Edit Action' }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Default box -->
                    <div class="card">
                        <div class="card-header">
                            <!-- <h3 class="card-title">Select Members For </h3> -->
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <form method="post" action="{{ route('action.store') }}" name="form" enctype="multipart/form-data">
                                <input type="hidden" name="action" value="{{ empty($Action) ? 'insert' : 'update' }}">
                                <input type="hidden" name="id" value="{{ $Action->id ?? 0 }}">
                                @csrf
                                <div class="form-group">
                                    <label for="">Title Name</label>
                                    <input type="text" name="title" class="form-control" id="" placeholder="Enter Title Name"
                                        value="{{ empty($Action) ? old('title') : $Action->title }}" required>
                                    @if($errors->has('title'))
                                        <div class="form-text text-danger">{{ $errors->first('title') }}</div>
                                    @endif
                                </div>
                                <div class="form-group">
                                    <label for="">Description</label>
                                    {{-- <input type="text" name="description" class="form-control" id="" placeholder="Enter Description"
                                        value="{{ empty($Action) ? old('description') : $Action->description }}" required> --}}
                                        <textarea name="description" id="" class="form-control" placeholder="Enter Description" cols="30" rows="10" required>{{ empty($Action) ? old('description') : $Action->description }}</textarea>
                                    @if($errors->has('description'))
                                        <div class="form-text text-danger">{{ $errors->first('description') }}</div>
                                    @endif
                                </div>
                                <div class="card-footer">
                                <button type="submit" class="btn btn-primary" >{{ empty($Action) ? 'Add' : 'Edit' }}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection