<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserEmailConfigTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_email_config', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('fk_user_id')->unsigned();
            $table->string('host', 255)->nullable();
            $table->string('username', 255)->nullable();
            $table->string('password', 255)->nullable();
            $table->timestamps();
            $table->string('port', 255)->nullable();
            $table->string('smtp_transport', 255)->nullable();
            $table->string('smtp_encryption', 255)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_email_config');
    }
}
