<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVisitorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('visitors', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('indiamart_query_id')->unsigned()->nullable();
            $table->string('name', 255);
            $table->bigInteger('event_id')->unsigned();
            $table->integer('customer_id');
            $table->string('company_name', 255)->nullable();
            $table->string('website', 255)->nullable();
            $table->string('mobile_no', 255)->nullable();
            $table->string('mobile_no2', 255)->nullable();
            $table->string('mobile_no3', 255)->nullable();
            $table->string('email', 255)->nullable();
            $table->string('email2', 255)->nullable();
            $table->string('state', 255)->nullable();
            $table->string('city', 255)->nullable();
            $table->string('pincode', 91)->nullable();
            $table->string('address', 255)->nullable();
            $table->string('designation', 255)->nullable();
            $table->string('category', 255)->nullable();
            $table->timestamp('follow_up_time')->nullable();
            $table->string('action', 255)->nullable();
            $table->string('remarks', 255)->nullable();
            $table->text('qrcodevalue')->nullable();
            $table->string('attended_by', 255)->nullable();
            $table->string('rating', 255)->nullable();
            $table->string('audio_file', 255)->nullable();
            $table->string('front_image', 255)->nullable();
            $table->string('back_image', 255)->nullable();
            $table->timestamp('visited_date')->nullable();
            $table->string('type', 255)->nullable();
            $table->timestamps();
            $table->string('lat', 255)->nullable();
            $table->string('lng', 255)->nullable();
            $table->string('event_ids', 255)->nullable();
            $table->enum('is_international', ['true', 'false'])->default('false');
            $table->string('monthly_requirement', 255)->nullable();
            $table->string('sub_category', 255)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('visitors');
    }
}
