<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->string('imei', 100);
            $table->bigIncrements('user_id');
            $table->integer('CustomerID');
            $table->enum('status', ['true', 'false'])->default('false');
            $table->datetime('datetime')->default(now());
            $table->datetime('expiry_date')->default(now());
            $table->enum('google_drive', ['true', 'false'])->default('false');
            $table->enum('email_service', ['true', 'false'])->default('false');
            $table->string('Notes', 1000)->default('na');
            $table->string('CustomerName', 100)->default('na');
            $table->string('Phone', 100)->default('na');
            $table->string('Email', 100)->default('na');
            $table->string('CompanyName', 100)->default('na');
            $table->string('sender_name', 191)->nullable();
            $table->string('sender_email', 191)->nullable();
            $table->string('cc_email', 255)->nullable();
            $table->bigInteger('follow_up_email')->unsigned()->nullable();
            $table->bigInteger('primary_email')->unsigned()->nullable();
            $table->string('Location', 100)->default('na');
            $table->string('device_type', 500)->default('na');
            $table->string('app_version', 100)->default('1');
            $table->string('version_code', 100)->default('0');
            $table->string('android_version', 100)->default('0');
            $table->string('device_model', 100)->default('0');
            $table->string('push_token', 500)->default('na');
            $table->string('code', 20)->default('');
            $table->enum('is_admin', ['true', 'false'])->default('false');
            $table->enum('is_delete', ['true', 'false'])->default('false');
            $table->string('replaced_with', 255)->nullable();
            $table->string('location_config', 100)->default('0');
            $table->string('bcc_email', 255)->nullable();
            $table->string('password', 255)->nullable();
          //  $table->primary([ 'user_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
