<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class Visitor extends Model
{
    use HasFactory;
    protected $table = "visitors";
    public $timestamps = false;
    protected $guarded = ['id'];

    public static function fetchAllvisitor($eventid,$CustomerID,$categoryId=null,$subCategoryId=null,$stateId=null,$cityId=null,$isInternational=null,$countryId=null,$region=null,$startDate=null,$endDate=null)
    {
        DB::enableQueryLog();
        $query = Visitor::select('events.event_name', 'users.CustomerName', 'visitors.*')
        ->join('events', 'events.id', 'visitors.event_id')
        ->leftjoin('users', 'users.CustomerID', 'visitors.customer_id')
        ->orderBy('visitors.id', 'desc');

        // $event_check = DB::table('events')->where
        if ($eventid != "all") {
            $query = $query->where(function ($query) use ($eventid) {
                $query->where('event_id', $eventid)
                    ->orWhereRaw('FIND_IN_SET(?, event_ids)', [$eventid]);
            });
        }

        if ($CustomerID != "all") {
            $query = $query->where('CustomerID', $CustomerID);
        }else{
            $authAdmin = auth()->user();
            if($authAdmin->type == 'sub-admin'){
                $divisionIds = AssignDivisionAdmin::where('admin_id',$authAdmin->id)->pluck('division_id')->toArray();
                $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id',$divisionIds)->pluck('customer_id')->toArray();
                $query = $query->whereIn('CustomerID',$divisionTeamMemberIds);
            }
        }

        if ($categoryId != "all" && $categoryId != null) {
            $categoryName = DB::table('category')->where('id',$categoryId)->select('name', 'id')->first()->name;
            $query = $query->where(function ($query) use ($categoryName) {
                $query->whereRaw('FIND_IN_SET(?, visitors.category)', [$categoryName]);
            });
        }

        if ($subCategoryId != "all" && $subCategoryId != null) {
            $subCategoryName = DB::table('sub_categories')->where('id',$subCategoryId)->select('name', 'id')->first()->name;
            $query = $query->where(function ($query) use ($subCategoryName) {
                $query->whereRaw('FIND_IN_SET(?, visitors.sub_category)', [$subCategoryName]);
            });
        }

        if ($stateId != "all" && $stateId != null) {
            $stateName = DB::table('states')->where('id',$stateId)->select('name', 'id')->first()->name;
            $query = $query->where('visitors.state', '=',$stateName);
        }

        if ($cityId != "all" && $cityId != null) {
            $cityName = DB::table('cities')->where('id',$cityId)->select('name', 'id')->first()->name;
            $query = $query->where('visitors.city', '=',$cityName);
        }

        if ($isInternational != "all" && $isInternational != null) {
            $query = $query->where('visitors.is_international', $isInternational);
        }

        if ($countryId != "all" && $countryId != null) {

            $countryISOCode = DB::table('countries')->where('id',$countryId)->select('iso_code','name', 'id')->first()->iso_code;
            $query = $query->where('visitors.country_code', '=',$countryISOCode);

        }

        if ($region != "all" && $region != null) {
            $regionCountries = DB::table('region_country')->where('fk_region_id',$region)->get();
            if($regionCountries){
                $regionCountryIds = $regionCountries->pluck('fk_country_id')->toArray();
                $countries = DB::table('countries')
                    ->whereIn('id',$regionCountryIds)->select('iso_code','name', 'id')->get();
                if($countries){
                    $countryISOCodes = $countries->pluck('iso_code')->toArray();
                    $query = $query->whereIn('visitors.country_code', $countryISOCodes);
                }
            }
        }

        if ($startDate != null && $endDate != null) {
            $startDateFormatted = date('Y-m-d', strtotime($startDate));
            $endDateFormatted = date('Y-m-d', strtotime($endDate));
            $query = $query->where(function ($query) use ($startDateFormatted, $endDateFormatted){
                $query->where('visitors.visited_date', '>=', $startDateFormatted)
                    ->where('visitors.visited_date', '<=', $endDateFormatted);
            });
        }

        //dd(DB::getQuerylog($query->get()));
        return $query->groupBy('visitors.id');

    }
    public static function countVisitors()
    {
        $authAdmin = auth()->user();
        $result = Visitor::select('users.CustomerName', 'visitors.*')
            ->leftjoin('users', 'users.CustomerID', 'visitors.customer_id');
        if($authAdmin->type == 'sub-admin'){
            $divisionIds = AssignDivisionAdmin::where('admin_id',$authAdmin->id)->pluck('division_id')->toArray();
            $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id',$divisionIds)->pluck('customer_id')->toArray();
            $result = $result->whereIn('CustomerID',$divisionTeamMemberIds);
        }
        return $result->count();
    }

    public static function getvisitorByFilterExport($event_id,$customer_id,$categoryId=null,$subCategoryId=null,$stateId=null,$cityId=null,$isInternational=null,$countryId=null,$region=null,$startDate=null,$endDate=null)
    {
        //DB::enableQueryLog();
        // $query= DB:: table('visitors')
        // ->select('visitor_products.product_id','visitors.*', DB::raw("GROUP_CONCAT(products.name) as product_name"))
        // ->leftjoin('visitor_products', 'visitor_products.visitor_id', 'visitors.id')
        // ->leftjoin('products', 'products.id', 'visitor_products.product_id')
        // ->groupBy('visitor_products.visitor_id');


        // $query = Visitor::select('products.name as product_name','visitor_products.product_id','visitors.*')
        // ->join('events', 'events.id', 'visitors.event_id')
        // ->leftjoin('users', 'users.CustomerID', 'visitors.customer_id')
        // ->leftjoin('visitor_products', 'visitor_products.visitor_id', 'visitors.id')
        // ->leftjoin('products', 'products.id', 'visitor_products.product_id')
        // ->orderBy('visitors.id', 'desc');
        $query = Visitor::select(
            'visitors.id',
            'visitors.visited_date',
            'visitors.company_name',
            'visitors.state',
            'visitors.city',
            'visitors.address',
            'visitors.website',
            'visitors.name',
            'visitors.designation',
            'visitors.mobile_no',
            'visitors.mobile_no2',
            'visitors.mobile_no3',
            'visitors.email',
            'visitors.email2',
            'visitors.category',
            'visitors.sub_category',
            'visitors.remarks',
            'visitors.action',
            'visitors.attended_by',
            'visitors.monthly_requirement',
            'visitors.rating',
            'countries.name as country_name',
            'region.name as region_name',
            'events.event_name as event_name',
            'users.CustomerName as teamName',
            DB::raw('GROUP_CONCAT(products.name) as product_names')
        )
        ->join('events', 'events.id', 'visitors.event_id')
        ->leftjoin('users', 'users.CustomerID', 'visitors.customer_id')
        ->leftjoin('visitor_products', 'visitor_products.visitor_id', 'visitors.id')
        ->leftjoin('products', 'products.id', 'visitor_products.product_id')
        ->leftjoin('countries', 'countries.iso_code', 'visitors.country_code')
        ->leftjoin('region_country', 'region_country.fk_country_id', 'countries.id')
        ->leftjoin('region', 'region.id', 'region_country.fk_region_id')
        ->orderBy('visitors.id', 'desc');

        if ($event_id != "all") {
            $query = $query->where(function ($query) use ($event_id) {
                $query->where('event_id', $event_id)
                    ->orWhereRaw('FIND_IN_SET(?, visitors.event_ids)', [$event_id]);
            });
        }
        if($customer_id !="all"){
            $query = $query->where('CustomerID', $customer_id);
        }else{
            $authAdmin = auth()->user();
            if($authAdmin->type == 'sub-admin'){
                $divisionIds = AssignDivisionAdmin::where('admin_id',$authAdmin->id)->pluck('division_id')->toArray();
                $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id',$divisionIds)->pluck('customer_id')->toArray();
                $query = $query->whereIn('CustomerID',$divisionTeamMemberIds);
            }
        }
        if ($categoryId != "all" && $categoryId != null) {
            $categoryName = DB::table('category')->where('id',$categoryId)->select('name', 'id')->first()->name;
            $query = $query->whereRaw('FIND_IN_SET(? , visitors.category)',[$categoryName]);
        }

        if ($subCategoryId != "all" && $subCategoryId != null) {
            $subCategoryName = DB::table('sub_categories')->where('id',$subCategoryId)->select('name', 'id')->first()->name;
            $query = $query->where(function ($query) use ($subCategoryName) {
                $query->whereRaw('FIND_IN_SET(?, visitors.sub_category)', [$subCategoryName]);
            });
        }

        if ($stateId != "all" && $stateId != null) {
            $stateName = DB::table('states')->where('id',$stateId)->select('name', 'id')->first()->name;
            $query = $query->where('visitors.state', $stateName);
        }

        if ($cityId != "all" && $cityId != null) {
            $cityName = DB::table('cities')->where('id',$cityId)->select('name', 'id')->first()->name;
            $query = $query->where('visitors.city', $cityName);
        }

        if ($isInternational != "all" && $isInternational != null) {
            $query = $query->where('visitors.is_international', $isInternational);
        }

        if ($countryId != "all" && $countryId != null) {

            $countryISOCode = DB::table('countries')->where('id',$countryId)->select('iso_code','name', 'id')->first()->iso_code;
            $query = $query->where('visitors.country_code', '=',$countryISOCode);

        }

        if ($region != "all" && $region != null) {
            $regionCountries = DB::table('region_country')->where('fk_region_id',$region)->get();
            if($regionCountries){
                $regionCountryIds = $regionCountries->pluck('fk_country_id')->toArray();
                $countries = DB::table('countries')
                    ->whereIn('id',$regionCountryIds)->select('iso_code','name', 'id')->get();
                if($countries){
                    $countryISOCodes = $countries->pluck('iso_code')->toArray();
                    $query = $query->whereIn('visitors.country_code', $countryISOCodes);
                }
            }
        }

        if ($startDate != null && $endDate != null) {
            $startDateFormatted = date('Y-m-d', strtotime($startDate));
            $endDateFormatted = date('Y-m-d', strtotime($endDate));
            $query = $query->where(function ($query) use ($startDateFormatted, $endDateFormatted){
                $query->where('visitors.visited_date', '>=', $startDateFormatted)
                    ->where('visitors.visited_date', '<=', $endDateFormatted);
            });
        }
        //dd(DB::getQuerylog($query->get()));
        return $query->groupBy('visitors.id')->get();

    }

    public static function getCountryName($country_code)
    {

        $country = DB::table('countries')->where('iso_code',$country_code)->select('name', 'id')->first();
        $name = '-';
        if($country){
            $name = $country->name;
        }
        return $name;
    }

    public static function fetchEmailVisitors($eventid,$CustomerID,$categoryId=null,$subCategoryId=null,$stateId=null,$cityId=null,$isInternational=null,$countryId=null,$region=null,$startDate=null,$endDate=null)
    {
        DB::enableQueryLog();
        $query = Visitor::select('events.event_name', 'users.CustomerName', 'visitors.*')
            ->join('events', 'events.id', 'visitors.event_id')
            ->leftjoin('users', 'users.CustomerID', 'visitors.customer_id')
            ->orderBy('visitors.id', 'desc')
            ->where('visitors.email','!=',' ')
            ->orWhere('visitors.email','!=',null);

        // $event_check = DB::table('events')->where
        if ($eventid != "all") {
            $query = $query->where(function ($query) use ($eventid) {
                $query->where('event_id', $eventid)
                    ->orWhereRaw('FIND_IN_SET(?, event_ids)', [$eventid]);
            });
        }

        if ($CustomerID != "all") {
            $query = $query->where('CustomerID', $CustomerID);
        }else{
            $authAdmin = auth()->user();
            if($authAdmin->type == 'sub-admin'){
                $divisionIds = AssignDivisionAdmin::where('admin_id',$authAdmin->id)->pluck('division_id')->toArray();
                $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id',$divisionIds)->pluck('customer_id')->toArray();
                $query = $query->whereIn('CustomerID',$divisionTeamMemberIds);
            }
        }

        if ($categoryId != "all" && $categoryId != null) {
            $categoryName = DB::table('category')->where('id',$categoryId)->select('name', 'id')->first()->name;
            $query = $query->where(function ($query) use ($categoryName) {
                $query->whereRaw('FIND_IN_SET(?, visitors.category)', [$categoryName]);
            });
        }

        if ($subCategoryId != "all" && $subCategoryId != null) {
            $subCategoryName = DB::table('sub_categories')->where('id',$subCategoryId)->select('name', 'id')->first()->name;
            $query = $query->where(function ($query) use ($subCategoryName) {
                $query->whereRaw('FIND_IN_SET(?, visitors.sub_category)', [$subCategoryName]);
            });
        }

        if ($stateId != "all" && $stateId != null) {
            $stateName = DB::table('states')->where('id',$stateId)->select('name', 'id')->first()->name;
            $query = $query->where('visitors.state', '=',$stateName);
        }

        if ($cityId != "all" && $cityId != null) {
            $cityName = DB::table('cities')->where('id',$cityId)->select('name', 'id')->first()->name;
            $query = $query->where('visitors.city', '=',$cityName);
        }

        if ($isInternational != "all" && $isInternational != null) {
            $query = $query->where('visitors.is_international', $isInternational);
        }

        if ($countryId != "all" && $countryId != null) {
            $countryISOCode = DB::table('countries')->where('id',$countryId)->select('iso_code','name', 'id')->first()->iso_code;
            $query = $query->where('visitors.country_code', '=',$countryISOCode);
        }

        if ($region != "all" && $region != null) {
            $regionCountries = DB::table('region_country')->where('fk_region_id',$region)->get();
            if($regionCountries){
                $regionCountryIds = $regionCountries->pluck('fk_country_id')->toArray();
                $countries = DB::table('countries')
                    ->whereIn('id',$regionCountryIds)->select('iso_code','name', 'id')->get();
                if($countries){
                    $countryISOCodes = $countries->pluck('iso_code')->toArray();
                    $query = $query->whereIn('visitors.country_code', $countryISOCodes);
                }
            }
        }

        if ($startDate != null && $endDate != null) {
            $startDateFormatted = date('Y-m-d', strtotime($startDate));
            $endDateFormatted = date('Y-m-d', strtotime($endDate));
            $query = $query->where(function ($query) use ($startDateFormatted, $endDateFormatted){
                $query->where('visitors.visited_date', '>=', $startDateFormatted)
                    ->where('visitors.visited_date', '<=', $endDateFormatted);
            });
        }
        //dd(DB::getQuerylog($query->get()));
        return $query->groupBy('visitors.id');

    }
}
