<?php

namespace App\Models;

use App\Models\VisitDataProduct;
use Illuminate\Database\Eloquent\Model;

class VisitData extends Model
{
    protected $table = 'visit_data';

    protected $fillable = [
        'fk_teammember_id',
        'fk_visitor_id',
        'action',
        'remarks',
        'follow_up_time',
        'audio_file',
        'location', 
        'lat',
        'lng',
        'visit_time',
        'attend_by',
        'created_at',
        'updated_at'
    ];
    
    public $timestamps = false;

    // protected $dates = ['created_at', 'updated_at'];
    public function products()
{
    return $this->hasMany(VisitDataProduct::class, 'fk_visit_data_id');
}

public function images()
{
    return $this->hasMany(Visit_data_images::class, 'fk_visit_id');
}
}
