<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use App\Models\EmailDraft;


class User extends Model
{
    use HasFactory, Notifiable;
    protected $table = "users";
    public $timestamps = false;


    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function fetchAllUsers()
    {
        $result = User::where('is_delete','!=','true')->orderBy('CustomerID', 'desc');
        $authAdmin = auth()->user();
        if($authAdmin->type == 'sub-admin'){
            $divisionIds = AssignDivisionAdmin::where('admin_id',$authAdmin->id)->pluck('division_id')->toArray();
            $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id',$divisionIds)->pluck('customer_id')->toArray();
            $result = $result->whereIn('CustomerID',$divisionTeamMemberIds);
        }
        return $result;
    }
    public static function countUsers()
    {
        $result = User::where('is_delete','!=','true');
        $authAdmin = auth()->user();
        if($authAdmin->type == 'sub-admin'){
            $divisionIds = AssignDivisionAdmin::where('admin_id',$authAdmin->id)->pluck('division_id')->toArray();
            $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id',$divisionIds)->pluck('customer_id')->toArray();
            $result = $result->whereIn('CustomerID',$divisionTeamMemberIds);
        }
        return $result->count();
    }

    public function primaryEmail()
    {
        return $this->hasOne(EmailDraft::class, 'primary_email');
    }

    public function followUpEmail()
    {
        return $this->hasOne(EmailDraft::class, 'follow_up_email');
    }
    public static function insert_user_with_martkey($indiamartkey)
    {
        $data =[
            'CustomerID' => "1111111",
            'status' => "true",
            'datetime' => date('Y-m-d H:i:s'),
            'expiry_date' => date('Y-m-d H:i:s'),
            'google_drive' => "false",
            'email_service' => "false",
            'Notes' => "na",
            'CustomerName' => "IndiaMart",
            'Phone' => "na",
            'Email' => "na",
            'CompanyName' => "na",
            'sender_name' => NULL,
            'sender_email' => NULL,
            'cc_email' => NULL,
            'follow_up_email' => NULL,
            'primary_email' => NULL,
            'Location' => "na",
            'device_type' => "na",
            'app_version' => "1",
            'version_code' => "0",
            'android_version' => "0",
            'device_model' => "0",
            'push_token' => "na",
            'code' => "IndiaMart",
            'is_admin' => "false",
            'is_delete' => "false",
        ];
        return $query = User::insert($data);
    }
}
