<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;

class Product extends Model
{
    use HasFactory, Notifiable;
    protected $table = "products";
    public $timestamps = false;

    public function fetchAllProduct()
    {
        return Product::select('users.user_id','product_images.image','products.*')
        ->leftjoin('users', 'users.user_id', 'products.fk_user_id')
        ->leftjoin('product_images', 'product_images.fk_product_id', 'products.id')
        ->groupBy('products.id')
        ->orderBy('products.id', 'desc');
    }
    public static function countProducts()
    {
        return Product::count();
    }

}
