<?php

namespace App\Imports;

use App\Models\Visitor;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Carbon\Carbon;

class Importvisitorlist implements  ToCollection,WithStartRow
{
    protected $eventid,$customer_id;

    function __construct($eventid,$customer_id)
    {
        $this->eventid=$eventid;
        $this->customer_id=$customer_id;
    }
 /**
    * @param Collection $collection
    */
    public function collection(Collection $collection)
    {
        $response =array();
        foreach ($collection->toArray() as $key => $value) {

            $originalDate = $value[1];

            // $parsedDate = strtotime($originalDate);
            // $carbonDate = Carbon::createFromTimestamp($parsedDate);
            // $formattedDate = $carbonDate->format('Y-m-d');

            // Create a Carbon instance from the imported date
            // $carbonDate = Carbon::parse($originalDate);
            // $formattedDate = $carbonDate->format('Y-m-d');

            $carbonDate = Carbon::createFromFormat('d/m/Y', $originalDate);
            if ($carbonDate) {
                $formattedDate = $carbonDate->format('Y-m-d');
            } else {
                $formattedDate = null;
            }

            //check if mobile_no & email exists -- start
            //$value[11] $value[14]
            if(!empty($value[11]) && !empty($value[14]))
            {
                $visitor = Visitor::where(function ($query) use ($value) {
                    $query->orWhere('mobile_no',$value[11])
                          ->orWhere('email',$value[14]);
                })->first();
            }
            if(!empty($value[11]) && empty($value[14]))
            {
                $visitor = Visitor::where(function ($query) use ($value) {
                    $query->orWhere('mobile_no',$value[11]);
                })->first();
            }
            if(empty($value[11]) && !empty($value[14]))
            {
                $visitor = Visitor::where(function ($query) use ($value) {
                    $query->orWhere('email',$value[14]);
                })->first();
            }
            //check if mobile_no & email exists -- end

            $data=([
                'event_id' =>$this->eventid,
                'customer_id' =>$this->customer_id,
                'visited_date' => $formattedDate,
                'company_name' => $value[3],
                'state' => $value[4],
                'city' => $value[5],
                'pincode' => $value[6],
                'address' => $value[7],
                'website' => $value[8],
                'name' => $value[9],
                'designation' => $value[10],
                'mobile_no' => $value[11],
                'mobile_no2' => $value[12],
                'mobile_no3' => $value[13],
                'email' => $value[14],
                'email2' => $value[15],
                'category' => $value[16],
                'sub_category' => $value[17],
                'remarks' => $value[19],
                'action' => $value[20],
                'attended_by' => $value[21],
                'monthly_requirement' => $value[22],
                'rating' => $value[23],
                'created_at'=>Carbon::now('Asia/Kolkata'),
                'updated_at'=>Carbon::now('Asia/Kolkata')
            ]);

            // array_push($response, $data);
            if($visitor) {
                $visitor->update($data);
            }else{
                Visitor::insert($data);
            }
        }
        // $response =array();
        // foreach ($collection->toArray() as $key => $value) {
        //         $data=([
        //             'event_id' =>$this->eventid,
        //             'customer_id' =>$this->customer_id,
        //             'created_at' => $value[1],
        //             'company_name' => $value[2],
        //             'state' => $value[3],
        //             'city' => $value[4],
        //             'pincode' => $value[5],
        //             'address' => $value[6],
        //             'website' => $value[7],
        //             'name' => $value[8],
        //             'designation' => $value[9],
        //             'mobile_no' => $value[10],
        //             'mobile_no2' => $value[11],
        //             'mobile_no3' => $value[12],
        //             'email' => $value[13],
        //             'email2' => $value[14],
        //             'category' => $value[15],
        //             'remarks' => $value[16],
        //             'action' => $value[17],
        //             'attended_by' => $value[18],
        //         ]);

        //             // array_push($response, $data);
        //             Visitor::insert($data);
        //     }
            //    echo "<pre>";print_r($response);die;
    }
    public function startRow(): int
    {
        return 2;
    }
}
