<?php

namespace App\Http\Controllers;

use App\DataTables\VisitorBatchDataTable;
use App\Models\AssignDivisionAdmin;
use App\Models\AssignDivisionTeamMember;
use App\Models\EmailBatch;
use App\Models\EmailBatchLog;
use App\Models\EmailDraft;
use Illuminate\Http\Request;
use App\DataTables\VisitorsDataTable;
use App\Models\Visitor;
use App\Models\EventImage;
use DB;
use Illuminate\Support\Facades\Session;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\VisitorlistExport;
use App\Imports\Importvisitorlist;
use Alert;
use App\Models\Action;
use App\Models\Product;
use App\Models\User;
use App\Models\Visit_data_images;
use App\Models\VisitData;
use ZipArchive;
use Carbon\Carbon;
use PDF;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Str;

class VisitorController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->_visitor = new Visitor();
    }

    public function index(Request $request,VisitorsDataTable $dataTable)
    {
        $data['regions'] = DB::table('region')->select('name', 'id')->orderBy('name', 'asc')->get();
        $data['region'] = 'all';
        $data['categories'] = DB::table('category')->select('name', 'id')->orderBy('name', 'asc')->get();
        $data['category_id'] = "all";
        $data['sub_category_id'] = "all";
        $data['is_international'] = "all";
        $data['start_date'] = Carbon::now()->subYear()->format('Y-m-d');
        $data['end_date'] = Carbon::now()->addDay()->format('Y-m-d');

        //$data['countries'] = DB::table('countries')->select('name', 'id')->orderBy('name', 'asc')->get();
        $data['country_id'] = "all";

        //$data['states'] = DB::table('states')->select('name', 'id')->orderBy('name', 'asc')->get();
        $data['state_id'] = "all";
        $data['city_id'] = "all";
        $data['events'] = DB::table('events')->select('event_name', 'id')->orderBy('event_name', 'asc')
        // ->where('type_show_all','=','true')
        ->get();
        $data['event_id'] = "all";
        $data['users'] = DB::table('users')->where('is_delete','=','false');
        $authAdmin = auth()->user();
        if($authAdmin->type == 'sub-admin'){
            $divisionIds = AssignDivisionAdmin::where('admin_id',$authAdmin->id)->pluck('division_id')->toArray();
            $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id',$divisionIds)->pluck('customer_id')->toArray();
            $data['users'] = $data['users']->whereIn('CustomerID',$divisionTeamMemberIds);
        }
        $data['users'] = $data['users']->select('CustomerName', 'CustomerID')->orderBy('CustomerName', 'asc')->get();
        $data['CustomerID'] = "all";
        $data['otherEmailDrafts'] = EmailDraft::where('email_type','other')->get();

        $data['username'] = DB::table('users')
        ->where('users.is_delete','=','false')
        ->get();
        $data['user'] = json_decode( $data['username']);

        if (isset($request->event_id)) {
            $data['event_id'] = $request->event_id;
        }
        if (isset($request->CustomerID)) {
            $data['CustomerID'] = $request->CustomerID;
        }
        if (isset($request->category_id)) {
            $data['category_id'] = $request->category_id;
        }
        if (isset($request->sub_category_id)) {
            $data['sub_category_id'] = $request->sub_category_id;
        }

        if (isset($request->country_id)) {
            $data['country_id'] = $request->country_id;
        }
        if (isset($request->state_id)) {
            $data['state_id'] = $request->state_id;
        }
        if (isset($request->city_id)) {
            $data['city_id'] = $request->city_id;
        }
        if (isset($request->is_international)) {
            $data['is_international'] = $request->is_international;
        }
        if (isset($request->region)) {
            $data['region'] = $request->region;
        }
        if (isset($request->start_date)) {
            $data['start_date'] = $request->start_date;
        }
        if (isset($request->end_date)) {
            $data['end_date'] = $request->end_date;
        }

        return $dataTable->with(['event_id' => $data['event_id'],
            'CustomerID' => $data['CustomerID'],
            'category_id' => $data['category_id'],
        'sub_category_id' => $data['sub_category_id'],
            'country_id' => $data['country_id'],
            'state_id' => $data['state_id'],
            'city_id' => $data['city_id'],
            'is_international' => $data['is_international'],
            'region' => $data['region'],
            'start_date' => $data['start_date'],
            'end_date' => $data['end_date'],
        ])->render('visitor.index',$data);
    }
    public function detailview(Request $request)
    {
        $data['data'] = DB::table('visitors')
        ->select('events.event_name','users.CustomerName','visitors.*')
        ->join('events', 'events.id', 'visitors.event_id')
        ->leftjoin('users', 'users.CustomerID', 'visitors.customer_id')
        ->where('visitors.id', $request->id)->first();



        $data['event_images'] = DB::table('event_images')
        ->where('visitor_id', $request->id)
        ->get();

        $data['visitor_products'] = DB::table('visitor_products')
        ->select('products.name as productname','visitor_products.*')
        ->leftjoin('products','products.id','visitor_products.product_id')
        ->where('visitor_products.visitor_id', $request->id)
        ->get();
        $eventIdsString = $data['data']->event_ids;
        $eventIdsArray = explode(',', $eventIdsString);

        $data['eventNames'] = DB::table('events')
            ->whereIn('id', $eventIdsArray)
            ->pluck('event_name')
            ->toArray();

        $data['visit_all'] = DB::table('visit_data')
        ->where('fk_visitor_id', $request->id)->orderBy('id','desc')
        ->get();
        // ->pluck('action')
        // ->toArray();

        // dd($data['visit_action']);

        return view('visitor.visitordetail', $data);
    }

    public function exportvisitorlist(Request $request)
    {
        if (isset($request->event_id) && $request->event_id != "all") {
            $eventid =$request->event_id;
            $event = DB::table('events')->select('events.event_name')->where('id',$eventid)->first();
            $event = $event->event_name;
        }else{
            $event = "all";
        }


        if($request->event_id == '' && $request->CustomerID == '' && $request->category_id == '' && $request->sub_category_id == '' && $request->state_id == '' && $request->city_id == '' && $request->country_id == null && $request->region == null && $request->start_date == null && $request->end_date == null){
            $event_id = 'all';
            $customer_id = 'all';
            $category_id = 'all';
            $sub_category_id = 'all';
            $state_id = 'all';
            $city_id = 'all';
            $is_international = 'all';
            $country_id = 'all';
            $region = 'all';
            $start_date = Carbon::now()->subYear()->format('Y-m-d');
            $end_date = Carbon::now()->addDay()->format('Y-m-d');
        }else{
            $event_id= $request->event_id;
            $customer_id=$request->CustomerID;
            $category_id=$request->category_id;
            $sub_category_id=$request->sub_category_id;
            $state_id=$request->state_id;
            $city_id=$request->city_id;
            $is_international=$request->is_international;
            $country_id=$request->country_id;
            $region=$request->region;
            $start_date=$request->start_date;
            $end_date=$request->end_date;
        }
        return Excel::download(new VisitorlistExport($event_id,$customer_id,$category_id,$sub_category_id,$state_id,$city_id,$is_international,$country_id,$region,$start_date,$end_date), $event.'.xlsx',\Maatwebsite\Excel\Excel::XLSX);
    }

    public function export_pdf(Request $request)
    {
        // $perPage = 50;
        // $page = 1;
        if (isset($request->event_id) && $request->event_id != "all") {
            $eventid =$request->event_id;
            $event = DB::table('events')->select('events.event_name')->where('id',$eventid)->first();
            $event = $event->event_name;
        }else{
            $event = "all";
        }

        if($request->event_id == null && $request->CustomerID == null && $request->category_id == null && $request->sub_category_id == null && $request->state_id == null && $request->city_id == null && $request->is_international == null && $request->country_id == null && $request->region == null && $request->start_date == null && $request->end_date == null){
            $event_id = 'all';
            $customer_id = 'all';
            $category_id = 'all';
            $sub_category_id = 'all';
            $state_id = 'all';
            $city_id = 'all';
            $is_international = 'all';
            $country_id = 'all';
            $region = 'all';
            $start_date = Carbon::now()->subYear()->format('Y-m-d');
            $end_date = Carbon::now()->addDay()->format('Y-m-d');
        }else{
            $event_id= $request->event_id;
            $customer_id=$request->CustomerID;
            $category_id=$request->category_id;
            $sub_category_id=$request->sub_category_id;
            $state_id=$request->state_id;
            $city_id=$request->city_id;
            $is_international=$request->is_international;
            $country_id=$request->country_id;
            $region = $request->region;
            $start_date=$request->start_date;
            $end_date=$request->end_date;
        }

        $query = DB::table('visitors')
        ->select('events.event_name','users.CustomerName','visitors.*')
        ->join('events', 'events.id', 'visitors.event_id')
        ->leftjoin('users', 'users.CustomerID', 'visitors.customer_id')
        // ->leftjoin('visitor_products', 'visitor_products.visitor_id', 'visitors.id')
        // ->leftjoin('products', 'products.id', 'visitor_products.product_id')
        ->orderBy('visitors.id', 'desc');

        if ($event_id != "all") {
            $query = $query->where(function ($query) use ($event_id) {
                $query->where('event_id', $event_id)
                    ->orWhereRaw('FIND_IN_SET(?, visitors.event_ids)', [$event_id]);
            });
        }
        if($customer_id !="all"){
            $query = $query->where('CustomerID', $customer_id);
        }else{
            $authAdmin = auth()->user();
            if($authAdmin->type == 'sub-admin'){
                $divisionIds = AssignDivisionAdmin::where('admin_id',$authAdmin->id)->pluck('division_id')->toArray();
                $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id',$divisionIds)->pluck('customer_id')->toArray();
                $query = $query->whereIn('CustomerID',$divisionTeamMemberIds);
            }
        }

        if ($category_id != "all" && $category_id != null) {
            $categoryName = DB::table('category')->where('id',$category_id)->select('name', 'id')->first()->name;
            $query = $query->where(function ($query) use ($categoryName) {
                $query->whereRaw('FIND_IN_SET(?, visitors.category)', [$categoryName]);
            });
        }

        if ($sub_category_id != "all" && $sub_category_id != null) {
            $subCategoryName = DB::table('sub_categories')->where('id',$sub_category_id)->select('name', 'id')->first()->name;
            $query = $query->where(function ($query) use ($subCategoryName) {
                $query->whereRaw('FIND_IN_SET(?, visitors.sub_category)', [$subCategoryName]);
            });
        }

        if ($state_id != "all" && $state_id != null) {
            $stateName = DB::table('states')->where('id',$state_id)->select('name', 'id')->first()->name;
            $query = $query->where('visitors.state', $stateName);
        }

        if ($city_id != "all" && $city_id != null) {
            $cityName = DB::table('cities')->where('id',$city_id)->select('name', 'id')->first()->name;
            $query = $query->where('visitors.city', $cityName);
        }

        if ($is_international != "all" && $is_international != null) {
            $query = $query->where('visitors.is_international', $is_international);
        }

        if ($country_id != "all" && $country_id != null) {

            $countryISOCode = DB::table('countries')->where('id',$country_id)->select('iso_code','name', 'id')->first()->iso_code;
            $query = $query->where('visitors.country_code', '=',$countryISOCode);

        }

        if ($region != "all" && $region != null) {
            $regionCountries = DB::table('region_country')->where('fk_region_id',$region)->get();
            if($regionCountries){
                $regionCountryIds = $regionCountries->pluck('fk_country_id')->toArray();
                $countries = DB::table('countries')
                    ->whereIn('id',$regionCountryIds)->select('iso_code','name', 'id')->get();
                if($countries){
                    $countryISOCodes = $countries->pluck('iso_code')->toArray();
                    $query = $query->whereIn('visitors.country_code', $countryISOCodes);
                }
            }
        }

        if ($start_date != null && $end_date != null) {
            $startDateFormatted = date('Y-m-d', strtotime($start_date));
            $endDateFormatted = date('Y-m-d', strtotime($end_date));
            $query = $query->where(function ($query) use ($startDateFormatted, $endDateFormatted){
                $query->where('visitors.visited_date', '>=', $startDateFormatted)
                    ->where('visitors.visited_date', '<=', $endDateFormatted);
            });
        }
        $query = $query->get();
        $pdfPaths = [];
        $dataChunks = collect($query)->chunk(50);

        foreach ($dataChunks as $chunk) {
            $pdf = PDF::loadView('visitor.list_pdf1', ['event_id' => $event_id, 'customer_id' => $customer_id, 'data' => $chunk])
                ->setOption('page-size', 'A4')
                ->setOption('orientation', 'landscape');

            $pdfFileName = 'pdf_' . Str::uuid() . '.pdf';
            $pdfPath = storage_path('app/' . $pdfFileName);

            $pdf->save($pdfPath);
            $pdfPaths[] = $pdfPath;

            unset($pdf);
        }

        $zipFileName = 'all_pdfs.zip';
        $zipPath = storage_path('app/' . $zipFileName);

        $zip = new ZipArchive;
        if ($zip->open($zipPath, ZipArchive::CREATE | ZipArchive::OVERWRITE) === TRUE) {
            foreach ($pdfPaths as $path) {
                $zip->addFile($path, basename($path));
            }
            $zip->close();
        }

        foreach ($pdfPaths as $path) {
            unlink($path);
        }
      
        return response()->download($zipPath)->deleteFileAfterSend(true);
        
        // $query = $query->get();
        
        // $pdf = PDF::loadView('visitor.list_pdf', ['event_id' => $event_id, 'customer_id' => $customer_id, 'query' => $query])
        // ->setOption('page-size', 'A4')
        // ->setOption('orientation', 'landscape');
        // // $pdf->stream(); // Set the page orientation to landscape

        // $filename = $event . '.pdf';
        // return $pdf->download($filename);
        
        // $query = $query->get();
        // $pdfPaths = [];
        // $dataChunks = collect($query)->chunk(100);
        
        // foreach ($dataChunks as $chunk) {
        //     $pdf = PDF::loadView('visitor.list_pdf1', ['event_id' => $event_id, 'customer_id' => $customer_id, 'data' => $chunk])
        //         ->setOption('page-size', 'A4')
        //         ->setOption('orientation', 'landscape');
        
        //     $pdfFileName = 'pdf_' . Str::uuid() . '.pdf';
        //     $pdf->save(storage_path('app/pdf/' . $pdfFileName));
        //     $pdfPaths[] = storage_path('app/pdf/' . $pdfFileName);
        // }
        
        // $zipFileName = 'all_pdfs.zip';
        // $zip = new ZipArchive;
        // if ($zip->open(storage_path('app/pdf/' . $zipFileName), ZipArchive::CREATE | ZipArchive::OVERWRITE) === TRUE) {
        //     foreach ($pdfPaths as $path) {
        //         $zip->addFile($path, basename($path));
        //     }
        //     $zip->close();
        // }
        
        // // Delete original PDF files
        // foreach ($pdfPaths as $path) {
        //     unlink($path);
        // }
        // return response()->download(storage_path('app/pdf/' . $zipFileName))->deleteFileAfterSend(true);

        // $query = $query->limit(50)->get();
       
    }

    public function insertexportfile(Request $request)
    {
        $eventid= $request->event_id;
        $customer_id= $request->CustomerID;
        Excel::import(new Importvisitorlist($eventid,$customer_id),$request->file('importfile')->store('importfile'));
        return redirect()->back();
    }

    // public function edit(Request $request)
    // {
    //     $data['data'] = DB::table('visitors')
    //     ->select('events.event_name','users.CustomerName','visitors.*')
    //     ->join('events', 'events.id', 'visitors.event_id')
    //     ->leftjoin('users', 'users.CustomerID', 'visitors.customer_id')
    //     ->where('visitors.id', $request->id)->first();

    //     $data['event_images'] = DB::table('event_images')
    //     ->where('visitor_id', $request->id)
    //     ->get();

    //     return view('visitor.editvisitor');
    // }

    public function downloadImages(Request $request)
    {
        if(isset($request->event_id) && isset($request->CustomerID))
        {
            if($request->event_id != 'all' && $request->CustomerID != 'all')
            {
                $visitors = Visitor::select('front_image', 'back_image')->where(['customer_id' => $request->CustomerID, 'event_id' => $request->event_id])->get()->toArray();
                $event_images = EventImage::select('event_images.event_image')
                                ->join('visitors', 'visitors.id', '=', 'event_images.visitor_id')
                                ->where(['visitors.customer_id' => $request->CustomerID, 'event_images.event_id' => $request->event_id])
                                ->groupby('event_images.id')
                                ->get()
                                ->toArray();
            }
            elseif ($request->event_id == 'all' && $request->CustomerID != 'all') {
                $visitors = Visitor::select('front_image', 'back_image')->where('customer_id', $request->CustomerID)->get()->toArray();
                $event_images = EventImage::select('event_images.event_image')
                                ->join('visitors', 'visitors.id', '=', 'event_images.visitor_id')
                                ->where('visitors.customer_id', $request->CustomerID)
                                ->groupby('event_images.id')
                                ->get()
                                ->toArray();
            }
            elseif ($request->event_id != 'all' && $request->CustomerID == 'all') {
                $visitors = Visitor::select('front_image', 'back_image')->where('event_id', $request->event_id)->get()->toArray();
                $event_images = EventImage::select('event_images.event_image')
                                ->join('visitors', 'visitors.id', '=', 'event_images.visitor_id')
                                ->where('event_images.event_id', $request->event_id)
                                ->groupby('event_images.id')
                                ->get()
                                ->toArray();
            }
            else
            {
                $visitors = Visitor::select('front_image', 'back_image')->get()->toArray();
                $event_images = EventImage::select('event_image')->get()->toArray();
            }
        }
        else
        {
            $visitors = Visitor::select('front_image', 'back_image')->get()->toArray();
            $event_images = EventImage::select('event_image')->get()->toArray();
        }
        $visitors_front_images = array_column($visitors, 'front_image');
        $visitors_back_images = array_column($visitors, 'back_image');
        $event_images = array_column($event_images, 'event_image');

        $images = array_merge($visitors_front_images, $visitors_back_images, $event_images);

        $fileName = $this->downloadZip($images);
        $filePath = public_path($fileName);

        if(file_exists($filePath))
        {
            return response()->download($filePath)->deleteFileAfterSend(true);
        }
        return redirect('visitor/list');
    }

    public function downloadZip($files)
    {

		$files = array_filter($files);
        $zip = new ZipArchive;

        $fileName = env('ZIP_IMAGE_PATH', 'Images.zip');
        $filePath = public_path($fileName);
        if(file_exists($filePath))
        {
            unlink($filePath);
        }

        if ($zip->open($filePath, ZipArchive::CREATE) === TRUE)
        {
            foreach ($files as $key => $value) {
                $relativeNameInZipFile = basename($value);
                $download_file = file_get_contents($value);
                $zip->addFromString($relativeNameInZipFile, $download_file);
                // $zip->addFile($download_file, $relativeNameInZipFile);
            }

            $zip->close();
        }

        return $fileName;
    }

	public function updateEmail(Request $request)
	{
		$request->validate([
			'id' => 'required',
			'email' => 'required',
		]);
		$visitor = Visitor::find($request->id);
		if(!empty($visitor))
		{
            $visitor->email = $request->email;
            $visitor->updated_at = Carbon::now();
            $visitor->save();
		}
		return redirect()->back();
	}

    public function setMail(Request $request)
    {
        $mailConfigData = DB::table('email_config')->first();
        if(empty($mailConfigData)){
            return response()->json([
                'status' => false,
                'message' => 'Mail could not be sent because config data not found!'
            ]);
        }
        $requestData = $request->all();
        $requestData['created_by'] = auth()->id();
        $requestData['hour_interval_mails'] = $mailConfigData->hour_limit ?? 20;
        $requestData['schedule_date'] = $request->schedule_date ? Carbon::parse($request->schedule_date) : Carbon::now();
        $requestData['status'] = 'pending';
        $requestData['email_type'] = $request->type;
        $visitorEmails = Visitor::fetchEmailVisitors($request->event_id,$request->CustomerID,$request->category_id,$request->sub_category_id,$request->state_id,$request->city_id,$request->is_international)->get();
        // dd($visitorEmails);
        if($visitorEmails->count() == 0) {
            Alert::error('Error', 'No Visitors found!');
            return redirect()->back();
        }
        $schedule = EmailBatch::create($requestData);
        foreach($visitorEmails as $visitorEmail)
        {
            EmailBatchLog::create([
                'batch_id' => $schedule->id,
                'visitor_id' => $visitorEmail->id,
                'user_id' => $visitorEmail->customer_id,
                'status' => 'pending'
            ]);
        }
        Alert::success('Success', 'Schedule mail set successfully!');
        return redirect()->back();
    }

    public function batchList(Request $request, VisitorBatchDataTable $dataTable)
    {
        return $dataTable->render('visitor.batch-list');
    }

    public function batchDelete($batch_id)
    {
        $emailBatch = EmailBatch::whereId($batch_id)->first();
        if(empty($emailBatch)){
            return response()->json([
                "status" => false,
            ]);
        }
        EmailBatchLog::whereBatchId($emailBatch->id)->delete();
        $emailBatch->delete();
        return response()->json([
            "status" => true,
        ]);
    }
    public function getimage(Request $request)
    {
        try {
            $data =DB::table('visitors')->where('id',$request->id)->get();
            // dd($data);
            if(!empty($data->toArray())) {
                return response()->json(['data' => $data]);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }

    }

    public function geteventlist_multi(Request $request)
    {
        try {
            $data =DB::table('events')->select('event_name','id')->get();

            if(!empty($data->toArray())) {
                return response()->json(['data' => $data]);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }

    }
    public function get_visitdata(Request $request)
    {
        try {

            $data =DB::table('visit_data')->where('id',$request->id)->get();

            if(!empty($data->toArray())) {
                return response()->json(['data' => $data]);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }

    }
    public function get_visit_images(Request $request)
    {
        try {

            $data =DB::table('visit_data_images')->where('fk_visit_id',$request->id)->get();

            if(!empty($data->toArray())) {
                return response()->json(['data' => $data]);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }

    }
    public function get_visit_product(Request $request)
    {
        try {

            $data =DB::table('visit_data_product')
            ->select('visit_data_product.*','products.name as productname')
            ->leftjoin('products','products.id','visit_data_product.fk_product_id')
            ->where('fk_visit_data_id',$request->id)
            ->get();

            // dd($data);
            if(!empty($data->toArray())) {
                return response()->json(['data' => $data]);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }

    }
    public function geteventlist(Request $request)
    {
        try {
            $data =DB::table('events')->select('event_name','id')->get();

            if(!empty($data->toArray())) {
                return response()->json(['data' => $data]);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }

    }

    public function updateeventname(Request $request)
	{
        try {
            $dataArray = $request->visitor_id;
            $jsonStr = $dataArray[0];
            $idArray = json_decode($jsonStr);

            foreach ($idArray as $id) {
                $visitor = Visitor::find($id);

                if(!empty($visitor))
                {
                    $visitor->event_id = $request->eventid;
                    $visitor->updated_at = Carbon::now();
                    $visitor->save();
                }
            }
            return redirect()->back();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
	}

    public function addevent_ids(Request $request)
	{
        $existingRow = DB::table('visitors')->where('id', $request->visitor_id)->first();

        if ($existingRow) {
            $existingEventIds = explode(',', $existingRow->event_ids);

            // Convert request event_ids to an array
            $requestEventIds = is_array($request->events_id) ? $request->events_id : [];

            // Loop through existing event IDs and remove unchecked ones
            foreach ($existingEventIds as $key => $eventId) {
                if (!in_array($eventId, $requestEventIds)) {
                    // Unchecked event ID found, remove it
                    unset($existingEventIds[$key]);
                }
            }

            // Combine and unique event IDs
            $uniqueEventIds = array_unique(array_merge($existingEventIds, $requestEventIds));

            // Convert the array back to a comma-separated string
            // $eventIdsString = implode(',', $uniqueEventIds);
            $eventIdsString = ',' . implode(',', $uniqueEventIds) . ',';

            DB::table('visitors')
                ->where('id', $request->visitor_id)
                ->update(['event_ids' => $eventIdsString]);

            return redirect()->back();
        }
	}

    function fetchevent(Request $request)
    {
        if($request->get('query'))
        {
            $query = $request->get('query');
            $data = DB::table('events')
            ->where('event_name', 'LIKE', "%{$query}%")
            ->get();
            $output = '
                    <div class="menu" style="display:block; position:relative"></div>
                    ';
            foreach($data as $row)
            {
                $output .= '
                <li><a href="#">'.$row->event_name.'</a></li>
                ';
            }
            $output .= '</ul>';
            echo $output;
        }

    }
    function getname_search(Request $request)
    {
        try {
            $getFields = DB::table('events')
            ->select('event_name')
            ->where('event_name',$request->search)
            ->first();

            return response()->json($getFields, 200);
        } catch (\Exception $e) {
            return response()->json([
                'message' => $e->getMessage()
            ], 500);
        }
    }
    public function destroy($id)
    {
        try {
            DB::table('visitor_products')->where('visitor_id',$id)->delete();
            Visitor::where('id', $id)->delete();

            return response()->json([
                "status" => true,
            ]);
        } catch (\Exception $e){
            return $e->getMessage();
        }
    }
    public function getproductlist(Request $request)
    {
        try {
            $data =DB::table('product_images')->select('image','id','description')->get();

            if(!empty($data->toArray())) {
                return response()->json(['data' => $data]);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }

    }

     public function edit(Request $request,Visitor $visitor)
     {
         $event_images = DB::table('event_images')
             ->where('visitor_id', $visitor->id)
             ->get();
         $visitor->category = explode(',',$visitor->category);
         $visitor->sub_category = explode(',',$visitor->sub_category);
         $actions = DB::table('actions')->select('title', 'id')->orderBy('title', 'asc')->get();
         $categories = json_encode(DB::table('category')->select('name', 'id')->orderBy('name', 'asc')->get()->toArray());
         $categoryIds = DB::table('category')->whereIn('name',$visitor->category)->get()->pluck('id');
         $subcategories = [];
         if($categoryIds){
             $subcategories = DB::table('sub_categories')->whereIn('fk_category_id',$categoryIds)->select('name', 'id')->get();
         }
         $countries = DB::table('countries')->select('iso_code','name', 'id')->orderBy('name', 'asc')->get();
         $states = [];
         if($visitor->address_country_code && $visitor->address_country_code == 'IN'){
             $states = DB::table('states')->where('country_code',$visitor->address_country_code)->select('name', 'id')->orderBy('name', 'asc')->get();
         }
         $state = DB::table('states')->where('name',$visitor->state)->first();
         $cities = [];
         if($state){
             $cities = DB::table('cities')->where('state_id',$state->id)->select('name', 'id')->orderBy('name', 'asc')->get();
         }
         $visitor->products = DB::table('visitor_products')
             ->select('products.id as id')
             ->leftjoin('products','products.id','visitor_products.product_id')
             ->where('visitor_products.visitor_id', $visitor->id)
             ->get()->pluck('id')->toArray();
         $allProducts = json_encode(DB::table('products')->get()->toArray());
         return view('visitor.editvisitor',compact('visitor','actions','categories','subcategories','states','cities','allProducts','event_images','countries'));
     }

    public function update(Request $request,Visitor $visitor)
    {
        $requestData = $request->all();
        $requestData['updated_at'] =Carbon::now('Asia/Kolkata');
        $requestData['category'] = implode(',',$request->category ?? []);
        $requestData['sub_category'] = implode(',',$request->sub_category ?? []);
        $visitor->update($requestData);
        if($request->products){
            DB::table('visitor_products')->where('visitor_id',$visitor->id)->delete();
            foreach ($request->products as $productId){
                DB::table('visitor_products')->insert([
                    'visitor_id' => $visitor->id,
                    'product_id' => $productId,
                    'created_at' => Carbon::now('Asia/Kolkata'),
                    'updated_at' => Carbon::now('Asia/Kolkata'),
                ]);
            }
        }
        Alert::success('Success', 'Visitor data updated successfully!');
        return redirect()->back();
    }

    public function getSubCategories(Request $request)
    {
        try {
            if($request->categoryNames){
                $categoryIds = DB::table('category')
                    ->whereIn('name',$request->categoryNames)
                    ->select('name', 'id')->pluck('id')->toArray();
                $data =DB::table('sub_categories')->whereIn('fk_category_id',$categoryIds)->get();
                $selectedSubCategoryIds = DB::table('sub_categories')
                    ->whereIn('name',explode(',',$request->selectedSubCategoryNames))
                    ->select('name', 'id')->pluck('id')->toArray();

                if(!empty($data->toArray())) {
                    return response()->json(['data' => $data,'selectedSubCategoryIds'=>$selectedSubCategoryIds]);
                }
            }elseif ($request->category_id){
                $data = DB::table('sub_categories')->where('fk_category_id',$request->category_id)->get();
                if(!empty($data->toArray())) {
                    return response()->json(['data' => $data]);
                }
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }
    public function getCities(Request $request)
    {
        try {
            if($request->stateName){
                $stateId = DB::table('states')->where('name',$request->stateName)->select('name', 'id')->first()->id;
            }elseif ($request->stateId){
                $stateId = DB::table('states')->where('id',$request->stateId)->select('name', 'id')->first()->id;
            }
            $data =DB::table('cities')->where('state_id',$stateId)->get();

            if(!empty($data->toArray())) {
                return response()->json(['data' => $data]);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function getStates(Request $request)
    {
        try {
            if($request->countryName){
                $countryId = DB::table('countries')->where('name',$request->countryName)->select('name', 'id')->first()->id;
            }elseif ($request->countryId){
                $countryId = DB::table('countries')->where('id',$request->countryId)->select('name', 'id')->first()->id;
            }elseif ($request->countryCode){
                $countryId = DB::table('countries')->where('iso_code',$request->countryCode)->select('name', 'id')->first()->id;
            }
            $data =DB::table('states')->where('country_id',$countryId)->orderBy('name', 'asc')->get();
            // dd($countryId);
            if(!empty($data->toArray())) {
                return response()->json(['data' => $data]);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function getCountries(Request $request)
    {
        try {
            $data =DB::table('countries')->where('iso_code','!=','IN')->select('name', 'id')->orderBy('name', 'asc')->get();

            if(!empty($data->toArray())) {
                return response()->json(['data' => $data]);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }


    public function add()
    {
        $events = DB::table('events')->select('event_name', 'id')->orderBy('event_name', 'asc')->get();
        $members = DB::table('users')->select('CustomerName', 'user_id','CustomerID')->where('is_delete','=','false');
        $authAdmin = auth()->user();
        if($authAdmin->type == 'sub-admin'){
            $divisionIds = AssignDivisionAdmin::where('admin_id',$authAdmin->id)->pluck('division_id')->toArray();
            $divisionTeamMemberIds = AssignDivisionTeamMember::whereIn('division_id',$divisionIds)->pluck('customer_id')->toArray();
            $members= $members->whereIn('CustomerID',$divisionTeamMemberIds);
        }
        $members= $members->orderBy('CustomerName', 'asc')->get();
        $actions = DB::table('actions')->select('title', 'id')->orderBy('title', 'asc')->get();
        $categories = json_encode(DB::table('category')->select('name', 'id')->orderBy('name', 'asc')->get()->toArray());
        $countries = DB::table('countries')->select('iso_code','name', 'id')->orderBy('name', 'asc')->get();
        $allProducts = json_encode(DB::table('products')->get()->toArray());
        $countryCode = 'IN';
        return view('visitor.add_visitor',compact('actions','categories','countries','events','members','allProducts','countryCode'));
    }

    public function store(Request $request)
    {
        // dd($request->all());
        $request->validate([
            'event_id' => 'required',
            'customer_id' => 'required',
            'name' => 'required',
        ]);
        $requestData = $request->all();
        // $requestData['follow_up_time'] = Carbon::now('Asia/Kolkata');
        $requestData['created_at'] =Carbon::now('Asia/Kolkata');
        $requestData['updated_at'] = Carbon::now('Asia/Kolkata');
       
        $requestData['visited_date'] = $request->visited_date;
        $requestData['category'] = implode(',',$request->category ?? []);
        $requestData['sub_category'] = implode(',',$request->sub_category ?? []);
        // dd($requestData);
        $visitor = Visitor::create($requestData);
        $requestData['front_image'] = null;
        $requestData['back_image'] = null;
        if ($request->file('front_image')) {
            $name = str_replace(' ', '_', $request->file('front_image')->getClientOriginalName());
            $ext = $request->file('front_image')->getClientOriginalExtension();
            $image = md5(microtime() . $name) . "." . $ext;
            $path = public_path('../../'.config('constants.API_PROJECT_NAME').'/public/uploads/visitor/');
            $request->file('front_image')->move($path,$name);
            $requestData['front_image'] = isset($name) && $name != '' ? config('app.url').'/'.config('constants.API_PROJECT_NAME').'/public/uploads/visitor/'.$name : '';
            
        }
        if ($request->file('back_image')) {
            $name = str_replace(' ', '_', $request->file('back_image')->getClientOriginalName());
            $ext = $request->file('back_image')->getClientOriginalExtension();
            $image = md5(microtime() . $name) . "." . $ext;
            $path = public_path('../../'.config('constants.API_PROJECT_NAME').'/public/uploads/visitor/');
            $request->file('back_image')->move($path,$name);
            $requestData['back_image'] = isset($name) && $name != '' ? config('app.url').'/'.config('constants.API_PROJECT_NAME').'/public/uploads/visitor/'.$name : '';
        }
        $visitor->update([
            'front_image' => $requestData['front_image'],
            'back_image' => $requestData['back_image']
        ]);
        if($request->products){
            DB::table('visitor_products')->where('visitor_id',$visitor->id)->delete();
            foreach ($request->products as $productId){
                DB::table('visitor_products')->insert([
                    'visitor_id' => $visitor->id,
                    'product_id' => $productId,
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now()
                ]);
            }
        }
        Alert::success('Success', 'Visitor data added successfully!');
        return redirect()->route('visitor.list');
    }

    public function get_visitorlist_id(Request $request)
    {
        try {
            // \DB::enableQueryLog();
            // dd(\DB::getQueryLog());

            $data = DB::table('visitors')
            ->where(function($data_all) use ($request) {
                $data_all->where('visitors.mobile_no', $request->mobile_no)
                      ->orWhere('visitors.email', $request->email);
            })

            // ->where('visitors.email','!=',"")
            // ->where('visitors.email','!=',null)
            // ->where('visitors.mobile_no','!=',"")
            // ->orWhere(function($data_all) use ($request) {
            //     $data_all->where('visitors.mobile_no', '!=', $request->mobile_no)
            //           ->where('visitors.email', $request->email)
            //           ->where('visitors.email','!=',"null");
            // })

            // ->where('visitors.mobile_no','!=',"")

            ->leftjoin('events','events.id','visitors.event_id')
            ->leftjoin('users','users.CustomerID','visitors.customer_id')
            ->select('visitors.*', 'events.event_name as event_name','users.CustomerName as CustomerName')
            ->get();

            if(!empty($data->toArray())) {
                return response()->json(['data' => $data]);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }

    }
	
    public function Multiple_Entries_destroy($id)
    {
        try {
            DB::table('visitor_products')->where('visitor_id',$id)->delete();
            Visitor::where('id', $id)->delete();
            // DB::table('visit_data')->where('fk_visitor_id',$id)->get();
            DB::table('visit_data')->where('fk_visitor_id',$id)->delete();

            return response()->json([
                "status" => true,
            ]);
        } catch (\Exception $e){
            return $e->getMessage();
        }
    }

    public function addVisitDataModal(Request $request){             
        $event_id  =  $request->event_id; 
        $visit_data_id = $request->visit_data_id ?? null;
        $title = 'Add';
        $data['visitor_id'] = $request->visitor_id;
        $data['allProducts'] = Product::pluck('name','id')->toArray();        
        $data['actions'] = Action::latest()->pluck('title','id')->toArray();
        $data['members'] =  User::where('is_delete','=','false')->pluck('CustomerName','CustomerID')->toArray();
        $data['current_time'] =  Carbon::now('Asia/Kolkata')->format('Y-m-d h:i');    
        if(!empty($visit_data_id)){
            $visitData = VisitData::with('products')->where('id',$visit_data_id)->first();
            $data['visit_data'] = $visitData;
            $title ='Edit';
        }
        $form_url  = route('visit.data.store',$event_id);
        $modalHtml = view('visitor.add_visit_data_modal',compact('form_url','data','title'))->render();
        return response()->json(['modalHtml'=>$modalHtml]);
    }

    public function addVisitDataStore(Request $request){
        try{            
            $data =  $request->all();
            $data['created_at'] = Carbon::now('Asia/Kolkata');
            $data['updated_at'] = Carbon::now('Asia/Kolkata');
            $fk_visitor_id = $request->fk_visitor_id; 
            $visit_data_id = $request->visit_data_id ?? null;                    
            
            // audio_file
            // $data['audio_file'] = null;
            if($request->hasFile('audio_file')){
                $audio_file = $request->file('audio_file');
                $audio = \str_replace(' ', '_', $audio_file->getClientOriginalName());                      
                $path = public_path('../../'.config('constants.API_PROJECT_NAME').'/public/uploads/visitor/');
                $request->file('audio_file')->move($path,$audio);
                $audio_file = $audio;
                $data['audio_file'] =  isset($audio_file) && $audio_file != '' ? config('app.url').'/'.config('constants.API_PROJECT_NAME').'/public/uploads/visitor/'. $audio_file : '';           
            }                    
            $team_member = user::where('CustomerID',$request->fk_teammember_id)->first();
            $data['attend_by'] =  $team_member->CustomerName;
            $visit_data = VisitData::updateOrCreate(['id'=>$visit_data_id],$data);
            Visitor::where('id', $fk_visitor_id)->update(['updated_at' => Carbon::now('Asia/Kolkata')]);
           
            $visit_images_all = $request->file('visit_images');

            if (isset($visit_images_all) && !empty($visit_images_all)) {
                foreach ($visit_images_all as $key => $value) {
                    if (isset($value) && $value != '') {
                        $visit_image = \str_replace(' ', '_', $value->getClientOriginalName());                    
                        if ($value->move(\public_path('../../'.config('constants.API_PROJECT_NAME').'/public/uploads/event/'), $visit_image)) {
                            $visit_image = isset($visit_image) && $visit_image != '' ? config('app.url').'/'.config('constants.API_PROJECT_NAME').'/public/uploads/event/'.$visit_image : '';

                            if (isset($visit_image) && $visit_image != '') {
                                $image_data = new Visit_data_images();
                                $image_data->fk_visit_id = $visit_data->id;
                                $image_data->visit_image = $visit_image;
                                $image_data->created_at = date('Y-m-d H:i:s');
                                $image = $image_data->save();
                            }
                        }
                    }
                }
            }
            
            // Visit Products
            if (isset($request->products)) {
                DB::table('visit_data_product')->where('fk_visit_data_id',$visit_data->id)->delete();
                foreach ($request->products as $key1 => $product_id) {
                    $dataInsert = ([
                        'fk_visit_data_id' => $visit_data->id,
                        'fk_product_id' => $product_id,
                        'created_at' => Carbon::now('Asia/Kolkata')
                    ]);
                    DB::table('visit_data_product')->insert($dataInsert);
                }
            }
            $message  = empty($visit_data_id) ? 'Visit data added successfully!' : 'Visit data updated successfully!' ;
            Alert::success('Success', $message);
            return response()->json(['result'=>'1','message'=>'Visit Data']);
        }catch(\Exception $e){
            return response()->json(['result'=>'0','message'=>$e->getMessage()]);             
        }                
    }

    public function visit_delete(Request $request, $visitId) 
    {
        try {
            $visitData = VisitData::where('id', $visitId)->first();

            if (!$visitData) {
                return response()->json(['result' => '0', 'message' => 'Visit Data not found']);
            }

            Visitor::where('id', $visitData->visitor_id)->update(['updated_at' => Carbon::now('Asia/Kolkata')]);

            // Delete the audio file if it exists
            if ($visitData->audio_file) {              
                $imagePath = parse_url($visitData->audio_file, PHP_URL_PATH);            
                $imageName = basename($imagePath);                
                $image_path         = \public_path('../../'.config('constants.API_PROJECT_NAME').'/public/uploads/visitor/'). $imageName;
                if(File::exists($image_path)) {
                    File::delete($image_path);
                }
            }

            // Fetch and delete associated visit images
            $visitImages = Visit_data_images::where('fk_visit_id', $visitId)->get();
            foreach ($visitImages as $image) {
                $vimageFilePath = parse_url($image->visit_image, PHP_URL_PATH);
                $vimageName = basename($vimageFilePath);
                $vimageFilePath         = \public_path('../../'.config('constants.API_PROJECT_NAME').'/public/uploads/event/'). $vimageName;
                if (file_exists($vimageFilePath)) {
                    unlink($vimageFilePath);
                }
                $image->delete();
            }
            
            $visitData->delete();
            Alert::success('Success', 'Visit data Deleted successfully!');
            return response()->json(['result' => '1', 'message' => 'Visit Data Deleted']);
        } catch (\Exception $e) {
            return response()->json(['result' => '0', 'message' => $e->getMessage()]);
        }
    }
}
