<?php

namespace App\Http\Controllers;

use Alert;
use App\Models\AssignDivisionTeamMember;
use Illuminate\Support\Facades\Auth;
use Hash;
use Illuminate\Http\Request;
use App\DataTables\UsersDataTable;
use App\Models\User;
use App\Models\EmailDraft;
use DB;
use App\Jobs\SendNotification;


class UserController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->_user = new User();
    }
    public function index(Request $request,UsersDataTable $dataTable)
    {
        $CustomerID = $request->CustomerID;
        $data = DB::table('users')->where('is_delete','!=','true')->orderBy('CustomerID', 'desc')->get();

        return $dataTable->render('users.index',compact('CustomerID'));

    }
    public function permissionsview(Request $request)
    {
        $CustomerID  = $request->CustomerID ;
        $data['users'] = DB::table('users')
        ->select('CustomerName', 'CustomerID','location_config')
        ->where('CustomerID',$CustomerID)
        ->first();

        $data['permissions'] = DB::table('permissions')->where('fk_customer_id', $CustomerID)->first();
        $selectedDivisionIdsString = DB::table('assign_division_team_members')
            ->select('divisions.id as id')
            ->leftJoin('divisions', 'divisions.id', 'assign_division_team_members.division_id')
            ->where('assign_division_team_members.customer_id', $CustomerID)
            ->get()->pluck('id')->toArray();

        $allDivisions = DB::table('divisions')->get()->toArray();
        $encodedDivisions = [];

        foreach ($allDivisions as $division) {
            $division->name = htmlspecialchars($division->name, ENT_QUOTES);
            $encodedDivisions[] = $division;
        }
        $data['divisions'] = json_encode($encodedDivisions);
        $data['selectedDivisionIdsString'] = $selectedDivisionIdsString;

        return view('users.permissionsdetails',$data);

    }
    public function update_user_password(Request $request)
    {
        $this->validate($request, [
            'password' => 'required|confirmed|min:6',
        ]);

        $data['user'] =DB::table('users')->where('CustomerID',$request->CustomerID)->update(['password'=> Hash::make($request->password)]);
        Alert::success('Congrats', 'You have Successfully Password Change');

        return redirect('user/list');
    }
    public function edit_email(Request $request)
    {
        $CustomerID  = $request->CustomerID;
        $data['users'] = DB::table('users')
        ->where('CustomerID',$CustomerID)
        ->first();

        $data['user_emailconfig'] = DB::table('user_email_config')
        ->where('fk_user_id',$CustomerID)
        ->first();

        $data['CustomerID']  =$CustomerID;
        return view('users.edit_email',$data);

    }
    public function store_email(Request $request)
    {
        $get_user_id = DB::table('user_email_config')->where('fk_user_id', $request->id)->first();
        if(isset($get_user_id->fk_user_id) && $get_user_id->fk_user_id != null){
            $data = [
                'host' => $request->host,
                'username'     => $request->username,
                'password'    => $request->password,
                'port'    => $request->port,
                'smtp_transport'    => $request->smtp_transport,
                'smtp_encryption'    => $request->smtp_encryption,
                'updated_at'    => date('Y-m-d H:i:s'),
            ];
            $result= DB::table('user_email_config')->where('fk_user_id', $request->id)->update($data);
        }else{
            if($request->host == null){
                return redirect()->route('users.list');
            }else{
                $data = [
                    'fk_user_id'  => $request->id,
                    'host' => $request->host,
                    'username'     => $request->username,
                    'password'    => $request->password,
                    'port'    => $request->port,
                    'smtp_transport'    => $request->smtp_transport,
                    'smtp_encryption'    => $request->smtp_encryption,
                    'created_at'    => date('Y-m-d H:i:s'),
                ];
                $result= DB::table('user_email_config')->insert($data);
            }
        }
        Alert::success('Congrats', 'Updated successfully!');
        return redirect()->route('users.list');
    }
    public function store_email_admin(Request $request)
    {
        $data = [
            'sender_name'  => $request->sender_name,
            'sender_email' => $request->sender_email,
            'cc_email'     => $request->cc_email,
            'bcc_email'    => $request->bcc_email,
        ];
        $result= DB::table('users')->where('CustomerID', $request->id)->update($data);
        Alert::success('Congrats', 'Email updated successfully!');
        return redirect()->route('users.list');
    }
    public function updatepermission(Request $request)
    {
        $data = [
            'fk_customer_id' => $request->CustomerID,
            'Contact_Share' => isset($request->Contact_Share)?$request->Contact_Share:'0',
            'Call_Contact' =>  isset($request->Call_Contact)?$request->Call_Contact:'0',
            'Send_Whatsapp' => isset($request->Send_Whatsapp)?$request->Send_Whatsapp:'0',
            'Save_Contact' =>  isset($request->Save_Contact)?$request->Save_Contact:'0',
            'Export_Excel' => isset($request->Export_Excel)?$request->Export_Excel:'0',
            'send_email' => isset($request->send_email)?$request->send_email:'0',

        ];
        $check= DB::table('permissions')->where('fk_customer_id', $request->CustomerID)->count();

        if($check == 0)
        {
            $insert =DB::table('permissions')->insert($data);
            if($insert)
            {
                Alert::success('Congrats', 'Insert successfully!');
            }
        }
        else
        {
            $update =DB::table('permissions')->where('fk_customer_id', $request->CustomerID)->update($data);
            if($update)
            {
                Alert::success('Congrats', 'Updated successfully!');
            }
        }
        $locationConfig = $request->has('location_config') ? $request->location_config : 0;
        $updatedata = [
            'location_config' => $locationConfig,
        ];
        $response = DB::table('users')->where('CustomerID', $request->CustomerID)->update($updatedata);

        return redirect()->back();

    }
    public function destroy($user_id)
    {

        try {
            $data = [
                'is_delete' => 'true',
            ];
            User::where('user_id', $user_id)->update($data);
            return response()->json([
                "status" => true,
            ]);
        } catch (\Exception $e){
            return $e->getMessage();
        }
    }
    // protected function store(Request $request)
    // {

    //     $id = $request->id;
    //     var_dump($request->customerids);
    //     foreach($request->customerids as $key=>$user_id)
    //     {
    //          $data =  [
    //              'fk_user_id' => $user_id,
    //              'fk_event_id' => $id,
    //          ];
    //          $insert =DB::table('event_assignments')->insert($data);
    //      }
    //      return redirect('event/list');

    // }
    public function updateIsAdmin(Request $request)
    {
        $check_data = DB::table('event_assignments')->where('fk_user_id',$request->user_id)->get();
        if($request->isadminvalue == 'true') {
            $isadmin = 'false';

            if($check_data != null){
                $data =  [
                    'is_admin' => 'false',
                ];
                $update =DB::table('event_assignments')->where('fk_user_id',$request->user_id)->update($data);
            }

        } else {

            $isadmin = 'true';
            $get_all_event = DB::table('events')->get();

            foreach ($get_all_event as $event) {
                $event_id = $event->id;

                $is_assigned = $check_data->contains('fk_event_id', $event_id);

                if (!$is_assigned) {
                    DB::table('event_assignments')->insert([
                        'fk_user_id' => $request->user_id,
                        'fk_event_id' => $event_id,
                        'is_admin' => true,
                    ]);
                }

                if($check_data != null){
                    $data =  [
                        'is_admin' => 'true',
                    ];
                    $update =DB::table('event_assignments')->where('fk_user_id',$request->user_id)->update($data);
                }
            }
            $id = $request->user_id;
            $type = "admin_assign";
            SendNotification::dispatch($id,$type);
        }

        $data = [
            'CustomerID' => $request->CustomerID,
            'is_admin' => $isadmin,
        ];
        $result= DB::table('users')->where('CustomerID', $request->CustomerID)->update($data);



        return redirect()->back();
    }

    public function updateEmail(Request $request)
    {
        try {
            $user = User::where('user_id', $request->user_id)->first();

            if(!empty($user))
            {
                $update = User::where('user_id', $request->user_id)->update(['sender_name' => $request->sender_name, 'sender_email' => $request->sender_email,
                'cc_email' => $request->cc_email,'bcc_email' => $request->bcc_email]);

                if($update)
                {
                    Alert::success('Congrats', 'Email updated successfully!');
                }
            }
            else
            {
                Alert::error('Sorry', 'Something went wrong!');
            }
        } catch (\Exception $e) {
            Alert::error('Sorry', 'Something went wrong!');
        }
        return redirect('user/list');
    }

    public function assignEmail(Request $request)
    {
        try {
            $update = User::where('user_id', $request->user_id)->update(['follow_up_email' => $request->follow_up_email, 'primary_email' => $request->primary_email]);

            if($update)
            {
                Alert::success('Congrats', 'Email Assign successfully!');
            }
            else
            {
                Alert::error('Sorry', 'Something went wrong!');
            }
        } catch (\Exception $e) {
            Alert::error('Sorry', 'Something went wrong!');
        }
        return redirect()->back();
    }

    public function emailPopup(Request $request)
    {
        $follow_up_emails = EmailDraft::where('email_type', 'follow_up')->get();
        $primary_emails = EmailDraft::where('email_type', 'primary')->get();
        $user = User::where('user_id', $request->id)->first();

        $data = array(
            'user' => $user,
            'follow_up_emails' => $follow_up_emails,
            'primary_emails' => $primary_emails,
        );
        $html = view('users.assign-email-popup', $data)->render();

        $true_email = [
            'send_email' => "1",
        ];
        DB::table('permissions')->where('fk_customer_id', $request->CustomerID)->update($true_email);

        return response()->json(['html' => $html]);
    }
    public function getUserlist(Request $request)
    {
        try {
            $data = DB::table('users')->where('is_delete','!=','true')->where('CustomerID','!=',$request->db_CustomerID)->orderBy('CustomerID', 'desc')->get();

            if(!empty($data->toArray())) {
                return response()->json(['data' => $data]);
            }
        }
        catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }

    }
    public function addcustomer_id(Request $request)
    {
        $data = [
            'replaced_with' => $request->CustomerID,
            'is_delete' => 'true'
        ];
        $result= DB::table('users')->where('CustomerID', $request->db_customer_id)->update($data);
        // $result= DB::table('users')->where('CustomerID', $request->CustomerID)->update(['is_delete' => 'true']);

        Alert::success('Congrats', 'Updated successfully!');
        // return redirect()->back();
        return redirect('user/list');
    }

    public function updateCheckbox(Request $request)
    {
        if($request->currentValue == 0){
            $isChecked = 1;
        }else{
            $isChecked = 0;
        }
        $updatedata = [
            'location_config' => $isChecked,
        ];
        $response= DB::table('users')->where('user_id', $request->user_id)->update($updatedata);

        return response()->json(['message' => 'Checkbox status updated successfully']);
    }

    public function divisionUpdate(Request $request)
    {
        $teamMember = DB::table('users')->where('CustomerID',$request->CustomerID)->first();
        if(isset($request->divisions)){
            AssignDivisionTeamMember::where('customer_id',$teamMember->CustomerID)->delete();
            foreach ($request->divisions as $divisionId) {
                $assignDivisionTeamMember =  new AssignDivisionTeamMember();
                $assignDivisionTeamMember->division_id  = $divisionId;
                $assignDivisionTeamMember->customer_id   = $teamMember->CustomerID;
                $assignDivisionTeamMember->save();
            }
        }
        Alert::success('Congrats', 'Division updated for TeamMember successfully');
        return redirect()->route('users.permissionsview',['CustomerID'=>$teamMember->CustomerID]);
    }
}
