<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\DataTables\Sub_categoriesDataTable; 
use App\Models\Sub_category;
use App\Models\Category;
use DB;
use Alert;
use Carbon\Carbon;

class Sub_CategoryController extends Controller
{
    public function index(Request $request,Sub_categoriesDataTable $dataTable)
    {

        return $dataTable->render('sub_category.index');
        
    }
    public function addView(Request $request)
    {
        $data['Category'] = Category::get();
        if(isset($request->id)){
            $data['subcategory'] = Sub_category::where('id',$request->id)->first();
        }else{
            $data['subcategory'] = '';
        }   
        return view('sub_category.add',$data);
    }

    public function store(Request $request)
    {
        if($request->action == 'insert'){
            $obj = new Sub_category();
            $obj->created_at = date('Y-m-d H:i:s');
        }else{
            $obj = Sub_category::find($request->id);
            $obj->updated_at = date('Y-m-d H:i:s');
        }
        $obj->fk_category_id = isset($request->fk_category_id) ? $request->fk_category_id : $obj->fk_category_id;
        $obj->name = isset($request->name) ? $request->name : $obj->name;
        $obj->save();
       
        Alert::success('Congrats', 'You have Successfully Data Submit');
        
        return redirect('sub_category/list');
    }
    public function destroy($id)
    {
        try {
            Sub_category::where('id', $id)->delete();
            return response()->json([
                "status" => true,
            ]);
        } catch (\Exception $e){
            return $e->getMessage();
        }
    }
}
