<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Events\AutomaticNotificationEvent;
use Illuminate\Support\Facades\Log;
use DB;
use Illuminate\Notifications\Notifiable;

class NotificationController extends Controller
{
    public function sendUserAssignedNotification(Request $request)
    {
       
        $userId = $request->input('id');
        $message = "Assign Event ";
       
        // $user = User::find($userId);
        $user = DB::table('users')->where('user_id', $userId)->first();
      
        if ($user) {
            // Trigger notification
            $user->notify(new AutomaticNotificationEvent($message));
            Log::info('Notification sent to user: ' . $user->user_id);
            return response()->json(['success' => true]);
        } else {
            Log::error('User not found');
            return response()->json(['error' => 'User not found'], 404);
        }


        // Logic to send an automatic notification

        // Example: trigger a notification
        // event(new \App\Events\AutomaticNotificationEvent('This is an automatic notification.'));
        
        // return response()->json(['message' => 'Automatic notification sent.']);
    }
}
