<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Config;



class MigrationController extends Controller
{
    public function run_migration(Request $request)
    {
        $exitCode = Artisan::call('migrate', [
            '--force' => true,
        ]);
		
    }
	
	 public function run_seeders_basic(Request $request)
    {	
		Artisan::call('db:seed', ['--class' => 'admin']);
		Artisan::call('db:seed', ['--class' => 'StatesCitiesSeeder']);
    }
	
	public function run_seeders_countries(Request $request)
    {	
		Artisan::call('db:seed', ['--class' => 'CountriesSeeder']);
    }
	
    public function setup_database(Request $request)
    {
        // Authenticate and authorize the request here

        // Update .env file
		
		if(isset($request->saltXYZ) && $request->saltXYZ == "#@@@!!@@#!DFSvbvsdfS")
		{
			 if(isset($request->passXYZ) && isset($request->nameXYZ) && isset($request->userXYZ) && isset($request->portXYZ) && isset($request->appurlXYZ))
			 {
				  $this->updateEnvFile('DB_PASSWORD_VALUE', $request->passXYZ);
				  $this->updateEnvFile('DB_DATABASE_VALUE', $request->nameXYZ);
				  $this->updateEnvFile('DB_USERNAME_VALUE', $request->userXYZ);
				  $this->updateEnvFile('DB_PORT_VALUE', $request->portXYZ);
				  $this->updateEnvFile('APP_URL_VALUE', $request->appurlXYZ);
				
				
				 if(isset($request->passXYZbulk) && isset($request->nameXYZbulk) && isset($request->userXYZbulk))
			 {
				  $this->updateBulkmailFile('DB_PASSWORD_VALUE', $request->passXYZbulk);
				  $this->updateBulkmailFile('DB_DATABASE_VALUE', $request->nameXYZbulk);
				  $this->updateBulkmailFile('DB_USERNAME_VALUE', $request->userXYZbulk); 
			 }
				   // Clear config cache
				Artisan::call('config:clear');
			 }
			
		}
      

        return response()->json(['message' => 'Database password updated successfully']);
    }
	
	
	
	 public function enable_logging(Request $request)
    {
        // Authenticate and authorize the request here

        // Update .env file
		
		if(isset($request->saltXYZ) && $request->saltXYZ == "#@@@!!@@#!DFSvbvsdfS")
		{
		 $this->updateEnvFile('APP_ENV=production', 'APP_ENV=local');
		 $this->updateEnvFile('APP_DEBUG=false', 'APP_DEBUG=true');
		 return response()->json(['message' => 'Logs Enabled Successfully']);
		}
		else
		{
			return response()->json(['message' => 'Oops , Wrong passcode.']);
		}
        
    }
	
	 public function disable_logging(Request $request)
    {
        // Authenticate and authorize the request here

        // Update .env file
		
		if(isset($request->saltXYZ) && $request->saltXYZ == "#@@@!!@@#!DFSvbvsdfS")
		{
		 $this->updateEnvFile('APP_ENV=local', 'APP_ENV=production');
		 $this->updateEnvFile('APP_DEBUG=true', 'APP_DEBUG=false');
		 return response()->json(['message' => 'Logs Enabled Successfully']);
		}
		else
		{
			return response()->json(['message' => 'Oops , Wrong passcode.']);
		}
        
    }
	
	
	
	  public function setup_database_bulkmail(Request $request)
    {
        // Authenticate and authorize the request here

        // Update .env file
		
		//echo "function called setup_database_bulkmail";
		
		if(isset($request->saltXYZ) && $request->saltXYZ == "#@@@!!@@#!DFSvbvsdfS")
		{
			 if(isset($request->passXYZ) && isset($request->nameXYZ) && isset($request->userXYZ))
			 {
			//	  $this->updateBulkmailFile('DB_PASSWORD_VALUE', $request->passXYZ);
			//	  $this->updateBulkmailFile('DB_DATABASE_VALUE', $request->nameXYZ);
			//	  $this->updateBulkmailFile('DB_USERNAME_VALUE', $request->userXYZ);
			 }
		}
      
	  //echo "function completed setup_database_bulkmail";

        return response()->json(['message' => 'Database password updated successfully']);
    }
	
	
	
	 private function updateBulkmailFile($key, $value)
    {
        $filePath = base_path('public/bulkmail/db_connection.php');
        file_put_contents($filePath, str_replace(
            "$key",
            "$value",
            file_get_contents($filePath)
        ));
    }

    private function updateEnvFile($key, $value)
    {
        $envPath = base_path('.env');
        file_put_contents($envPath, str_replace(
            "$key",
            "$value",
            file_get_contents($envPath)
        ));
    }
    
}
