<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Event;
use App\Models\User;
use App\Models\Visitor;
use App\Models\Product;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
        $this->_event = new Event();
        $this->_user = new User();
        $this->_visitor = new Visitor();
        $this->_product = new Product();
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $data['events'] = $this->_event->countEvents();
        $data['users'] = $this->_user->countUsers();
        $data['visitors'] = $this->_visitor->countVisitors();
        $data['products'] = $this->_product->countProducts();

        return view('dashboard', $data);
    }
    // public function chartjs()  
    // {  
    // $viewer = View::select(DB::raw("SUM(numberofview) as count"))  
    //     ->orderBy("created_at")  
    //     ->groupBy(DB::raw("year(created_at)"))  
    //     ->get()->toArray();  
    // $viewer = array_column($viewer, 'count');  
      
    // $click = Click::select(DB::raw("SUM(numberofclick) as count"))  
    //     ->orderBy("created_at")  
    //     ->groupBy(DB::raw("year(created_at)"))  
    //     ->get()->toArray();  
    // $click = array_column($click, 'count');  
      
    // return view('chartjs')  
    //         ->with('viewer',json_encode($viewer,JSON_NUMERIC_CHECK))  
    //         ->with('click',json_encode($click,JSON_NUMERIC_CHECK));  
    // }  
}
