<?php

namespace App\Http\Controllers;
use Alert;
use Illuminate\Http\Request;
use App\DataTables\EventsDataTable;
use App\DataTables\EventUsersDataTable;
use App\Models\Event; 
use App\Models\EventUser;
use App\Models\Sendpush;
use DB;
use Carbon\Carbon;
use App\Models\Visitor;
use App\Models\User;
use Log;
use Illuminate\Support\Facades\Notification;
use App\Events\AutomaticNotificationEvent;
use App\Jobs\SendNotification;

class EventController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->_event = new Event();
        $this->_eventuser = new EventUser();
    }
    public function index(Request $request,EventsDataTable $dataTable)
    {

        return $dataTable->render('events.index');

    }
    public function addView(Request $request,EventUsersDataTable $dataTable)
    {
        $eventid=$request->id;
        $eventname =DB::table('events')->where('id',$eventid)->first();
        $assignedUsers = DB::table('event_assignments')
            ->select('users.user_id','event_assignments.*')
            ->leftjoin('users', 'users.user_id', 'event_assignments.fk_user_id')
            ->where('event_assignments.fk_event_id', $eventid)
            ->get()->pluck('user_id')->toArray();
        //dd($assignedUsers);
        $users =  EventUser::where('users.is_delete','=','false')->orderBy('CustomerID', 'asc')->get();
        //dd($users);
        return view('events.eventlist_new',compact('eventid','eventname','users','assignedUsers'));

        //return $dataTable->with(['eventid' => $eventid])->render('events.eventlist',compact('eventid','eventname'));

    }
    public function store(Request $request,EventUsersDataTable $dataTable)
    {
        $id = $request->id;
        DB::table('event_assignments')->where('fk_event_id',$id)->delete();

        if(isset($request->customerids)){
            foreach($request->customerids as $key =>$user_id)
            {
                $query = DB::table('event_assignments')
                ->where('fk_user_id',$user_id)
                ->where('fk_event_id',$id)
                ->count();
                if($query == 0)
                {

                 $data =  [
                     'fk_user_id' => $user_id,
                     'fk_event_id' => $id,
                 ];

                 $insert =DB::table('event_assignments')->insert($data);
                }
             }
        }
        return redirect('event/list');
    }
    public function destroy($id)
    {
        try {
            Visitor::where('event_id',$id)->delete();
            DB::table('event_assignments')->where('fk_event_id',$id)->delete();
            Event::where('id', $id)->delete();
            return response()->json([
                "status" => true,
            ]);
        } catch (\Exception $e){
            return $e->getMessage();
        }
    }
    public function addevent()
    {
        $now = Carbon::now()->format('Y-m-d');
        return view('events/addevent',compact('now'));
    }
    public function addeventstore(Request $request)
    {
        $data = [
            'event_name' => $request->eventname,
            'city' => $request->city,
            'details' => $request->details,
            'start_date' => $request->start_date,
            'end_date' => $request->end_date,
            'type_show_all' => isset($request->type_show_all) ? $request->type_show_all : 'false',
            'created_at' => date('Y-m-d H:i:s'),
        ];
        $insert_id =DB::table('events')->insertGetId($data);
        $get_user = DB::table('users')->where('is_admin','=','true')->get();
        foreach($get_user as $one_user){
            $detail = ([
                'fk_user_id' => $one_user->user_id,
                'fk_event_id' => $insert_id,
                'is_admin' => 'true',
                'created_date' => date('Y-m-d H:i:s'),
            ]);
            DB::table('event_assignments')->insert($detail);
        }
        Alert::success('Congrats', 'You\'ve Successfully Data Inserted');
        return redirect('event/list');
    }
    public function editView(Request $request)
    {
        $get_data =DB::table('events')->where('id',$request->id)->first();

        $now = Carbon::now()->format('Y-m-d');
        return view('events/editevent',compact('now','get_data'));
    }
    public function editeventstore(Request $request)
    {

        $data = [
            'event_name' => $request->eventname,
            'city' => $request->city,
            'details' => $request->details,
            'start_date' => $request->start_date,
            'end_date' => $request->end_date,
            'type_show_all' => $request->type_show_all,
            'updated_at' =>  date('Y-m-d H:i:s'),
        ];
        $update =DB::table('events')->where('id',$request->id)->update($data);
        Alert::success('Congrats', 'You\'ve Successfully Data Update');

        return redirect('event/list');
    }
    public function assignadminview(Request $request)
    {
        $id=$request->id;
        $data =DB::table('event_assignments')
        ->select('users.CustomerID','users.CustomerName','event_assignments.*')
        ->leftjoin('users', 'users.user_id', 'event_assignments.fk_user_id')
        ->where('event_assignments.fk_event_id', $id)
        ->where('users.user_id','!=',null)
        ->get();

        return view('events.eventassignadmin',compact('data'));
    }

    public function storeadminassign(Request $request)
    {

        if($request->isadminvalue == 'true') {
            $isadmin = 'false';
        } else {
            $isadmin = 'true';
        }

        $data = [
            'id' => $request->id,
            'is_admin' => $isadmin,
        ];
        $result= DB::table('event_assignments')->where('id', $request->id)->update($data);
        return redirect()->back();
    }

    public function assignUser(Request $request)
    {
        if($request->operation == 'add')
        {
            DB::table('event_assignments')->insert([
                'fk_user_id' => $request->user_id,
                'fk_event_id' => $request->event_id,
            ]);
           
            $id = $request->user_id;
            $type = "eventassign";
            SendNotification::dispatch($id,$type);
            
        }
        else if($request->operation == 'remove')
        {
            $assignedUser = DB::table('event_assignments')
                ->where('fk_user_id',$request->user_id)
                ->where('fk_event_id',$request->event_id)->first();
            if($assignedUser){
                // $assignedUser->delete();
                DB::table('event_assignments')
                ->where('fk_user_id',$request->user_id)
                ->where('fk_event_id',$request->event_id)->delete();
            }
        }
        return redirect()->back();
    }
}
