<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\DataTables\CategoryDataTable;
use App\Models\Category;
use DB;
use Alert;
use Carbon\Carbon;

class CategoryController extends Controller
{
    public function index(Request $request,CategoryDataTable $dataTable)
    {

        return $dataTable->render('category.index');
        
    }
    public function addView(Request $request)
    {
        if(isset($request->id)){
            $data['category'] = Category::where('id',$request->id)->first();
        }else{
            $data['category'] = '';
        }   
        return view('category.add',$data);
    }

    public function store(Request $request)
    {
        if($request->action == 'insert'){
            $obj = new Category();
            $obj->created_at = date('Y-m-d H:i:s');
        }else{
            $obj = Category::find($request->id);
            $obj->updated_at = date('Y-m-d H:i:s');
        }
        $obj->name = isset($request->name) ? $request->name : $obj->name;
        $obj->save();
       
        Alert::success('Congrats', 'You have Successfully Data Submit');
        
        return redirect('category/list');
    }
    public function destroy($id)
    {
        try {
            Category::where('id', $id)->delete();
            return response()->json([
                "status" => true,
            ]);
        } catch (\Exception $e){
            return $e->getMessage();
        }
    }
}
