<?php

namespace App\DataTables;

use App\Models\EmailBatch;
use App\Models\Visitor;
use Carbon\Carbon;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Html\Editor\Editor;
use Yajra\DataTables\Html\Editor\Fields;
use Yajra\DataTables\Services\DataTable;

class VisitorBatchDataTable extends DataTable
{
    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
        return datatables()
            ->eloquent($query)
            ->editColumn('created_by', function($row) {
                return $row->admin->name ?? null;
            })
            ->editColumn('created_at', function($row) {
                return Carbon::parse($row->created_at);
            })
            ->editColumn('schedule_date', function($row) {
                return Carbon::parse($row->schedule_date);
            })
            ->addColumn('action', function($row) {
                $emailBatch = "EmailBatch";
                return '<a data-toggle="modal" data-target="#deletePopup" data-url="'.route('visitor.batch-delete',$row->id).'"  data-id="'.$row->id.'" data-email_batch="'.$emailBatch.'"
                    onclick="deletePopup(this)">
                    <button class="btn btn-danger btn-sm" data-toggle="tooltip" data-placement="right" title="Delete ">
                        <i class="fas fa-trash" aria-hidden="true"></i>
                    </button>
                </a>';
            })
            ->rawColumns(['action']);
        }

    public function query(EmailBatch $model)
    {
        return $model->with('admin')->orderBy('created_at');
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {
        return $this->builder()
                    ->setTableId('visitor-batch-table')
                    ->columns($this->getColumns())
                    ->minifiedAjax()
                    ->dom('Bfrtip')
                    ->orderBy(1)
                    ->stateSave(true);
    }

    /**
     * Get columns.
     *
     * @return array
     */
    protected function getColumns()
    {
        return [

            Column::make('created_by'),
            Column::make('email_type'),
            Column::make('hour_interval_mails')->title('Hour Interval'),
            Column::make('last_id_sent')->title('Last Client Id Sent'),
            Column::make('status'),
            Column::make('schedule_date'),
            Column::make('created_at'),
            Column::computed('action')->title('Action'),
        ];
    }
}
