<?php

namespace App\DataTables;

use App\Models\User;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Html\Editor\Editor;
use Yajra\DataTables\Html\Editor\Fields;
use Yajra\DataTables\Services\DataTable;

class UsersDataTable extends DataTable
{
    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
            return datatables()
            ->eloquent($query)
            ->addColumn('action', function($row) {
                $user = "User";
                return '<a data-toggle="modal" data-target="#deletePopup" data-url="'.route('users.destroy',$row->user_id).'"  data-id="'.$row->user_id.'" data-user="'.$user.'"
                            onclick="deletePopup(this)">
                            <button class="btn btn-danger btn-sm" data-toggle="tooltip" data-placement="right" title="Delete ">
                                <i class="fas fa-trash" aria-hidden="true"></i>
                            </button>
                        </a>
                        <a data-toggle="modal" onclick="assignEmail(this)" data-follow_up="'.$row->follow_up_email.'" data-primary="'.$row->primary_email.'" id="'.$row->user_id.'" class="btn btn-primary btn-sm btnAssignEmail" title="Assign Email">
                            <i class="fas fa-plus" aria-hidden="true"></i> Assign Email Draft
                        </a> ';
            })
            ->addColumn('email_update', function ($row) {
                // $btn = '<a class="btn btn-primary btn-sm" onclick="emailupdate(this)" sender_name="' .$row->sender_name . '" sender_email="' . $row->sender_email . '" cc_email="' . $row->cc_email . '" bcc_email="' . $row->bcc_email . '" id="'. $row->user_id .'"><i class="fa fa-edit"></i></a><br>';
                return '<a href="'.route('users.edit_email').'?CustomerID='.$row->CustomerID.'">
                            <button class="btn btn-primary btn-sm" title="Permissions" type="button" style="color: #f8f9fa;">
                                <i class="bx bxs-edit"></i>Edit Email
                            </button>
                        </a>';

            })
            ->editColumn('is_admin', function ($row) {
                if($row->is_admin == "true") {
                    $selected = "checked";
                } else {
                    $selected = "";
                }
                $btn  = '<input type="checkbox" class="btn bg-gradient-success btn-sm"  '.$selected.' data-CustomerID="'.$row->CustomerID.'" data-user_id="'.$row->user_id.'" onclick="updateIsAdmin(this)" value="'.$row->is_admin.'">';
                return $btn;

            })
            ->addColumn('permissions', function($row) {
                $user = "User";
                return '<a href="'.route('users.permissionsview').'?CustomerID='.$row->CustomerID.'">
                            <button class="btn btn-block bg-gradient-info btn-sm" title="Permissions" type="button" style="color: #f8f9fa;">
                                <i class="bx bxs-edit" aria-hidden="true" ></i>Permissions 
                            </button>
                        </a>';
            })
            ->rawColumns(['action', 'is_admin', 'email_update','permissions','replace','location']);
    }
    
    /**
     * Get query source of dataTable.
     *
     * @param \App\Models\User $model
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(User $model)
    {
        // return $model->newQuery();
        return $model->fetchAllUsers();
        // return $this->applyScopes($data);
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {
        return $this->builder()
                    ->setTableId('users-table')
                    ->columns($this->getColumns())
                    ->minifiedAjax()
                    ->dom('Bfrtip')
                    ->orderBy(1)
                    ->buttons(
                        Button::make('create'),
                        Button::make('export'),
                        Button::make('print'),
                        Button::make('reset'),
                        Button::make('reload')
                    );
    }

    /**
     * Get columns.
     *
     * @return array
     */
    protected function getColumns()
    {
        return [
            Column::make('Email')->title('Email Id'),
            Column::make('CustomerID')->title('Customer Id'),
            Column::make('CustomerName')->title('Name'),
            Column::make('expiry_date')->title('Expiry_Date'),
            Column::make('is_admin')->title('Is_Admin'),
            Column::make('email_update')->title('Email Configuration'),
            Column::computed('permissions')->title(''),
            Column::computed('action')
                  ->exportable(false)
                  ->printable(false)
                  ->width('20%')
                  ->addClass('text-center'),
        ];
    }

    /**
     * Get filename for export.
     *
     * @return string
     */
    protected function filename()
    {
        return 'Users_' . date('YmdHis');
    }
}