<?php

namespace App\DataTables;

use App\Models\Product;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Html\Editor\Editor;
use Yajra\DataTables\Html\Editor\Fields;
use Yajra\DataTables\Services\DataTable;
use DB;
class ProductsDataTable extends DataTable
{
    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
        return datatables()
            ->eloquent($query)
            ->editColumn('name', function($row) {
                $btn = $row->name;
                $btn .= '<br><button style="width:25%;" class="btn btn-sm btn-primary btn-'.$row->id.'" data-name="'.$row->name.'" onclick="editname('.$row->id.');">Edit</button>';
                return $btn ;
            })
            ->addColumn('image', function($row) {
                return '<span id="viewButton">
                        <button class="btn btn-primary btn-sm" data-id="' . $row->id . '" onclick="showfilewithimage(this)">View</button>
                        </span>';
            })
            // ->addColumn('action', function($row) {
            //     $btn = '<a href="'.route('product.detail').'?id='.$row->id.'">
            //                 <button class="btn btn-block bg-gradient-info btn-sm" data-toggle="tooltip" data-placement="left" title="Detail" style="color: white;">
            //                     <i class="bx bxs-edit" aria-hidden="true"></i>Detail
            //                 </button>
            //             </a>';
            //     return $btn;
            // })
            ->addColumn('Visitor_Intrested_Product', function($row) {
                    $id=$row->id;
                    $productcount =DB::table('visitor_products')
                    ->where('product_id',$id)
                    ->count();

                return '<a href="'.route('product.visitorproductcount').'?id='.$row->id.'">'.$productcount.'</a>';
            })->addColumn('delete', function($row) {
                    $product="Product";
                return '<a data-toggle="modal" data-target="#deletePopup" data-url="'.route('product.destroy',$row->id).'" data-user="'.$product.'" data-id="'.$row->id.'"
                        onclick="deletePopup(this)">
                            <button class="btn btn-danger btn-sm" data-toggle="tooltip" data-placement="right" title="Delete ">
                                <i class="fas fa-trash" aria-hidden="true"></i>
                            </button>
                        </a>';
            })->rawColumns(['image','action','Visitor_Intrested_Product','delete','edit','name']);
    }

    /**
     * Get query source of dataTable.
     *
     * @param \App\Models\Product $model
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(Product $model)
    {
        return $model->fetchAllProduct();
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {
        return $this->builder()
                    ->setTableId('products-table')
                    ->columns($this->getColumns())
                    ->minifiedAjax()
                    ->dom('Bfrtip')
                    ->orderBy(1)
                    ->buttons(
                        Button::make('create'),
                        Button::make('export'),
                        Button::make('print'),
                        Button::make('reset'),
                        Button::make('reload')
                    );
    }

    /**
     * Get columns.
     *
     * @return array
     */
    protected function getColumns()
    {
        return [
           
            // Column::make('fk_user_id','users.user_id')->title('User Id'),
            Column::computed('name')->title('Name'),
            Column::computed('image')->title('Product Image'),
            Column::computed('Visitor_Intrested_Product')->title('Client Intrested Product'),
            // Column::computed('action')->title('Action'),
            Column::computed('delete')->title('Action'),

            // Column::computed('action')
            // ->exportable(false)
            // ->printable(false)
            // ->width(60)
            // ->addClass('text-center'),
        ];
    }

    /**
     * Get filename for export.
     *
     * @return string
     */
    protected function filename()
    {
        return 'Products_' . date('YmdHis');
    }
}
